/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.impl.CompanyAdressImpl;
import com.openindex.openestate.impl.PersonAdressImpl;
import com.openindex.openestate.impl.SimpleAdressImpl;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.CountryObject;
import com.openindex.openestate.tool.utils.ModificationHandler;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationPattern;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class JAdressPanel
extends JPanel {
    public static final int LAYOUT_1_COLS = 1;
    public static final int LAYOUT_2_COLS = 2;
    private static final Logger LOGGER = Logger.getLogger(JAdressPanel.class);
    private ValidationHandler validationHandler = null;
    private ModificationHandler modifications = ImmoToolUtils.createModificationHandler();
    private ResourceMap resourceMap = null;
    protected JPanel adressFormPanel = null;
    protected JTextField adressStreetField = null;
    protected JTextField adressStreetNrField = null;
    protected JTextField adressCityField = null;
    protected JTextField adressCityPartField = null;
    protected JTextField adressPostalCodeField = null;
    protected JComboBox adressCountryField = null;
    protected JTextField adressRegionField = null;
    protected JPanel personFormPanel = null;
    protected JComboBox personGenderField = null;
    protected JTextField personFirstNameField = null;
    protected JTextField personMiddleNameField = null;
    protected JTextField personLastNameField = null;
    protected JTextField personMailField = null;
    protected JTextField personPhoneField = null;
    protected JTextField personPhoneMobileField = null;
    protected JTextField personFaxField = null;
    protected JTextField personTitleField = null;
    protected JPanel companyFormPanel = null;
    protected JTextField companyNameField = null;
    protected JTextField companyNameAdditionField = null;
    protected JTextField companyTypeField = null;
    protected JTextField companyPositionField = null;
    protected JTextField companyBusinessField = null;
    protected JTextField companyDepartmentField = null;
    protected JTextField companyMailField = null;
    protected JTextField companyPhoneField = null;
    protected JTextField companyPhoneMobileField = null;
    protected JTextField companyFaxField = null;
    protected JTextField companyWebsiteField = null;
    protected JButton companyWebsiteButton = null;
    private String lastCheckedCompanyWebsite = null;
    protected boolean isPersonAdress = false;
    protected boolean isCompanyAdress = false;

    public JAdressPanel() {
        this((SimpleAdressImpl)null);
    }

    public JAdressPanel(SimpleAdressImpl simpleAdressImpl) {
        this(simpleAdressImpl, 2);
    }

    public JAdressPanel(SimpleAdressImpl simpleAdressImpl, int n) {
        this(simpleAdressImpl, n, 0);
    }

    public JAdressPanel(SimpleAdressImpl simpleAdressImpl, int n, int n2) {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.resourceMap = ImmoToolUtils.getResourceMap(JAdressPanel.class);
        this.build(n, n2);
        this.resourceMap.injectComponents((Component)this);
        if (simpleAdressImpl != null) {
            this.loadAdress(simpleAdressImpl);
        }
        this.init();
    }

    private void build(int n, int n2) {
        this.adressStreetField = new JTextField();
        this.adressStreetField.setName("adressStreetField");
        this.adressStreetField.setColumns(15);
        this.adressStreetNrField = new JTextField();
        this.adressStreetNrField.setName("adressStreetNrField");
        this.adressStreetNrField.setColumns(5);
        this.adressPostalCodeField = new JTextField();
        this.adressPostalCodeField.setName("adressPostalCodeField");
        this.adressPostalCodeField.setColumns(5);
        this.adressCityField = new JTextField();
        this.adressCityField.setName("adressCityField");
        this.adressCityField.setColumns(15);
        this.adressCityPartField = new JTextField();
        this.adressCityPartField.setName("adressCityPartField");
        this.adressCityPartField.setColumns(20);
        this.adressRegionField = new JTextField();
        this.adressRegionField.setName("adressRegionField");
        this.adressRegionField.setColumns(20);
        this.adressCountryField = new JComboBox<CountryObject>(CountryObject.getObjects());
        this.adressCountryField.setPrototypeDisplayValue("XXXXXXXXXXXXXXXX");
        this.adressCountryField.setName("adressCountryField");
        this.selectCountry(SystemUtils.USER_COUNTRY);
        AutoCompleteDecorator.decorate((JComboBox)this.adressCountryField, (ObjectToStringConverter)new ObjectToStringConverter(){

            public String getPreferredStringForItem(Object object) {
                if (object instanceof CountryObject) {
                    return ((CountryObject)object).getName();
                }
                return "-";
            }
        });
        this.personTitleField = new JTextField();
        this.personTitleField.setName("personTitleField");
        this.personTitleField.setColumns(15);
        this.personFirstNameField = new JTextField();
        this.personFirstNameField.setName("personFirstNameField");
        this.personFirstNameField.setColumns(20);
        this.personMiddleNameField = new JTextField();
        this.personMiddleNameField.setName("personMiddleNameField");
        this.personMiddleNameField.setColumns(20);
        this.personLastNameField = new JTextField();
        this.personLastNameField.setName("personLastNameField");
        this.personLastNameField.setColumns(20);
        this.personPhoneField = new JTextField();
        this.personPhoneField.setName("personPhoneField");
        this.personPhoneField.setColumns(20);
        this.personPhoneMobileField = new JTextField();
        this.personPhoneMobileField.setName("personPhoneMobileField");
        this.personPhoneMobileField.setColumns(20);
        this.personMailField = new JTextField();
        this.personMailField.setName("personMailField");
        this.personMailField.setColumns(20);
        this.personFaxField = new JTextField();
        this.personFaxField.setName("personFaxField");
        this.personFaxField.setColumns(20);
        this.personGenderField = new JComboBox();
        this.personGenderField.setName("personGenderField");
        this.personGenderField.setPrototypeDisplayValue("XXXXX");
        this.personGenderField.setRenderer(new GenderRenderer());
        this.personGenderField.addItem("empty");
        this.personGenderField.addItem("female");
        this.personGenderField.addItem("male");
        this.companyNameField = new JTextField();
        this.companyNameField.setName("companyNameField");
        this.companyNameField.setColumns(20);
        this.companyNameAdditionField = new JTextField();
        this.companyNameAdditionField.setName("companyNameAdditionField");
        this.companyNameAdditionField.setColumns(20);
        this.companyTypeField = new JTextField();
        this.companyTypeField.setName("companyTypeField");
        this.companyTypeField.setColumns(20);
        this.companyBusinessField = new JTextField();
        this.companyBusinessField.setName("companyBusinessField");
        this.companyBusinessField.setColumns(20);
        this.companyPositionField = new JTextField();
        this.companyPositionField.setName("companyPositionField");
        this.companyPositionField.setColumns(20);
        this.companyDepartmentField = new JTextField();
        this.companyDepartmentField.setName("companyDepartmentField");
        this.companyDepartmentField.setColumns(20);
        this.companyPhoneField = new JTextField();
        this.companyPhoneField.setName("companyPhoneField");
        this.companyPhoneField.setColumns(20);
        this.companyPhoneMobileField = new JTextField();
        this.companyPhoneMobileField.setName("companyPhoneMobileField");
        this.companyPhoneMobileField.setColumns(20);
        this.companyMailField = new JTextField();
        this.companyMailField.setName("companyMailField");
        this.companyMailField.setColumns(20);
        this.companyFaxField = new JTextField();
        this.companyFaxField.setName("companyFaxField");
        this.companyFaxField.setColumns(20);
        this.companyWebsiteField = new JTextField("http://");
        this.companyWebsiteField.setName("companyWebsiteField");
        this.companyWebsiteField.setColumns(20);
        this.companyWebsiteField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                JAdressPanel.this.initCompanyWebsiteButton();
            }
        });
        this.companyWebsiteButton = new JButton();
        this.companyWebsiteButton.setName("companyWebsiteButton");
        this.companyWebsiteButton.setEnabled(false);
        this.companyWebsiteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                URL uRL = null;
                try {
                    uRL = new URL(JAdressPanel.this.companyWebsiteField.getText().trim());
                    if (uRL != null && !StringUtils.isBlank((String)uRL.getHost())) {
                        ImmoToolUtils.openURL(uRL);
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Can't open company website!");
                    LOGGER.warn((Object)("> " + JAdressPanel.this.companyWebsiteField.getText().trim()));
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
        });
        this.resourceMap.injectComponent((Component)this.companyWebsiteButton);
        this.registerValidation(this.adressCountryField, ValidationHandler.NOT_BLANK);
        this.registerValidation(this.personMailField, new ValidationRule(){

            @Override
            public boolean isValid(Object object) {
                return object == null || StringUtils.isBlank((String)object.toString()) ? true : ValidationHandler.EMAIL.isValid(object.toString().trim());
            }
        });
        this.registerValidation(this.companyWebsiteField, new ValidationPattern("(\\z|https?://.*)"));
        this.registerValidation(this.companyMailField, new ValidationRule(){

            @Override
            public boolean isValid(Object object) {
                return object == null || StringUtils.isBlank((String)object.toString()) ? true : ValidationHandler.EMAIL.isValid(object.toString().trim());
            }
        });
        String string = n2 > 0 ? n2 + "dlu" : "40dlu";
        this.adressFormPanel = this.buildAdressPanel(string).getPanel();
        this.personFormPanel = this.buildPersonPanel(string).getPanel();
        this.companyFormPanel = this.buildCompanyPanel(string).getPanel();
        this.removeAll();
        if (1 == n) {
            this.companyFormPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0), this.companyFormPanel.getBorder()));
            this.personFormPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0), this.personFormPanel.getBorder()));
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            jPanel.add((Component)this.adressFormPanel, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            jPanel.add((Component)this.companyFormPanel, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            jPanel.add((Component)this.personFormPanel, gridBagConstraints);
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "North");
        } else {
            this.companyFormPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0), this.companyFormPanel.getBorder()));
            this.personFormPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0), this.personFormPanel.getBorder()));
            int n3 = this.adressFormPanel.getPreferredSize().width;
            if (n3 < this.personFormPanel.getPreferredSize().width) {
                n3 = this.personFormPanel.getPreferredSize().width;
            }
            if (n3 < this.companyFormPanel.getPreferredSize().width) {
                n3 = this.companyFormPanel.getPreferredSize().width;
            }
            this.adressFormPanel.setPreferredSize(new Dimension(n3, this.adressFormPanel.getPreferredSize().height));
            this.personFormPanel.setPreferredSize(new Dimension(n3, this.personFormPanel.getPreferredSize().height));
            this.companyFormPanel.setPreferredSize(new Dimension(n3, this.companyFormPanel.getPreferredSize().height));
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            jPanel.add((Component)this.adressFormPanel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 3;
            jPanel.add((Component)this.companyFormPanel, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridheight = 1;
            jPanel.add((Component)this.personFormPanel, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            jPanel.add((Component)new JLabel(""), gridBagConstraints);
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "North");
        }
    }

    protected DefaultFormBuilder buildAdressPanel(String string) {
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder("right:[" + string + ",pref], 3dlu, 30dlu:grow, 3dlu, " + "right:pref, 3dlu, 30dlu");
        defaultFormBuilder.border(Borders.EMPTY);
        JComponent jComponent = this.buildAdressPanelTitle();
        if (jComponent != null) {
            defaultFormBuilder.append((Component)jComponent, 7);
            defaultFormBuilder.nextLine();
        }
        defaultFormBuilder.append(this.resourceMap.getString("label.adress.street", new Object[0]), (Component)this.adressStreetField);
        defaultFormBuilder.append(this.resourceMap.getString("label.adress.streetNr", new Object[0]), (Component)this.adressStreetNrField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.adress.city", new Object[0]), (Component)this.adressCityField);
        defaultFormBuilder.append(this.resourceMap.getString("label.adress.postalCode", new Object[0]), (Component)this.adressPostalCodeField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.adress.cityPart", new Object[0]), (Component)this.adressCityPartField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.adress.country", new Object[0]), (Component)this.adressCountryField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.adress.countryArea", new Object[0]), (Component)this.adressRegionField, 5);
        defaultFormBuilder.nextLine();
        return defaultFormBuilder;
    }

    protected JComponent buildAdressPanelTitle() {
        return ImmoToolUtils.createHead2Separator(this.resourceMap.getString("label.adress", new Object[0]));
    }

    protected DefaultFormBuilder buildCompanyPanel(String string) {
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder("right:[" + string + ",pref], 3dlu, 50dlu:grow, 3dlu, pref");
        defaultFormBuilder.border(Borders.EMPTY);
        JComponent jComponent = this.buildCompanyPanelTitle();
        if (jComponent != null) {
            defaultFormBuilder.append((Component)jComponent, 5);
            defaultFormBuilder.nextLine();
        }
        defaultFormBuilder.append(this.resourceMap.getString("label.company.name", new Object[0]), (Component)this.companyNameField, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.company.type", new Object[0]), (Component)this.companyTypeField, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.company.addition", new Object[0]), (Component)this.companyNameAdditionField, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.company.business", new Object[0]), (Component)this.companyBusinessField, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.company.position", new Object[0]), (Component)this.companyPositionField, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.company.department", new Object[0]), (Component)this.companyDepartmentField, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.company.phone", new Object[0]), (Component)this.companyPhoneField, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.company.email", new Object[0]), (Component)this.companyMailField, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.company.cellphone", new Object[0]), (Component)this.companyPhoneMobileField, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.company.fax", new Object[0]), (Component)this.companyFaxField, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.company.website", new Object[0]), (Component)this.companyWebsiteField, (Component)this.companyWebsiteButton);
        defaultFormBuilder.nextLine();
        return defaultFormBuilder;
    }

    protected JComponent buildCompanyPanelTitle() {
        return ImmoToolUtils.createHead2Separator(this.resourceMap.getString("label.company", new Object[0]));
    }

    protected DefaultFormBuilder buildPersonPanel(String string) {
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder("right:[" + string + ",pref], 3dlu, [20dlu,pref], 3dlu, " + "right:pref, 3dlu, 20dlu:grow");
        defaultFormBuilder.border(Borders.EMPTY);
        JComponent jComponent = this.buildPersonPanelTitle();
        if (jComponent != null) {
            defaultFormBuilder.append((Component)jComponent, 7);
            defaultFormBuilder.nextLine();
        }
        defaultFormBuilder.append(this.resourceMap.getString("label.person.gender", new Object[0]), (Component)this.personGenderField);
        defaultFormBuilder.append(this.resourceMap.getString("label.person.title", new Object[0]), (Component)this.personTitleField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.person.firstName", new Object[0]), (Component)this.personFirstNameField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.person.middleName", new Object[0]), (Component)this.personMiddleNameField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.person.lastName", new Object[0]), (Component)this.personLastNameField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.person.phone", new Object[0]), (Component)this.personPhoneField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.person.email", new Object[0]), (Component)this.personMailField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.person.cellphone", new Object[0]), (Component)this.personPhoneMobileField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.person.fax", new Object[0]), (Component)this.personFaxField, 5);
        defaultFormBuilder.nextLine();
        return defaultFormBuilder;
    }

    protected JComponent buildPersonPanelTitle() {
        return ImmoToolUtils.createHead2Separator(this.resourceMap.getString("label.person", new Object[0]));
    }

    public String getSelectedCountry() {
        CountryObject countryObject = (CountryObject)this.adressCountryField.getSelectedItem();
        return countryObject != null ? countryObject.getCode() : null;
    }

    protected void init() {
    }

    public void initInputs() {
        this.validationHandler.init();
        this.initCompanyWebsiteButton();
    }

    private synchronized void initCompanyWebsiteButton() {
        if (this.companyWebsiteButton == null) {
            return;
        }
        String string = this.companyWebsiteField.getText().trim();
        if (string.equalsIgnoreCase(this.lastCheckedCompanyWebsite)) {
            return;
        }
        this.lastCheckedCompanyWebsite = string;
        URL uRL = null;
        try {
            uRL = new URL(this.lastCheckedCompanyWebsite);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.companyWebsiteButton.setEnabled(uRL != null && !StringUtils.isBlank((String)uRL.getHost()));
    }

    public boolean isModifiedInput() {
        return this.modifications.isModified();
    }

    public boolean isValidInput() {
        return this.validationHandler.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAdress(SimpleAdressImpl simpleAdressImpl) {
        Object object;
        this.modifications.clear();
        this.adressStreetField.setText(simpleAdressImpl.getStreet());
        this.adressStreetNrField.setText(simpleAdressImpl.getStreetNr());
        this.adressCityField.setText(simpleAdressImpl.getCity());
        this.adressCityPartField.setText(simpleAdressImpl.getCityPart());
        this.adressPostalCodeField.setText(simpleAdressImpl.getPostalCode());
        this.adressRegionField.setText(simpleAdressImpl.getRegion());
        this.selectCountry(simpleAdressImpl.getCountry());
        this.modifications.putValue(this.adressStreetField);
        this.modifications.putValue(this.adressStreetNrField);
        this.modifications.putValue(this.adressCityField);
        this.modifications.putValue(this.adressCityPartField);
        this.modifications.putValue(this.adressPostalCodeField);
        this.modifications.putValue(this.adressRegionField);
        this.modifications.putValue(this.adressCountryField);
        this.isPersonAdress = simpleAdressImpl instanceof PersonAdressImpl;
        this.personFormPanel.setVisible(this.isPersonAdress);
        this.personFirstNameField.setEnabled(this.isPersonAdress);
        this.personMiddleNameField.setEnabled(this.isPersonAdress);
        this.personLastNameField.setEnabled(this.isPersonAdress);
        this.personTitleField.setEnabled(this.isPersonAdress);
        this.personPhoneField.setEnabled(this.isPersonAdress);
        this.personFaxField.setEnabled(this.isPersonAdress);
        this.personMailField.setEnabled(this.isPersonAdress);
        this.personGenderField.setEnabled(this.isPersonAdress);
        if (this.isPersonAdress && simpleAdressImpl instanceof PersonAdressImpl) {
            object = (PersonAdressImpl)simpleAdressImpl;
            this.personFirstNameField.setText(((PersonAdressImpl)object).getPersonFirstName());
            this.personMiddleNameField.setText(((PersonAdressImpl)object).getPersonMiddleName());
            this.personLastNameField.setText(((PersonAdressImpl)object).getPersonLastName());
            this.personTitleField.setText(((PersonAdressImpl)object).getPersonTitle());
            this.personPhoneField.setText(((PersonAdressImpl)object).getPersonPhone());
            this.personPhoneMobileField.setText(((PersonAdressImpl)object).getPersonMobilePhone());
            this.personFaxField.setText(((PersonAdressImpl)object).getPersonFax());
            this.personMailField.setText(((PersonAdressImpl)object).getPersonMail());
            if (((PersonAdressImpl)object).isFemale()) {
                this.personGenderField.setSelectedItem("female");
            } else if (((PersonAdressImpl)object).isMale()) {
                this.personGenderField.setSelectedItem("male");
            } else {
                this.personGenderField.setSelectedItem("empty");
            }
            this.modifications.putValue(this.personFirstNameField);
            this.modifications.putValue(this.personMiddleNameField);
            this.modifications.putValue(this.personLastNameField);
            this.modifications.putValue(this.personTitleField);
            this.modifications.putValue(this.personPhoneField);
            this.modifications.putValue(this.personPhoneMobileField);
            this.modifications.putValue(this.personFaxField);
            this.modifications.putValue(this.personMailField);
            this.modifications.putValue(this.personGenderField);
        }
        this.isCompanyAdress = simpleAdressImpl instanceof CompanyAdressImpl;
        this.companyFormPanel.setVisible(this.isCompanyAdress);
        this.companyNameField.setEnabled(this.isCompanyAdress);
        this.companyNameAdditionField.setEnabled(this.isCompanyAdress);
        this.companyTypeField.setEnabled(this.isCompanyAdress);
        this.companyDepartmentField.setEnabled(this.isCompanyAdress);
        this.companyPhoneField.setEnabled(this.isCompanyAdress);
        this.companyMailField.setEnabled(this.isCompanyAdress);
        this.companyFaxField.setEnabled(this.isCompanyAdress);
        this.companyPositionField.setEnabled(this.isCompanyAdress);
        this.companyBusinessField.setEnabled(this.isCompanyAdress);
        this.companyWebsiteField.setEnabled(this.isCompanyAdress);
        if (this.isCompanyAdress && simpleAdressImpl instanceof CompanyAdressImpl) {
            object = (CompanyAdressImpl)simpleAdressImpl;
            this.companyNameField.setText(((CompanyAdressImpl)object).getCompanyName());
            this.companyNameAdditionField.setText(((CompanyAdressImpl)object).getCompanyNameAddition());
            this.companyTypeField.setText(((CompanyAdressImpl)object).getCompanyType());
            this.companyDepartmentField.setText(((CompanyAdressImpl)object).getCompanyDepartment());
            this.companyPhoneField.setText(((CompanyAdressImpl)object).getCompanyPhone());
            this.companyPhoneMobileField.setText(((CompanyAdressImpl)object).getCompanyMobilePhone());
            this.companyMailField.setText(((CompanyAdressImpl)object).getCompanyMail());
            this.companyFaxField.setText(((CompanyAdressImpl)object).getCompanyFax());
            this.companyPositionField.setText(((CompanyAdressImpl)object).getCompanyPosition());
            this.companyBusinessField.setText(((CompanyAdressImpl)object).getCompanyBusiness());
            if (((CompanyAdressImpl)object).getCompanyWebsite() != null && !((CompanyAdressImpl)object).getCompanyWebsite().toString().equalsIgnoreCase("http:")) {
                this.companyWebsiteField.setText(((CompanyAdressImpl)object).getCompanyWebsite().toString());
            } else {
                this.companyWebsiteField.setText("http://");
            }
            this.modifications.putValue(this.companyNameField);
            this.modifications.putValue(this.companyNameAdditionField);
            this.modifications.putValue(this.companyTypeField);
            this.modifications.putValue(this.companyDepartmentField);
            this.modifications.putValue(this.companyPhoneField);
            this.modifications.putValue(this.companyPhoneMobileField);
            this.modifications.putValue(this.companyMailField);
            this.modifications.putValue(this.companyFaxField);
            this.modifications.putValue(this.companyPositionField);
            this.modifications.putValue(this.companyBusinessField);
            this.modifications.putValue(this.companyWebsiteField);
        }
        object = this;
        synchronized (object) {
            this.lastCheckedCompanyWebsite = null;
        }
        this.initInputs();
    }

    protected void registerValidation(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        ValidationRule validationRule = ValidationHandler.NOT_BLANK;
        if (jComponent == this.companyMailField) {
            validationRule = ValidationHandler.EMAIL;
        } else if (jComponent == this.personMailField) {
            validationRule = ValidationHandler.EMAIL;
        } else if (jComponent == this.companyWebsiteField) {
            validationRule = ValidationHandler.URL;
        }
        this.registerValidation(jComponent, validationRule);
    }

    protected void registerValidation(JComponent jComponent, ValidationRule validationRule) {
        if (jComponent != null) {
            this.validationHandler.putRule(jComponent, validationRule);
        }
    }

    public void saveAdress(SimpleAdressImpl simpleAdressImpl) {
        PersonAdressImpl personAdressImpl;
        simpleAdressImpl.setStreet(this.adressStreetField.getText().trim());
        simpleAdressImpl.setStreetNr(this.adressStreetNrField.getText().trim());
        simpleAdressImpl.setCity(this.adressCityField.getText().trim());
        simpleAdressImpl.setCityPart(this.adressCityPartField.getText().trim());
        simpleAdressImpl.setPostalCode(this.adressPostalCodeField.getText().trim());
        simpleAdressImpl.setCountry(((CountryObject)this.adressCountryField.getSelectedItem()).getCode());
        simpleAdressImpl.setRegion(this.adressRegionField.getText().trim());
        if (simpleAdressImpl instanceof PersonAdressImpl) {
            personAdressImpl = (PersonAdressImpl)simpleAdressImpl;
            personAdressImpl.setPersonFirstName(this.personFirstNameField.getText().trim());
            personAdressImpl.setPersonMiddleName(this.personMiddleNameField.getText().trim());
            personAdressImpl.setPersonLastName(this.personLastNameField.getText().trim());
            personAdressImpl.setPersonTitle(this.personTitleField.getText().trim());
            personAdressImpl.setPersonFax(this.personFaxField.getText().trim());
            personAdressImpl.setPersonMail(this.personMailField.getText().trim());
            personAdressImpl.setPersonPhone(this.personPhoneField.getText().trim());
            personAdressImpl.setPersonMobilePhone(this.personPhoneMobileField.getText().trim());
            String string = (String)this.personGenderField.getSelectedItem();
            if ("FEMALE".equalsIgnoreCase(string)) {
                personAdressImpl.setPersonGender("FEMALE");
            } else if ("MALE".equalsIgnoreCase(string)) {
                personAdressImpl.setPersonGender("MALE");
            } else {
                personAdressImpl.setPersonGender(null);
            }
        }
        if (simpleAdressImpl instanceof CompanyAdressImpl) {
            personAdressImpl = (CompanyAdressImpl)simpleAdressImpl;
            ((CompanyAdressImpl)personAdressImpl).setCompanyName(this.companyNameField.getText().trim());
            ((CompanyAdressImpl)personAdressImpl).setCompanyNameAddition(this.companyNameAdditionField.getText().trim());
            ((CompanyAdressImpl)personAdressImpl).setCompanyType(this.companyTypeField.getText().trim());
            ((CompanyAdressImpl)personAdressImpl).setCompanyDepartment(this.companyDepartmentField.getText().trim());
            ((CompanyAdressImpl)personAdressImpl).setCompanyPosition(this.companyPositionField.getText().trim());
            ((CompanyAdressImpl)personAdressImpl).setCompanyBusiness(this.companyBusinessField.getText().trim());
            ((CompanyAdressImpl)personAdressImpl).setCompanyPhone(this.companyPhoneField.getText().trim());
            ((CompanyAdressImpl)personAdressImpl).setCompanyMobilePhone(this.companyPhoneMobileField.getText().trim());
            ((CompanyAdressImpl)personAdressImpl).setCompanyMail(this.companyMailField.getText().trim());
            ((CompanyAdressImpl)personAdressImpl).setCompanyFax(this.companyFaxField.getText().trim());
            try {
                ((CompanyAdressImpl)personAdressImpl).setCompanyWebsite(new URL(this.companyWebsiteField.getText().trim()));
            }
            catch (Exception exception) {
                ((CompanyAdressImpl)personAdressImpl).setCompanyWebsite(null);
                LOGGER.warn((Object)"could not load company-website!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
            }
        }
    }

    private void selectCountry(String string) {
        for (int i = 0; i < this.adressCountryField.getItemCount(); ++i) {
            CountryObject countryObject = (CountryObject)this.adressCountryField.getItemAt(i);
            if (!countryObject.getCode().equals(string)) continue;
            this.adressCountryField.setSelectedIndex(i);
            break;
        }
    }

    public void setEditable(boolean bl) {
        this.adressStreetField.setEditable(this.adressFormPanel.isVisible() && bl);
        this.adressStreetNrField.setEditable(this.adressFormPanel.isVisible() && bl);
        this.adressCityField.setEditable(this.adressFormPanel.isVisible() && bl);
        this.adressCityPartField.setEditable(this.adressFormPanel.isVisible() && bl);
        this.adressPostalCodeField.setEditable(this.adressFormPanel.isVisible() && bl);
        this.adressRegionField.setEditable(this.adressFormPanel.isVisible() && bl);
        this.adressCountryField.setEnabled(this.adressFormPanel.isVisible() && this.adressCountryField.isEnabled() && bl);
        this.personGenderField.setEnabled(this.personFormPanel.isVisible() && this.personGenderField.isEnabled() && bl);
        this.personFirstNameField.setEditable(this.personFormPanel.isVisible() && bl);
        this.personMiddleNameField.setEditable(this.personFormPanel.isVisible() && bl);
        this.personLastNameField.setEditable(this.personFormPanel.isVisible() && bl);
        this.personMailField.setEditable(this.personFormPanel.isVisible() && bl);
        this.personPhoneField.setEditable(this.personFormPanel.isVisible() && bl);
        this.personPhoneMobileField.setEditable(this.personFormPanel.isVisible() && bl);
        this.personFaxField.setEditable(this.personFormPanel.isVisible() && bl);
        this.personTitleField.setEditable(this.personFormPanel.isVisible() && bl);
        this.companyNameField.setEditable(this.companyFormPanel.isVisible() && bl);
        this.companyNameAdditionField.setEditable(this.companyFormPanel.isVisible() && bl);
        this.companyTypeField.setEditable(this.companyFormPanel.isVisible() && bl);
        this.companyPositionField.setEditable(this.companyFormPanel.isVisible() && bl);
        this.companyBusinessField.setEditable(this.companyFormPanel.isVisible() && bl);
        this.companyDepartmentField.setEditable(this.companyFormPanel.isVisible() && bl);
        this.companyMailField.setEditable(this.companyFormPanel.isVisible() && bl);
        this.companyPhoneField.setEditable(this.companyFormPanel.isVisible() && bl);
        this.companyPhoneMobileField.setEditable(this.companyFormPanel.isVisible() && bl);
        this.companyFaxField.setEditable(this.companyFormPanel.isVisible() && bl);
        this.companyWebsiteField.setEditable(this.companyFormPanel.isVisible() && bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.adressStreetField.setEnabled(this.adressFormPanel.isVisible() && bl);
        this.adressStreetNrField.setEnabled(this.adressFormPanel.isVisible() && bl);
        this.adressCityField.setEnabled(this.adressFormPanel.isVisible() && bl);
        this.adressCityPartField.setEnabled(this.adressFormPanel.isVisible() && bl);
        this.adressPostalCodeField.setEnabled(this.adressFormPanel.isVisible() && bl);
        this.adressRegionField.setEnabled(this.adressFormPanel.isVisible() && bl);
        this.adressCountryField.setEnabled(this.adressFormPanel.isVisible() && bl);
        this.personGenderField.setEnabled(this.personFormPanel.isVisible() && bl);
        this.personFirstNameField.setEnabled(this.personFormPanel.isVisible() && bl);
        this.personMiddleNameField.setEnabled(this.personFormPanel.isVisible() && bl);
        this.personLastNameField.setEnabled(this.personFormPanel.isVisible() && bl);
        this.personMailField.setEnabled(this.personFormPanel.isVisible() && bl);
        this.personPhoneField.setEnabled(this.personFormPanel.isVisible() && bl);
        this.personPhoneMobileField.setEnabled(this.personFormPanel.isVisible() && bl);
        this.personFaxField.setEnabled(this.personFormPanel.isVisible() && bl);
        this.personTitleField.setEnabled(this.personFormPanel.isVisible() && bl);
        this.companyNameField.setEnabled(this.companyFormPanel.isVisible() && bl);
        this.companyNameAdditionField.setEnabled(this.companyFormPanel.isVisible() && bl);
        this.companyTypeField.setEnabled(this.companyFormPanel.isVisible() && bl);
        this.companyPositionField.setEnabled(this.companyFormPanel.isVisible() && bl);
        this.companyBusinessField.setEnabled(this.companyFormPanel.isVisible() && bl);
        this.companyDepartmentField.setEnabled(this.companyFormPanel.isVisible() && bl);
        this.companyMailField.setEnabled(this.companyFormPanel.isVisible() && bl);
        this.companyPhoneField.setEnabled(this.companyFormPanel.isVisible() && bl);
        this.companyPhoneMobileField.setEnabled(this.companyFormPanel.isVisible() && bl);
        this.companyFaxField.setEnabled(this.companyFormPanel.isVisible() && bl);
        this.companyWebsiteField.setEnabled(this.companyFormPanel.isVisible() && bl);
    }

    public void setValidationEnabled(boolean bl) {
        this.validationHandler.setEnabled(bl);
    }

    public void validateInputs() {
        this.validationHandler.validate();
    }

    private final class GenderRenderer
    extends JLabel
    implements ListCellRenderer {
        public GenderRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof String) {
                String string = (String)object;
                String string2 = "/com/openindex/openestate/tool/resources/icons/gender_" + string + ".png";
                URL uRL = GenderRenderer.class.getResource(string2);
                if (uRL != null) {
                    this.setIcon(new ImageIcon(uRL));
                    this.setText("");
                } else {
                    this.setIcon(null);
                    this.setText(JAdressPanel.this.resourceMap.getString("label.person.gender." + string, new Object[0]));
                }
            } else {
                this.setText("???");
            }
            return this;
        }
    }
}

