/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import com.openindex.openestate.tool.ImmoToolUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import org.jdesktop.application.ResourceMap;

public class JColorChooseButton
extends JButton {
    private Color color = Color.WHITE;
    private ResourceMap resourceMap = ImmoToolUtils.getResourceMap(JColorChooseButton.class);

    public JColorChooseButton() {
        this.setHorizontalAlignment(2);
        final JColorChooseButton jColorChooseButton = this;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(jColorChooseButton, JColorChooseButton.this.resourceMap.getString("message.pleaseSelectAColor", new Object[0]), JColorChooseButton.this.getColor());
                if (color != null) {
                    JColorChooseButton.this.setColor(color);
                }
            }
        });
    }

    public JColorChooseButton(Color color) {
        this();
        this.build(color, null);
    }

    public JColorChooseButton(String string) {
        this();
        this.build(null, string);
    }

    public JColorChooseButton(Color color, String string) {
        this();
        this.build(color, string);
    }

    private void build(Color color, String string) {
        if (color != null) {
            this.setColor(color);
        }
        if (string != null) {
            this.setText(string);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        BufferedImage bufferedImage = new BufferedImage(16, 16, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(color);
        graphics2D.clearRect(0, 0, 16, 16);
        this.setIcon(new ImageIcon(bufferedImage));
    }
}

