/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import com.openindex.openestate.tool.utils.AutoscrollSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.Autoscroll;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;

public class JImageList
extends JList
implements Autoscroll {
    private DefaultListModel model = new DefaultListModel();
    private AutoscrollSupport scrollSupport = new AutoscrollSupport(this, new Insets(15, 15, 15, 15));

    public JImageList() {
        this.setModel(this.model);
        this.setCellRenderer(new ListCellRenderer(){
            JLabel label = new JLabel();
            Border borderSelected = BorderFactory.createLineBorder(Color.RED, 3);
            Border borderUnselected = BorderFactory.createLineBorder(Color.WHITE, 3);

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof ImageIcon) {
                    ImageIcon imageIcon = (ImageIcon)object;
                    this.label.setIcon(imageIcon);
                } else {
                    this.label.setIcon(null);
                    this.label.setText("invalid!");
                }
                this.label.setBorder(bl ? this.borderSelected : this.borderUnselected);
                return this.label;
            }
        });
    }

    @Override
    public void autoscroll(Point point) {
        this.scrollSupport.autoscroll(point);
    }

    public void addItem(Item item) {
        this.model.addElement(item.getImageListIcon());
    }

    @Override
    public Insets getAutoscrollInsets() {
        return this.scrollSupport.getAutoscrollInsets();
    }

    public void moveItem(int n, boolean bl) {
        int n2 = bl ? n + 1 : n - 1;
        Object e = this.model.getElementAt(n);
        Object e2 = this.model.getElementAt(n2);
        this.model.setElementAt(e, n2);
        this.model.setElementAt(e2, n);
        this.setSelectedIndex(n2);
    }

    public void removeAllItems() {
        this.model.removeAllElements();
    }

    public void removeItem(int n) {
        this.model.removeElementAt(n);
    }

    public static interface Item {
        public ImageIcon getImageListIcon();
    }
}

