/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public class JMimeTypeButton
extends JButton {
    private static final Logger LOGGER = Logger.getLogger(JMimeTypeButton.class);
    private final JPopupMenu mimeTypeMenu = new JPopupMenu();
    private final List<Item> mimeTypeItems = new ArrayList<Item>();
    private final Map<String, JMenu> mimeTypeGroups = new HashMap<String, JMenu>();

    public JMimeTypeButton() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMimeTypeButton.this.showMenu();
            }
        });
    }

    public void addApplicationTypes() {
        try {
            this.addApplicationTypes(new String[]{"application/octet-stream", "application/pdf", "application/rtf", "application/vnd.ms-excel", "application/vnd.ms-powerpoint", "application/x-gzip", "application/x-tar-gz", "application/x-zip-compressed", "application/zip"});
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            LOGGER.error((Object)"Can't parse MIME types!");
            LOGGER.error((Object)("> " + mimeTypeParseException.getLocalizedMessage()), (Throwable)mimeTypeParseException);
        }
    }

    public void addApplicationTypes(String[] stringArray) throws MimeTypeParseException {
        JMenu jMenu = this.getMediaMenu("application/");
        for (String string : stringArray) {
            this.addMimeType(jMenu, new MimeType(string));
        }
    }

    public void addAudioTypes() {
        try {
            this.addAudioTypes(new String[]{"audio/midi", "audio/mpeg", "audio/ogg", "audio/vorbis", "audio/x-ms-wma", "audio/x-ms-wmv", "audio/x-pn-realaudio", "audio/x-realaudio", "audio/x-wav"});
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            LOGGER.error((Object)"Can't parse MIME types!");
            LOGGER.error((Object)("> " + mimeTypeParseException.getLocalizedMessage()), (Throwable)mimeTypeParseException);
        }
    }

    public void addAudioTypes(String[] stringArray) throws MimeTypeParseException {
        JMenu jMenu = this.getMediaMenu("audio/");
        for (String string : stringArray) {
            this.addMimeType(jMenu, new MimeType(string));
        }
    }

    public void addImageTypes() {
        try {
            this.addImageTypes(new String[]{"image/bmp", "image/gif", "image/jpeg", "image/png", "image/svg+xml", "image/tiff"});
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            LOGGER.error((Object)"Can't parse MIME types!");
            LOGGER.error((Object)("> " + mimeTypeParseException.getLocalizedMessage()), (Throwable)mimeTypeParseException);
        }
    }

    public void addImageTypes(String[] stringArray) throws MimeTypeParseException {
        JMenu jMenu = this.getMediaMenu("image/");
        for (String string : stringArray) {
            this.addMimeType(jMenu, new MimeType(string));
        }
    }

    public void addTextTypes() {
        try {
            this.addTextTypes(new String[]{"text/html", "text/plain", "text/rtf", "text/xml"});
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            LOGGER.error((Object)"Can't parse MIME types!");
            LOGGER.error((Object)("> " + mimeTypeParseException.getLocalizedMessage()), (Throwable)mimeTypeParseException);
        }
    }

    public void addTextTypes(String[] stringArray) throws MimeTypeParseException {
        JMenu jMenu = this.getMediaMenu("text/");
        for (String string : stringArray) {
            this.addMimeType(jMenu, new MimeType(string));
        }
    }

    public void addVideoTypes() {
        try {
            this.addVideoTypes(new String[]{"video/avi", "video/flv", "video/mp4", "video/mpeg", "video/msvideo", "video/ogg", "video/quicktime", "video/vnd.rn-realvideo", "video/x-flv", "video/x-ms-asf", "video/x-ms-wmv", "video/x-msvideo", "video/x-sgi-movie"});
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            LOGGER.error((Object)"Can't parse MIME types!");
            LOGGER.error((Object)("> " + mimeTypeParseException.getLocalizedMessage()), (Throwable)mimeTypeParseException);
        }
    }

    public void addVideoTypes(String[] stringArray) throws MimeTypeParseException {
        JMenu jMenu = this.getMediaMenu("video/");
        for (String string : stringArray) {
            this.addMimeType(jMenu, new MimeType(string));
        }
    }

    private void addMimeType(JMenu jMenu, MimeType mimeType) {
        Item item = new Item(mimeType);
        this.mimeTypeItems.add(item);
        jMenu.add(item);
    }

    public void clearSelection() {
        for (Item item : this.mimeTypeItems) {
            item.setSelected(false);
        }
    }

    public JMenu getMediaMenu(String string) {
        if (!this.mimeTypeGroups.containsKey(string)) {
            JMenu jMenu = new JMenu(string);
            this.mimeTypeGroups.put(string, jMenu);
            this.mimeTypeMenu.add(jMenu);
        }
        return this.mimeTypeGroups.get(string);
    }

    public List<Item> getMimeTypeItems() {
        return this.mimeTypeItems;
    }

    public void showMenu() {
        this.mimeTypeMenu.show(this, 0, this.getSize().height);
    }

    public static class Item
    extends JCheckBoxMenuItem {
        private MimeType mimeType;

        public Item(MimeType mimeType) {
            this.mimeType = mimeType;
            this.setText(this.mimeType.getSubType());
        }

        public MimeType getMimeType() {
            return this.mimeType;
        }
    }
}

