/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.tool.ImmoToolUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.jdesktop.application.ResourceMap;

public class JOptionFileChooser
extends JFileChooser {
    private final ResourceMap resourceMap = ImmoToolUtils.getResourceMap(JOptionFileChooser.class);
    private final Map<String, OptionField> optionFields;

    public JOptionFileChooser(Map<String, OptionField> map) {
        this.optionFields = map;
    }

    @Override
    protected JDialog createDialog(Component component) throws HeadlessException {
        JDialog jDialog = super.createDialog(component);
        if (this.optionFields == null || this.optionFields.isEmpty()) {
            return jDialog;
        }
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder("left:[30dlu,pref], 3dlu, pref:grow");
        defaultFormBuilder.border(Borders.DIALOG);
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator(this.resourceMap.getString("label.options", new Object[0])), 3);
        for (OptionField optionField : this.optionFields.values()) {
            defaultFormBuilder.nextLine();
            String string = optionField.getLabel();
            if (string == null) {
                defaultFormBuilder.append((Component)optionField.getComponent(), 3);
                continue;
            }
            defaultFormBuilder.append(string.trim(), (Component)optionField.getComponent());
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jDialog.getRootPane().getContentPane(), "Center");
        jPanel.add((Component)defaultFormBuilder.getPanel(), "South");
        jDialog.getRootPane().setContentPane(jPanel);
        jDialog.getRootPane().revalidate();
        jDialog.getRootPane().repaint();
        jDialog.setSize(jDialog.getSize().width, (int)((double)jDialog.getSize().height + defaultFormBuilder.getPanel().getPreferredSize().getHeight()));
        return jDialog;
    }

    public JComponent getOptionComponent(String string) {
        OptionField optionField = this.getOptionField(string);
        return optionField != null ? optionField.getComponent() : null;
    }

    public OptionField getOptionField(String string) {
        return this.optionFields.get(string);
    }

    public static class OptionField {
        private String label;
        private JComponent component;

        public OptionField(String string, JComponent jComponent) {
            this.label = string;
            this.component = jComponent;
        }

        public JComponent getComponent() {
            return this.component;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

