/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class JSelectButton
extends JButton {
    public static final int SINGLE_SELECTION = 0;
    public static final int MULTIPLE_SELECTION = 1;
    private JPopupMenu buttonMenu;
    private Map<String, JMenuItem> buttonMenuItems;
    private transient ActionListener buttonMenuItemListener;
    private Map<String, String> buttonOptions;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private int buttonSelectionType;
    private String emptyText = "";

    public JSelectButton(int n) {
        this("", n);
    }

    public JSelectButton(String string, int n) {
        super(string);
        this.buttonMenu = new JPopupMenu();
        this.buttonMenuItems = new HashMap<String, JMenuItem>();
        this.buttonOptions = new HashMap<String, String>();
        this.buttonSelectionType = n;
        this.setHorizontalAlignment(2);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSelectButton.this.buttonMenu.show((Component)actionEvent.getSource(), JSelectButton.this.getSize().width / 7, JSelectButton.this.getSize().height);
            }
        });
        this.buttonMenuItemListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSelectButton.this.updateText();
            }
        };
    }

    public void addMenuItemListener(ActionListener actionListener) {
        for (String string : this.buttonMenuItems.keySet()) {
            this.buttonMenuItems.get(string).addActionListener(actionListener);
        }
    }

    public void addOption(String string, String string2) {
        this.buttonOptions.put(string, string2);
        if (!this.buttonMenuItems.containsKey(string)) {
            this.buttonMenuItems.put(string, this.createMenuItem(string2));
            this.buttonMenu.add(this.buttonMenuItems.get(string));
        }
    }

    public void clearSelection() {
        if (this.buttonSelectionType == 1) {
            if (this.buttonGroup.getSelection() != null) {
                this.buttonGroup.getSelection().setSelected(false);
            }
        } else {
            for (JMenuItem jMenuItem : this.buttonMenuItems.values()) {
                ((JCheckBoxMenuItem)jMenuItem).setSelected(false);
            }
        }
    }

    private JMenuItem createMenuItem(String string) {
        JMenuItem jMenuItem = null;
        if (this.buttonSelectionType == 0) {
            jMenuItem = new JRadioButtonMenuItem(string);
            this.buttonGroup.add(jMenuItem);
        } else if (this.buttonSelectionType == 1) {
            jMenuItem = new JCheckBoxMenuItem(string);
        } else {
            return null;
        }
        jMenuItem.addActionListener(this.buttonMenuItemListener);
        jMenuItem.setOpaque(true);
        return jMenuItem;
    }

    public String getSelectedKey() {
        String[] stringArray = this.getSelectedKeys();
        return stringArray.length > 0 ? stringArray[0] : null;
    }

    public String[] getSelectedKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.buttonMenuItems.keySet()) {
            if (!this.buttonMenuItems.get(string).isSelected()) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public int getSelectionType() {
        return this.buttonSelectionType;
    }

    public boolean hasSelection(String string) {
        for (String string2 : this.buttonMenuItems.keySet()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return this.buttonMenuItems.get(string).isSelected();
        }
        return false;
    }

    public void removeAllOptions() {
        this.buttonGroup = new ButtonGroup();
        this.buttonMenu = new JPopupMenu();
        this.buttonMenuItems.clear();
        this.buttonOptions.clear();
    }

    public void removeMenuItemListener(ActionListener actionListener) {
        for (String string : this.buttonMenuItems.keySet()) {
            this.buttonMenuItems.get(string).removeActionListener(actionListener);
        }
    }

    public void setEmptyText(String string) {
        this.emptyText = string;
    }

    public void setSelected(String string, boolean bl) {
        if (!this.buttonMenuItems.containsKey(string)) {
            return;
        }
        this.buttonMenuItems.get(string).setSelected(bl);
    }

    public void updateText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.buttonMenuItems.keySet()) {
            JMenuItem jMenuItem = this.buttonMenuItems.get(string);
            if (!jMenuItem.isSelected()) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.buttonOptions.get(string));
        }
        this.setText(stringBuilder.length() > 0 ? stringBuilder.toString() : this.emptyText);
    }
}

