/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import com.openindex.openestate.tool.ImmoToolUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class MemoryMonitorDialog
extends JDialog {
    private MemoryMonitorPanel heapPanel;
    private MemoryMonitorPanel nonHeapPanel;
    private MemoryMXBean memoryMXBean;
    private Thread thread;

    public MemoryMonitorDialog() {
        this.build();
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public MemoryMonitorDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.build();
        this.pack();
        this.setLocationRelativeTo(dialog);
    }

    public MemoryMonitorDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.build();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private void build() {
        this.memoryMXBean = ManagementFactory.getMemoryMXBean();
        if (this.memoryMXBean == null) {
            throw new RuntimeException("Can't load MemoryMXBean!");
        }
        this.heapPanel = new MemoryMonitorPanel();
        this.nonHeapPanel = new MemoryMonitorPanel();
        this.setTitle("Memory Monitor");
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.setPreferredSize(new Dimension(250, 200));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add("Heap", this.heapPanel);
        jTabbedPane.add("Non-Heap", this.nonHeapPanel);
        this.add((Component)jTabbedPane, "Center");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (MemoryMonitorDialog.this.thread != null) {
                    MemoryMonitorDialog.this.stop();
                }
                MemoryMonitorDialog.this.setVisible(false);
                MemoryMonitorDialog.this.dispose();
            }
        });
        this.pack();
    }

    public static void main(String[] stringArray) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MemoryMonitorDialog memoryMonitorDialog = new MemoryMonitorDialog();
                    memoryMonitorDialog.start();
                    memoryMonitorDialog.setVisible(true);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void start() {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (MemoryMonitorDialog.this.thread != null) {
                    MemoryMonitorDialog.this.heapPanel.update(MemoryMonitorDialog.this.memoryMXBean.getHeapMemoryUsage());
                    MemoryMonitorDialog.this.nonHeapPanel.update(MemoryMonitorDialog.this.memoryMXBean.getNonHeapMemoryUsage());
                    try {
                        Thread.sleep(999L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
        });
        this.thread.setPriority(1);
        this.thread.setName("MemoryMonitorDialog");
        this.thread.start();
    }

    public synchronized void stop() {
        this.thread = null;
        this.notify();
    }

    private static class MemoryMonitorPanel
    extends JPanel {
        private Font font = new Font("Times New Roman", 0, 11);
        private float freeMemory;
        private float totalMemory;
        private float maxMemory;
        private int w;
        private int h;
        private int ascent;
        private int descent;
        private int columnInc;
        private int[] pts;
        private int ptNum;
        private BufferedImage bimg;
        private Graphics2D big;
        private Rectangle graphOutlineRect = new Rectangle();
        private Rectangle2D mfRect = new Rectangle2D.Float();
        private Rectangle2D muRect = new Rectangle2D.Float();
        private Line2D graphLine = new Line2D.Float();
        private Color graphColor = new Color(46, 139, 87);
        private Color mfColor = new Color(0, 100, 0);

        public MemoryMonitorPanel() {
            this.setBackground(Color.black);
        }

        @Override
        public void paint(Graphics graphics) {
            int n;
            int n2;
            int n3;
            if (this.big == null) {
                return;
            }
            this.big.setBackground(this.getBackground());
            this.big.clearRect(0, 0, this.w, this.h);
            this.big.setColor(Color.green);
            this.big.drawString(ImmoToolUtils.getHumanReadableByteCount((long)this.totalMemory) + " allocated " + "(max " + ImmoToolUtils.getHumanReadableByteCount((long)this.maxMemory) + ")", 4.0f, (float)this.ascent + 0.5f);
            this.big.drawString(ImmoToolUtils.getHumanReadableByteCount((long)(this.totalMemory - this.freeMemory)) + " used", 4, this.h - this.descent);
            float f = this.ascent + this.descent;
            float f2 = (float)this.h - f * 2.0f - 0.5f;
            float f3 = f2 / 10.0f;
            float f4 = 20.0f;
            this.big.setColor(this.mfColor);
            int n4 = (int)(this.freeMemory / this.totalMemory * 10.0f);
            for (n3 = 0; n3 < n4; ++n3) {
                this.mfRect.setRect(5.0, f + (float)n3 * f3, f4, f3 - 1.0f);
                this.big.fill(this.mfRect);
            }
            this.big.setColor(Color.green);
            while (n3 < 10) {
                this.muRect.setRect(5.0, f + (float)n3 * f3, f4, f3 - 1.0f);
                this.big.fill(this.muRect);
                ++n3;
            }
            this.big.setColor(this.graphColor);
            int n5 = 30;
            int n6 = (int)f;
            int n7 = this.w - n5 - 5;
            int n8 = (int)f2;
            this.graphOutlineRect.setRect(n5, n6, n7, n8);
            this.big.draw(this.graphOutlineRect);
            int n9 = n8 / 10;
            for (n2 = n6; n2 <= n8 + n6; n2 += n9) {
                this.graphLine.setLine(n5, n2, n5 + n7, n2);
                this.big.draw(this.graphLine);
            }
            n2 = n7 / 15;
            if (this.columnInc == 0) {
                this.columnInc = n2;
            }
            for (n = n5 + this.columnInc; n < n7 + n5; n += n2) {
                this.graphLine.setLine(n, n6, n, n6 + n8);
                this.big.draw(this.graphLine);
            }
            --this.columnInc;
            if (this.pts == null) {
                this.pts = new int[n7];
                this.ptNum = 0;
            } else if (this.pts.length != n7) {
                int[] nArray = null;
                if (this.ptNum < n7) {
                    nArray = new int[this.ptNum];
                    System.arraycopy(this.pts, 0, nArray, 0, nArray.length);
                } else {
                    nArray = new int[n7];
                    System.arraycopy(this.pts, this.pts.length - nArray.length, nArray, 0, nArray.length);
                    this.ptNum = nArray.length - 2;
                }
                this.pts = new int[n7];
                System.arraycopy(nArray, 0, this.pts, 0, nArray.length);
            } else {
                this.big.setColor(Color.yellow);
                this.pts[this.ptNum] = (int)((float)n6 + (float)n8 * (this.freeMemory / this.totalMemory));
                n = n5 + n7 - this.ptNum;
                int n10 = 0;
                while (n10 < this.ptNum) {
                    if (n10 != 0) {
                        if (this.pts[n10] != this.pts[n10 - 1]) {
                            this.big.drawLine(n - 1, this.pts[n10 - 1], n, this.pts[n10]);
                        } else {
                            this.big.fillRect(n, this.pts[n10], 1, 1);
                        }
                    }
                    ++n10;
                    ++n;
                }
                if (this.ptNum + 2 == this.pts.length) {
                    for (n = 1; n < this.ptNum; ++n) {
                        this.pts[n - 1] = this.pts[n];
                    }
                    --this.ptNum;
                } else {
                    ++this.ptNum;
                }
            }
            graphics.drawImage(this.bimg, 0, 0, this);
        }

        public void update(MemoryUsage memoryUsage) {
            Dimension dimension = this.getSize();
            if (dimension.width != this.w || dimension.height != this.h) {
                this.updateSize(dimension.width, dimension.height);
            }
            this.freeMemory = memoryUsage.getCommitted() - memoryUsage.getUsed();
            this.totalMemory = memoryUsage.getCommitted();
            this.maxMemory = memoryUsage.getMax();
            this.repaint();
        }

        public void updateSize(int n, int n2) {
            this.w = n;
            this.h = n2;
            this.bimg = (BufferedImage)this.createImage(n, n2);
            this.big = this.bimg.createGraphics();
            this.big.setFont(this.font);
            FontMetrics fontMetrics = this.big.getFontMetrics(this.font);
            this.ascent = fontMetrics.getAscent();
            this.descent = fontMetrics.getDescent();
        }
    }
}

