/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.ActionMap;
import javax.swing.JFileChooser;
import jxl.Workbook;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.VerticalAlignment;
import jxl.write.Boolean;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.jdesktop.swingx.table.ColumnControlPopup;

public class QuickTableExport {
    private static final Logger LOGGER = Logger.getLogger(QuickTableExport.class);
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private static File lastSaveDirectory = SystemUtils.getUserHome();
    private final ResourceMap resourceMap = ImmoToolUtils.getResourceMap(QuickTableExport.class);
    private final JXTable table;

    private QuickTableExport(JXTable jXTable) {
        this.table = jXTable;
    }

    public static ColumnControlButton createColumnControl(final JXTable jXTable) {
        return new ColumnControlButton(jXTable, null){

            protected ColumnControlPopup createColumnControlPopup() {
                return new ColumnControlButton.DefaultColumnControlPopup(){

                    public void addAdditionalActionItems(List<? extends javax.swing.Action> list) {
                        super.addAdditionalActionItems(list);
                        ActionMap actionMap = ImmoToolUtils.getActionMap(QuickTableExport.class, new QuickTableExport(jXTable));
                        ArrayList<javax.swing.Action> arrayList = new ArrayList<javax.swing.Action>();
                        arrayList.add(actionMap.get("doExportCsv"));
                        arrayList.add(actionMap.get("doExportXls"));
                        arrayList.add(actionMap.get("doExportPdf"));
                        super.addAdditionalActionItems(arrayList);
                    }
                };
            }
        };
    }

    @Action
    public void doExportCsv() {
        ImmoToolApp immoToolApp = ImmoToolApp.getApplication();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.resourceMap.getString("doExportCsv.Action.text", new Object[0]));
        jFileChooser.setSelectedFile(new File(lastSaveDirectory.getAbsolutePath() + File.separator + "export_" + System.currentTimeMillis() + ".csv"));
        int n = jFileChooser.showSaveDialog(immoToolApp.getMainFrame());
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile().getAbsoluteFile();
        QuickTableExport.setLastSaveDirectory(file.getParentFile());
        try {
            QuickTableExport.writeCsv(this.table, file);
            ImmoToolUtils.showMessageInfoDialog(this.resourceMap.getString("message.tableWasSaved", new Object[]{file.getAbsolutePath()}), immoToolApp.getMainFrame());
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't save csv-table!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.cantSaveTable", new Object[0]), exception);
        }
    }

    @Action
    public void doExportPdf() {
        ImmoToolApp immoToolApp = ImmoToolApp.getApplication();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.resourceMap.getString("doExportPdf.Action.text", new Object[0]));
        jFileChooser.setSelectedFile(new File(lastSaveDirectory.getAbsolutePath() + File.separator + "export_" + System.currentTimeMillis() + ".pdf"));
        int n = jFileChooser.showSaveDialog(immoToolApp.getMainFrame());
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile().getAbsoluteFile();
        QuickTableExport.setLastSaveDirectory(file.getParentFile());
        try {
            QuickTableExport.writePdf(this.table, PageSize.A4.rotate(), file);
            ImmoToolUtils.showMessageInfoDialog(this.resourceMap.getString("message.tableWasSaved", new Object[]{file.getAbsolutePath()}), immoToolApp.getMainFrame());
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't save pdf-table!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.cantSaveTable", new Object[0]), exception);
        }
    }

    @Action
    public void doExportXls() {
        ImmoToolApp immoToolApp = ImmoToolApp.getApplication();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.resourceMap.getString("doExportXls.Action.text", new Object[0]));
        jFileChooser.setSelectedFile(new File(lastSaveDirectory.getAbsolutePath() + File.separator + "export_" + System.currentTimeMillis() + ".xls"));
        int n = jFileChooser.showSaveDialog(immoToolApp.getMainFrame());
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile().getAbsoluteFile();
        QuickTableExport.setLastSaveDirectory(file.getParentFile());
        try {
            QuickTableExport.writeXls(this.table, file);
            ImmoToolUtils.showMessageInfoDialog(this.resourceMap.getString("message.tableWasSaved", new Object[]{file.getAbsolutePath()}), immoToolApp.getMainFrame());
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't save xls-table!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.cantSaveTable", new Object[0]), exception);
        }
    }

    public static DateFormat getDateFormat() {
        return DateFormat.getDateTimeInstance(2, 3);
    }

    private static synchronized void setLastSaveDirectory(File file) {
        lastSaveDirectory = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCsv(JXTable jXTable, File file) throws IOException {
        int n = jXTable.getColumnCount(false);
        if (n <= 0) {
            return;
        }
        DateFormat dateFormat = QuickTableExport.getDateFormat();
        FileWriter fileWriter = null;
        try {
            int n2;
            fileWriter = new FileWriter(file);
            Object[] objectArray = new Object[n];
            for (n2 = 0; n2 < n; ++n2) {
                Object object;
                objectArray[n2] = object = jXTable.getColumn(n2).getHeaderValue();
            }
            QuickTableExport.writeCsvRow(fileWriter, objectArray);
            for (n2 = 0; n2 < jXTable.getRowCount(); ++n2) {
                for (int i = 0; i < n; ++i) {
                    Object object = jXTable.getValueAt(n2, i);
                    objectArray[i] = object instanceof Number ? NUMBER_FORMAT.format(object) : (object instanceof Date ? dateFormat.format(object) : (object instanceof Calendar ? dateFormat.format(((Calendar)object).getTime()) : (object instanceof java.lang.Boolean ? (java.lang.Boolean.TRUE.equals(object) ? "X" : "") : (object instanceof Translatable ? ((Translatable)object).translate() : object))));
                }
                QuickTableExport.writeCsvRow(fileWriter, objectArray);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)fileWriter);
    }

    private static void writeCsvRow(Writer writer, Object[] objectArray) throws IOException {
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                writer.write(",");
            }
            writer.write("\"" + QuickTableExport.writeCsvValue(objectArray[i]) + "\"");
        }
        writer.write(SystemUtils.LINE_SEPARATOR);
    }

    private static String writeCsvValue(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString().replaceAll(Pattern.quote("\""), "'").replaceAll("(\\r\\n|\\n)", "; ").trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePdf(JXTable jXTable, Rectangle rectangle, File file) throws DocumentException, FileNotFoundException {
        int n = jXTable.getColumnCount(false);
        if (n <= 0) {
            return;
        }
        DateFormat dateFormat = QuickTableExport.getDateFormat();
        ResourceMap resourceMap = ImmoToolUtils.getResourceMap(QuickTableExport.class);
        FileOutputStream fileOutputStream = null;
        PdfWriter pdfWriter = null;
        try {
            int n2;
            Document document = new Document(rectangle);
            document.setMargins(40.0f, 40.0f, 40.0f, 40.0f);
            fileOutputStream = new FileOutputStream(file);
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)fileOutputStream);
            document.open();
            document.addAuthor(ImmoToolApp.getApplicationTitle() + " v" + ImmoToolApp.getApplicationVersion());
            document.addCreationDate();
            document.addCreator(ImmoToolApp.getApplicationTitle() + " v" + ImmoToolApp.getApplicationVersion());
            document.addProducer();
            PdfPTable pdfPTable = new PdfPTable(n);
            pdfPTable.setWidthPercentage(100.0f);
            pdfPTable.setHeaderRows(2);
            PdfPCell pdfPCell = null;
            Paragraph paragraph = null;
            for (n2 = 0; n2 < n; ++n2) {
                Object object = jXTable.getColumn(n2).getHeaderValue();
                paragraph = new Paragraph(object != null ? object.toString() : "");
                paragraph.getFont().setSize(10.0f);
                paragraph.getFont().setStyle(1);
                pdfPCell = new PdfPCell((Phrase)paragraph);
                pdfPCell.setPadding(3.0f);
                pdfPCell.setHorizontalAlignment(1);
                pdfPCell.setVerticalAlignment(5);
                pdfPCell.setBackgroundColor(ImmoToolUtils.TABLE_HIGHLIGHT_COLOR);
                pdfPTable.addCell(pdfPCell);
            }
            paragraph = new Paragraph("");
            pdfPCell = new PdfPCell((Phrase)paragraph);
            pdfPCell.setColspan(n);
            pdfPCell.setBorderWidth(0.0f);
            pdfPTable.addCell(pdfPCell);
            for (n2 = 0; n2 < jXTable.getRowCount(); ++n2) {
                for (int i = 0; i < n; ++i) {
                    Object object = jXTable.getValueAt(n2, i);
                    paragraph = null;
                    paragraph = object instanceof Number ? new Paragraph(NUMBER_FORMAT.format(object)) : (object instanceof Date ? new Paragraph(dateFormat.format(object)) : (object instanceof Calendar ? new Paragraph(dateFormat.format(((Calendar)object).getTime())) : (object instanceof java.lang.Boolean ? new Paragraph(java.lang.Boolean.TRUE.equals(object) ? "X" : "") : (object instanceof Translatable ? new Paragraph(((Translatable)object).translate()) : new Paragraph(object != null ? object.toString() : "")))));
                    paragraph.getFont().setSize(10.0f);
                    pdfPCell = new PdfPCell((Phrase)paragraph);
                    pdfPTable.addCell(pdfPCell);
                }
            }
            pdfPCell = new PdfPCell((Phrase)new Paragraph(""));
            pdfPCell.setColspan(n);
            pdfPCell.setBorderWidth(0.0f);
            pdfPTable.addCell(pdfPCell);
            paragraph = new Paragraph(resourceMap.getString("label.buildTime", new Object[]{dateFormat.format(new Date())}));
            paragraph.getFont().setSize(8.0f);
            paragraph.getFont().setStyle(1);
            pdfPCell = new PdfPCell((Phrase)paragraph);
            pdfPCell.setColspan(n);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setBorderWidthBottom(1.0f);
            pdfPCell.setHorizontalAlignment(2);
            pdfPCell.setBackgroundColor(ImmoToolUtils.TABLE_HIGHLIGHT_COLOR);
            pdfPTable.addCell(pdfPCell);
            document.add((Element)pdfPTable);
            document.close();
            pdfWriter.flush();
            pdfWriter.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXls(JXTable jXTable, File file) throws IOException, WriteException {
        int n = jXTable.getColumnCount(false);
        if (n <= 0) {
            return;
        }
        DateFormat dateFormat = QuickTableExport.getDateFormat();
        ResourceMap resourceMap = ImmoToolUtils.getResourceMap(QuickTableExport.class);
        WritableCellFormat writableCellFormat = new WritableCellFormat(new WritableFont(WritableFont.ARIAL, 10));
        writableCellFormat.setVerticalAlignment(VerticalAlignment.TOP);
        WritableCellFormat writableCellFormat2 = new WritableCellFormat(new WritableFont(WritableFont.ARIAL, 10));
        writableCellFormat2.setBackground(Colour.TURQUOISE);
        WritableCellFormat writableCellFormat3 = new WritableCellFormat(new WritableFont(WritableFont.ARIAL, 12, WritableFont.BOLD));
        writableCellFormat3.setBackground(Colour.TURQUOISE);
        WritableWorkbook writableWorkbook = null;
        try {
            int n2;
            writableWorkbook = Workbook.createWorkbook((File)file);
            WritableSheet writableSheet = writableWorkbook.createSheet(resourceMap.getString("label.sheetTitle", new Object[0]), 0);
            int n3 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                Object object = jXTable.getColumn(n2).getHeaderValue();
                writableSheet.addCell((WritableCell)new Label(n2, n3, object != null ? object.toString() : "", (CellFormat)writableCellFormat3));
            }
            ++n3;
            for (n2 = 0; n2 < jXTable.getRowCount(); ++n2) {
                ++n3;
                for (int i = 0; i < n; ++i) {
                    Object object = jXTable.getValueAt(n2, i);
                    if (object instanceof Number) {
                        writableSheet.addCell((WritableCell)new Label(i, n3, NUMBER_FORMAT.format(object), (CellFormat)writableCellFormat));
                        continue;
                    }
                    if (object instanceof Date) {
                        writableSheet.addCell((WritableCell)new Label(i, n3, dateFormat.format(object), (CellFormat)writableCellFormat));
                        continue;
                    }
                    if (object instanceof Calendar) {
                        writableSheet.addCell((WritableCell)new Label(i, n3, dateFormat.format(((Calendar)object).getTime()), (CellFormat)writableCellFormat));
                        continue;
                    }
                    if (object instanceof java.lang.Boolean) {
                        writableSheet.addCell((WritableCell)new Boolean(i, n3, ((java.lang.Boolean)object).booleanValue(), (CellFormat)writableCellFormat));
                        continue;
                    }
                    if (object instanceof Translatable) {
                        writableSheet.addCell((WritableCell)new Label(i, n3, ((Translatable)object).translate(), (CellFormat)writableCellFormat));
                        continue;
                    }
                    writableSheet.addCell((WritableCell)new Label(i, n3, object != null ? object.toString() : "", (CellFormat)writableCellFormat));
                }
            }
            ++n3;
            writableSheet.addCell((WritableCell)new Label(0, ++n3, resourceMap.getString("label.buildTime", new Object[]{dateFormat.format(new Date())}), (CellFormat)writableCellFormat2));
            if (n > 1) {
                writableSheet.mergeCells(0, n3, n - 1, n3);
            }
            writableWorkbook.write();
        }
        finally {
            if (writableWorkbook != null) {
                writableWorkbook.close();
            }
        }
    }
}

