/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import com.openindex.openestate.tool.ImmoToolApp;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class SimpleFtpd
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(SimpleFtpd.class);
    private final Socket incoming;
    private final int counter;
    private final File baseDir;

    public static void main(String[] stringArray) {
        DOMConfigurator.configure((URL)ImmoToolApp.class.getResource("/com/openindex/openestate/tool/resources/log4j.xml"));
        File file = new File("").getAbsoluteFile().getParentFile();
        if (stringArray.length != 0) {
            file = new File(stringArray[0]);
        }
        int n = 1;
        try {
            ServerSocket serverSocket = new ServerSocket(2100);
            while (true) {
                Socket socket = serverSocket.accept();
                new SimpleFtpd(file, socket, n).start();
                ++n;
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
            return;
        }
    }

    public SimpleFtpd(File file, Socket socket, int n) {
        this.incoming = socket;
        this.counter = n;
        this.baseDir = file;
    }

    @Override
    public void run() {
        int n = 1;
        String string = "";
        LOGGER.debug((Object)("root-dir: " + this.baseDir.getAbsolutePath()));
        String string2 = "";
        try {
            InetAddress inetAddress = this.incoming.getInetAddress();
            String string3 = inetAddress.toString();
            int n2 = string3.indexOf("/");
            string3 = string3.substring(n2 + 1);
            LOGGER.debug((Object)string3);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.incoming.getInputStream()));
            PrintWriter printWriter = new PrintWriter(this.incoming.getOutputStream(), true);
            printWriter.println("220 ImmoTool-FTPd [JAVA FTP server written by S.Tanaka & A.Rudolph]ready.\r");
            boolean bl = false;
            while (!bl) {
                Object[] objectArray;
                Object object;
                String string4 = "";
                String string5 = "";
                String string6 = bufferedReader.readLine();
                if (string6 == null) {
                    string6 = "";
                } else {
                    LOGGER.debug((Object)("> " + string6));
                }
                if (string6.startsWith("RETR")) {
                    printWriter.println("150 Binary data connection");
                    string6 = string6.substring(4);
                    string6 = string6.trim();
                    LOGGER.debug((Object)string6);
                    LOGGER.debug((Object)string2);
                    RandomAccessFile randomAccessFile = new RandomAccessFile(this.baseDir.getAbsolutePath() + File.separator + string2 + "/" + string6, "r");
                    Socket socket = new Socket(string3, n);
                    object = socket.getOutputStream();
                    objectArray = new byte[1024];
                    try {
                        int n3;
                        while ((n3 = randomAccessFile.read((byte[])objectArray)) != -1) {
                            ((OutputStream)object).write((byte[])objectArray, 0, n3);
                        }
                        ((OutputStream)object).close();
                        printWriter.println("226 transfer complete");
                        randomAccessFile.close();
                        socket.close();
                    }
                    catch (IOException iOException) {
                        LOGGER.warn((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                    }
                    continue;
                }
                if (string6.startsWith("STOR")) {
                    printWriter.println("150 Binary data connection");
                    string6 = string6.substring(4);
                    string6 = string6.trim();
                    LOGGER.debug((Object)string6);
                    LOGGER.debug((Object)string2);
                    RandomAccessFile randomAccessFile = new RandomAccessFile(this.baseDir.getAbsolutePath() + File.separator + string2 + File.separator + string6, "rw");
                    Socket socket = new Socket(string3, n);
                    object = socket.getInputStream();
                    objectArray = new byte[1024];
                    try {
                        int n4;
                        while ((n4 = ((InputStream)object).read((byte[])objectArray)) != -1) {
                            randomAccessFile.write((byte[])objectArray, 0, n4);
                        }
                        ((InputStream)object).close();
                        printWriter.println("226 transfer complete");
                        randomAccessFile.close();
                        socket.close();
                    }
                    catch (IOException iOException) {
                        LOGGER.warn((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                    }
                    continue;
                }
                if (string6.startsWith("TYPE")) {
                    printWriter.println("200 type set");
                    continue;
                }
                if (string6.startsWith("DELE")) {
                    string6 = string6.substring(4);
                    string6 = string6.trim();
                    File file = new File(this.baseDir.getAbsolutePath() + File.separator + string2, string6);
                    boolean bl2 = file.delete();
                    printWriter.println("250 delete command successful");
                    continue;
                }
                if (string6.startsWith("CDUP")) {
                    int n5 = string2.lastIndexOf(File.separator);
                    string2 = string2.substring(0, n5);
                    printWriter.println("250 CWD command succesful");
                    continue;
                }
                if (string6.startsWith("CWD")) {
                    String string7 = string6.substring(3);
                    string2 = string7.trim();
                    printWriter.println("250 CWD command succesful");
                    continue;
                }
                if (string6.startsWith("QUIT")) {
                    printWriter.println("GOOD BYE");
                    bl = true;
                    continue;
                }
                if (string6.startsWith("REST")) {
                    printWriter.println("350 Restarting at 1. Send STOR or RETR to initiate transfer.");
                    continue;
                }
                if (string6.startsWith("SYST")) {
                    printWriter.println("215 Java Power Type: L8");
                    continue;
                }
                if (string6.startsWith("USER")) {
                    string = string6.substring(4);
                    string = string.trim();
                    printWriter.println("331 Password");
                    continue;
                }
                if (string6.startsWith("PASS")) {
                    printWriter.println("230 User " + string + " logged in.");
                    continue;
                }
                if (string6.startsWith("PWD")) {
                    printWriter.println("257 \"" + string2 + "\" is current directory");
                    continue;
                }
                if (string6.startsWith("SYS")) {
                    printWriter.println("500 SYS not understood");
                    continue;
                }
                if (string6.startsWith("PORT")) {
                    int n6;
                    printWriter.println("200 PORT command successful");
                    int n7 = string6.length() - 1;
                    int n8 = string6.lastIndexOf(",");
                    int n9 = string6.lastIndexOf(",", n8 - 1);
                    for (n6 = n9 + 1; n6 < n8; ++n6) {
                        string4 = string4 + string6.charAt(n6);
                    }
                    for (n6 = n8 + 1; n6 <= n7; ++n6) {
                        string5 = string5 + string6.charAt(n6);
                    }
                    int n10 = Integer.parseInt(string4);
                    int n11 = Integer.parseInt(string5);
                    n = n10 * 16 * 16 + n11;
                    continue;
                }
                if (!string6.startsWith("LIST")) continue;
                try {
                    printWriter.println("150 ASCII data");
                    Socket socket = new Socket(string3, n);
                    PrintWriter printWriter2 = new PrintWriter(socket.getOutputStream(), true);
                    object = null;
                    object = string2.trim().length() == 0 ? this.baseDir : new File(this.baseDir.getAbsolutePath() + File.separator + string2);
                    LOGGER.debug((Object)("LIST dir: " + ((File)object).getAbsolutePath()));
                    for (byte by : objectArray = (Object[])((File)object).listFiles()) {
                        printWriter2.println(SimpleFtpd.lsFile((File)by, by.canRead(), by.canWrite(), "nobody", false));
                    }
                    socket.close();
                    printWriter.println("226 transfer complete");
                }
                catch (IOException iOException) {
                    LOGGER.warn((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                }
            }
            this.incoming.close();
        }
        catch (Exception exception) {
            LOGGER.warn((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private static String lsFile(File file, boolean bl, boolean bl2, String string, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (file.isDirectory()) {
            stringBuilder.append('d');
        } else if (file.isFile()) {
            stringBuilder.append('-');
        } else {
            stringBuilder.append('?');
        }
        String string2 = "";
        string2 = bl && file.canRead() ? string2 + "r" : string2 + "-";
        boolean bl4 = false;
        if (bl2 && file.canWrite()) {
            string2 = string2 + "w";
            bl4 = false;
        } else {
            string2 = string2 + "-";
            bl4 = true;
        }
        string2 = file.isDirectory() ? string2 + "x" : string2 + "-";
        stringBuilder.append(string2).append(string2).append(string2).append("   1");
        String string3 = bl4 ? "root" : string;
        stringBuilder.append(' ').append(string3.length() > 7 ? string3.substring(0, 8) : SimpleFtpd.lenformatted(string3, 8, false));
        stringBuilder.append(' ').append(string3.length() > 7 ? string3.substring(0, 8) : SimpleFtpd.lenformatted(string3, 8, false));
        if (file.isDirectory()) {
            if (bl3) {
                String[] stringArray = file.list();
                stringBuilder.append(SimpleFtpd.lenformatted(" " + (stringArray == null ? 0 : stringArray.length), 11, true));
                if (stringArray == null) {
                    LOGGER.warn((Object)("Contradictous directory property: " + file.toString()));
                }
            } else {
                stringBuilder.append(SimpleFtpd.lenformatted(" 0", 11, true));
            }
        } else {
            stringBuilder.append(SimpleFtpd.lenformatted(" " + file.length(), 11, true));
        }
        return stringBuilder.append(' ').append(SimpleFtpd.getFsDate(new Date(file.lastModified()))).append(' ').append(SimpleFtpd.encodeChar(file.getName())).append("\r\n").toString();
    }

    private static String lenformatted(String string, int n, boolean bl) {
        n -= string.length();
        if (bl) {
            while (n > 0) {
                string = " " + string;
                --n;
            }
        } else {
            while (n > 0) {
                string = string + " ";
                --n;
            }
        }
        return string;
    }

    private static String encodeChar(String string) {
        String string2 = Charset.defaultCharset().name();
        if (string2 == null) {
            return string;
        }
        try {
            int n;
            String string3 = new String(string.getBytes(string2));
            while ((n = string3.indexOf("%20")) >= 0) {
                string3 = string3.substring(0, n) + " " + string3.substring(n + 3);
            }
            return string3;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("IRREGULARITY: string encoding '" + string2 + "' failed (java version too low)"));
            return string;
        }
    }

    public static String getFsDate(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = gregorianCalendar.get(1);
        gregorianCalendar.setTime(date);
        if (gregorianCalendar.get(1) == n) {
            return SimpleFtpd.getCurrentYearFormat().format(date);
        }
        return SimpleFtpd.getPreviousYearFormat().format(date);
    }

    private static DateFormat getCurrentYearFormat() {
        return new SimpleDateFormat("MMM dd HH:mm", Locale.ENGLISH);
    }

    private static DateFormat getPreviousYearFormat() {
        return new SimpleDateFormat("MMM dd yyyy", Locale.ENGLISH);
    }
}

