/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import com.openindex.openestate.tool.ImmoToolFrontpageWidget;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.application.ResourceMap;

public class SyndicationEntryReaderWidget
extends ImmoToolFrontpageWidget {
    private ResourceMap resourceMap;
    private SyndEntry newsEntry;
    private JEditorPane newsReaderField;
    private JButton openWebsiteButton;
    private JPanel widgetPanel;

    public SyndicationEntryReaderWidget(String string) {
        this(string, null);
    }

    public SyndicationEntryReaderWidget(String string, SyndEntry syndEntry) {
        super(SyndicationEntryReaderWidget.getInstanceTitle(string));
        this.showWidget();
        this.build(syndEntry);
    }

    private void build(SyndEntry syndEntry) {
        this.setEntry(syndEntry);
        this.reload();
    }

    @Override
    protected JComponent buildWidget() {
        if (this.resourceMap == null) {
            this.resourceMap = ImmoToolUtils.getResourceMap(SyndicationEntryReaderWidget.class);
        }
        if (this.widgetPanel == null) {
            this.openWebsiteButton = new JButton();
            this.openWebsiteButton.setName("openWebsiteButton");
            this.openWebsiteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SyndicationEntryReaderWidget.this.newsEntry == null || SyndicationEntryReaderWidget.this.newsEntry.getLink() == null || SyndicationEntryReaderWidget.this.newsEntry.getLink().trim().length() == 0) {
                        return;
                    }
                    ImmoToolUtils.openURL(SyndicationEntryReaderWidget.this.newsEntry.getLink());
                }
            });
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(this.openWebsiteButton);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            jPanel2.add((Component)ImmoToolUtils.createHead1Separator(this.resourceMap.getString("title", new Object[0])), "Center");
            jPanel2.add((Component)jPanel, "East");
            this.newsReaderField = new JEditorPane();
            this.newsReaderField.setName("newsReaderField");
            this.newsReaderField.setEditable(false);
            this.newsReaderField.setContentType("text/html");
            this.newsReaderField.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.newsReaderField.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (HyperlinkEvent.EventType.ACTIVATED.equals(hyperlinkEvent.getEventType())) {
                        ImmoToolUtils.openURL(hyperlinkEvent.getURL());
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.newsReaderField);
            jScrollPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
            this.widgetPanel = new JPanel(new BorderLayout());
            this.widgetPanel.setName("widgetPanel");
            this.widgetPanel.add((Component)jPanel2, "North");
            this.widgetPanel.add((Component)jScrollPane, "Center");
            this.resourceMap.injectComponents((Component)this.widgetPanel);
        }
        return this.widgetPanel;
    }

    public SyndEntry getEntry() {
        return this.newsEntry;
    }

    public static String getInstanceTitle(String string) {
        return ImmoToolUtils.getResourceMap(SyndicationEntryReaderWidget.class).getString("widgetTitle", new Object[]{string});
    }

    @Override
    public void reload() {
        if (this.newsEntry != null) {
            String string = this.newsEntry.getPublishedDate() != null ? "<i>" + DateFormat.getDateInstance(2).format(this.newsEntry.getPublishedDate()) + "</i>: " : "";
            String string2 = null;
            if (!this.newsEntry.getContents().isEmpty()) {
                string2 = string2 + ((SyndContentImpl)this.newsEntry.getContents().get(0)).getValue();
            }
            if (StringUtils.isBlank(string2) && this.newsEntry.getDescription() != null) {
                string2 = this.newsEntry.getDescription().getValue();
            }
            this.newsReaderField.setText("<html><div style=\"font-family:sans-serif;\"><h2>" + this.newsEntry.getTitle() + "</h2>" + "<div>" + string + string2 + "</div>" + "</div></html>");
            this.newsReaderField.setCaretPosition(0);
        }
    }

    public void setEntry(SyndEntry syndEntry) {
        this.newsEntry = syndEntry;
        this.openWebsiteButton.setEnabled(this.newsEntry != null && this.newsEntry.getLink() != null && this.newsEntry.getLink().trim().length() > 0);
    }
}

