/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.HashGenerator;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.modules.XMLResource;

public class SyndicationFeed {
    public static final String KEY_TITLE = "title";
    public static final String KEY_URL = "url";
    private String title = "";
    private URL url = null;

    public SyndicationFeed() {
    }

    public SyndicationFeed(String string, URL uRL) {
        this.setTitle(string);
        this.setUrl(uRL);
    }

    public static SyndEntry[] getSyndFeedEntries(SyndFeed syndFeed) {
        List list = syndFeed.getEntries();
        ArrayList<SyndEntry> arrayList = new ArrayList<SyndEntry>(list.size());
        for (Object e : list) {
            arrayList.add((SyndEntry)e);
        }
        return arrayList.toArray(new SyndEntry[arrayList.size()]);
    }

    public String getTitle() {
        return this.title;
    }

    public URL getUrl() {
        return this.url;
    }

    public void load(Properties properties, int n) throws MalformedURLException {
        this.setTitle(String.valueOf(properties.getProperty("title." + n, "")));
        this.setUrl(properties.getProperty("url." + n) != null ? new URL(properties.getProperty("url." + n)) : null);
    }

    public SyndFeed loadSyndFeed() throws IllegalArgumentException, FeedException, IOException, ImmoToolDbException {
        return SyndicationFeed.loadSyndFeed(this.getUrl());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SyndFeed loadSyndFeed(URL uRL) throws IllegalArgumentException, FeedException, IOException, ImmoToolDbException {
        SyndFeed syndFeed;
        block10: {
            String string;
            XMLResource xMLResource;
            Collection collection;
            block8: {
                SyndFeed syndFeed2;
                block9: {
                    collection = null;
                    xMLResource = null;
                    String string2 = HashGenerator.messageDigestAsString(uRL.toString(), "SHA");
                    string = "rss_feed_" + string2 + ".xml";
                    collection = ImmoToolApp.getApplication().getDatabase().openTempCollection();
                    if (ImmoToolDbUtils.hasResource(collection, string)) break block8;
                    syndFeed2 = null;
                    if (collection == null) break block9;
                    ImmoToolDbUtils.close(collection);
                }
                return syndFeed2;
            }
            try {
                xMLResource = ImmoToolDbUtils.loadXMLResource(collection, string);
                if (xMLResource == null) {
                    throw new ImmoToolDbException("could not load temp-resource: " + string);
                }
                SyndFeedInput syndFeedInput = new SyndFeedInput();
                syndFeed = syndFeedInput.build((Reader)new StringReader((String)xMLResource.getContent()));
                if (collection == null) break block10;
            }
            catch (ImmoToolDbException immoToolDbException) {
                try {
                    throw immoToolDbException;
                    catch (Exception exception) {
                        throw new ImmoToolDbException(exception.getLocalizedMessage(), exception);
                    }
                }
                catch (Throwable throwable) {
                    if (collection != null) {
                        ImmoToolDbUtils.close(collection);
                    }
                    throw throwable;
                }
            }
            ImmoToolDbUtils.close(collection);
        }
        return syndFeed;
    }

    public SyndFeed loadSyndFeedExternal(HttpClient httpClient, boolean bl) throws IllegalArgumentException, FeedException, IOException, ImmoToolDbException {
        return SyndicationFeed.loadSyndFeedExternal(httpClient, this.getUrl(), bl);
    }

    public static SyndFeed loadSyndFeedExternal(HttpClient httpClient, URL uRL, boolean bl) throws IllegalArgumentException, FeedException, IOException, ImmoToolDbException {
        Object object;
        HttpResponse httpResponse;
        SyndFeed syndFeed = null;
        String string = null;
        InputStreamReader inputStreamReader = null;
        StringWriter stringWriter = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)new HttpGet(ImmoToolUtils.toIdnUrl(uRL).toURI()));
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new Exception("Invalid server response: " + httpResponse.getStatusLine().getReasonPhrase() + " (" + httpResponse.getStatusLine().getStatusCode() + ")");
            }
            object = httpResponse.getEntity();
            inputStreamReader = new InputStreamReader(new BufferedInputStream(object.getContent()));
            stringWriter = new StringWriter();
            IOUtils.copy((Reader)inputStreamReader, (Writer)stringWriter);
            stringWriter.flush();
            string = stringWriter.toString();
            EntityUtils.consume((HttpEntity)object);
        }
        catch (Exception exception) {
            try {
                throw new FeedException(exception.getLocalizedMessage(), (Throwable)exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStreamReader);
                IOUtils.closeQuietly(stringWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)inputStreamReader);
        IOUtils.closeQuietly((Writer)stringWriter);
        syndFeed = new SyndFeedInput().build((Reader)new StringReader(string));
        if (bl) {
            httpResponse = null;
            try {
                object = HashGenerator.messageDigestAsString(uRL.toString(), "SHA");
                String string2 = "rss_feed_" + (String)object + ".xml";
                httpResponse = ImmoToolApp.getApplication().getDatabase().openTempCollection();
                XMLResource xMLResource = null;
                xMLResource = !ImmoToolDbUtils.hasResource((Collection)httpResponse, string2) ? ImmoToolDbUtils.createXmlResource((Collection)httpResponse, string2) : ImmoToolDbUtils.loadXMLResource((Collection)httpResponse, string2);
                if (xMLResource == null) {
                    throw new ImmoToolDbException("could not load xml-resource!");
                }
                xMLResource.setContent((Object)string);
                ImmoToolDbUtils.storeResource((Collection)httpResponse, (Resource)xMLResource);
            }
            catch (ImmoToolDbException immoToolDbException) {
                throw immoToolDbException;
            }
            catch (Exception exception) {
                throw new ImmoToolDbException(exception.getLocalizedMessage(), exception);
            }
            finally {
                if (httpResponse != null) {
                    ImmoToolDbUtils.close((Collection)httpResponse);
                }
            }
        }
        return syndFeed;
    }

    public static SyndicationFeed[] loadSyndicationFeeds() throws ImmoToolDbException {
        try {
            ArrayList<SyndicationFeed> arrayList = new ArrayList<SyndicationFeed>();
            Properties properties = ImmoToolApp.getApplication().getDatabase().loadRssFeeds();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.startsWith("url.")) continue;
                String[] stringArray = string.split("\\.");
                SyndicationFeed syndicationFeed = new SyndicationFeed();
                syndicationFeed.load(properties, Integer.valueOf(stringArray[stringArray.length - 1]));
                arrayList.add(syndicationFeed);
            }
            return arrayList.toArray(new SyndicationFeed[arrayList.size()]);
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), exception);
        }
    }

    public void save(Properties properties, int n) {
        properties.setProperty("title." + n, this.getTitle());
        if (this.getUrl() != null) {
            properties.setProperty("url." + n, this.getUrl().toString());
        }
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public static void storeSyndicationFeeds(SyndicationFeed[] syndicationFeedArray) throws ImmoToolDbException {
        try {
            Properties properties = new Properties();
            for (int i = 0; i < syndicationFeedArray.length; ++i) {
                syndicationFeedArray[i].save(properties, i);
            }
            ImmoToolApp.getApplication().getDatabase().storeRssFeeds(properties);
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), exception);
        }
    }
}

