/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang.SystemUtils;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXPanel;

public class SyndicationFeedDialog
extends JDialog {
    public static final int OPENED = 0;
    public static final int CANCELLED = 1;
    public static final int APPROVED = 2;
    private int status = 0;
    private ResourceMap resourceMap;
    private ValidationHandler validationHandler;
    private JTextField feedTitleField;
    private JTextField feedUrlField;
    private JButton cancelButton;
    private JButton submitButton;

    public SyndicationFeedDialog() {
        this((Frame)ImmoToolApp.getApplication().getMainFrame(), true);
    }

    public SyndicationFeedDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.build();
    }

    private void build() {
        this.setContentPane((Container)new JXPanel());
        this.resourceMap = ImmoToolUtils.getResourceMap(SyndicationFeedDialog.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.buildForm();
        this.resourceMap.injectComponents((Component)this);
        this.setDefaultCloseOperation(0);
        this.submitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SyndicationFeedDialog.this.validationHandler.validate();
                if (!SyndicationFeedDialog.this.validationHandler.isValid()) {
                    ImmoToolUtils.showMessageErrorDialog("Die Eingaben sind unvollst\u00e4ndig!");
                    return;
                }
                SyndicationFeedDialog.this.status = 2;
                SyndicationFeedDialog.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SyndicationFeedDialog.this.status = 1;
                SyndicationFeedDialog.this.setVisible(false);
            }
        });
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.cancelButton.setOpaque(false);
            this.submitButton.setOpaque(false);
        }
        this.pack();
        ImmoToolUtils.configureDialog(this, (JXPanel)this.getContentPane());
    }

    private void buildForm() {
        this.feedTitleField = new JTextField();
        this.feedTitleField.setName("feedTitleField");
        this.feedUrlField = new JTextField();
        this.feedUrlField.setName("feedUrlField");
        this.validationHandler.putRule(this.feedTitleField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule(this.feedUrlField, ValidationHandler.URL);
        this.cancelButton = new JButton();
        this.cancelButton.setName("cancelButton");
        this.submitButton = new JButton();
        this.submitButton.setName("submitButton");
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.setOpaque(false);
        jPanel.add(this.submitButton);
        jPanel.add(this.cancelButton);
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder("pref:grow");
        defaultFormBuilder.opaque(false);
        defaultFormBuilder.border(Borders.DIALOG);
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator(this.resourceMap.getString("label.feedName", new Object[0])));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.feedTitleField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator(this.resourceMap.getString("label.feedUrl", new Object[0])));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.feedUrlField);
        defaultFormBuilder.nextLine();
        this.setLayout(new BorderLayout(5, 5));
        this.getContentPane().add((Component)defaultFormBuilder.getPanel(), "Center");
        this.getContentPane().add((Component)jPanel, "South");
    }

    public String getFeedTitle() {
        return this.feedTitleField.getText().trim();
    }

    public URL getFeedUrl() throws MalformedURLException {
        return new URL(this.feedUrlField.getText().trim());
    }

    public int getStatus() {
        return this.status;
    }

    public void load(String string, URL uRL) {
        this.feedTitleField.setText(string);
        this.feedUrlField.setText(uRL != null ? uRL.toString() : "");
    }
}

