/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.tool.ImmoToolFrontpageWidget;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.SyndicationFeed;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXTitledSeparator;
import org.jdesktop.swingx.JXTree;

public class SyndicationFeedReaderWidget
extends ImmoToolFrontpageWidget {
    private static final Logger LOGGER = Logger.getLogger(SyndicationFeedReaderWidget.class);
    private static final DateFormat DATEFORMAT = DateFormat.getDateInstance(3);
    private ResourceMap resourceMap;
    private JXTree feedTree;
    private URL feedEntryLink;
    private JButton openWebsiteButton;
    private JEditorPane feedEntryReader;
    private JSplitPane feedSplitPane;
    private JPanel feedPanel;
    private JXTitledSeparator titleLabel;

    public SyndicationFeedReaderWidget() {
        super(SyndicationFeedReaderWidget.getInstanceTitle());
        this.showWidget();
    }

    @Override
    protected JComponent buildWidget() {
        if (this.resourceMap == null) {
            this.resourceMap = ImmoToolUtils.getResourceMap(SyndicationFeedReaderWidget.class);
        }
        if (this.feedPanel == null) {
            this.feedTree = new JXTree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
            this.feedTree.setName("feedTree");
            this.feedTree.setRootVisible(false);
            this.feedTree.setRolloverEnabled(true);
            this.feedTree.setToggleClickCount(1);
            this.feedTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    FeedTreeNode feedTreeNode;
                    if (SyndicationFeedReaderWidget.this.feedTree.getSelectionPath() == null) {
                        return;
                    }
                    Object object = SyndicationFeedReaderWidget.this.feedTree.getSelectionPath().getLastPathComponent();
                    if (object instanceof FeedTreeNode && (feedTreeNode = (FeedTreeNode)object).isEntry()) {
                        SyndicationFeedReaderWidget.this.viewEntry(feedTreeNode.getEntry());
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane((Component)this.feedTree);
            jScrollPane.setPreferredSize(new Dimension(150, jScrollPane.getPreferredSize().height));
            jScrollPane.setBorder(Borders.EMPTY);
            this.feedEntryReader = new JEditorPane();
            this.feedEntryReader.setName("feedEntryReader");
            this.feedEntryReader.setEditable(false);
            this.feedEntryReader.setVisible(false);
            this.feedEntryReader.setOpaque(true);
            this.feedEntryReader.setContentType("text/html");
            this.feedEntryReader.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (HyperlinkEvent.EventType.ACTIVATED.equals(hyperlinkEvent.getEventType())) {
                        ImmoToolUtils.openURL(hyperlinkEvent.getURL());
                    }
                }
            });
            this.openWebsiteButton = new JButton();
            this.openWebsiteButton.setName("openWebsiteButton");
            this.openWebsiteButton.setEnabled(false);
            this.openWebsiteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SyndicationFeedReaderWidget.this.feedEntryLink == null) {
                        return;
                    }
                    ImmoToolUtils.openURL(SyndicationFeedReaderWidget.this.feedEntryLink.toString());
                }
            });
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(this.openWebsiteButton);
            this.titleLabel = ImmoToolUtils.createHead1Separator("");
            this.titleLabel.setName("titleLabel");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            jPanel2.add((Component)this.titleLabel, "Center");
            jPanel2.add((Component)jPanel, "East");
            JScrollPane jScrollPane2 = new JScrollPane(this.feedEntryReader);
            jScrollPane2.setBorder(Borders.EMPTY);
            this.feedSplitPane = new JSplitPane();
            this.feedSplitPane.setLeftComponent(jScrollPane);
            this.feedSplitPane.setRightComponent(jScrollPane2);
            this.feedSplitPane.setDividerLocation(250);
            this.feedSplitPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
            this.feedPanel = new JPanel(new BorderLayout());
            this.feedPanel.add((Component)jPanel2, "North");
            this.feedPanel.add((Component)this.feedSplitPane, "Center");
            this.resourceMap.injectComponents((Component)this.feedPanel);
        }
        return this.feedPanel;
    }

    public static String getInstanceTitle() {
        return ImmoToolUtils.getResourceMap(SyndicationFeedReaderWidget.class).getString("widgetTitle", new Object[]{ImmoToolUtils.getResourceMap(SyndicationFeedReaderWidget.class).getString("widgetSubtitle", new Object[0])});
    }

    @Override
    public void load() {
        this.load(false);
    }

    private void load(boolean bl) {
        HttpClient httpClient = ImmoToolUtils.createHttpClient();
        try {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
            TreeMap<SyndEntry[], SyndicationFeed> treeMap = new TreeMap<SyndEntry[], SyndicationFeed>();
            for (SyndicationFeed syndicationFeed2 : SyndicationFeed.loadSyndicationFeeds()) {
                SyndEntry[] syndEntryArray = syndicationFeed2.getTitle().toLowerCase();
                int n = 0;
                while (treeMap.containsKey(syndEntryArray)) {
                    syndEntryArray = syndicationFeed2.getTitle().toLowerCase() + "_" + n;
                    ++n;
                }
                if (treeMap.containsKey(syndEntryArray)) continue;
                treeMap.put(syndEntryArray, syndicationFeed2);
            }
            for (SyndicationFeed syndicationFeed : treeMap.values()) {
                try {
                    SyndicationFeed syndicationFeed2;
                    FeedTreeNode feedTreeNode = new FeedTreeNode(syndicationFeed);
                    syndicationFeed2 = null;
                    if (bl) {
                        syndicationFeed2 = SyndicationFeed.loadSyndFeed(syndicationFeed.getUrl());
                    }
                    if (syndicationFeed2 == null) {
                        try {
                            syndicationFeed2 = SyndicationFeed.loadSyndFeedExternal(httpClient, syndicationFeed.getUrl(), true);
                        }
                        catch (Exception exception) {
                            LOGGER.warn((Object)"could not load external rss-feed!");
                            LOGGER.warn((Object)("> " + syndicationFeed.getUrl().toString()));
                            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                        }
                    }
                    if (syndicationFeed2 == null) continue;
                    for (SyndEntry syndEntry : SyndicationFeed.getSyndFeedEntries((SyndFeed)syndicationFeed2)) {
                        feedTreeNode.add(new FeedTreeNode(syndEntry));
                    }
                    defaultMutableTreeNode.add(feedTreeNode);
                }
                catch (Exception exception) {
                    LOGGER.error((Object)("Can't load syndication feed from: " + syndicationFeed.getUrl()));
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
            this.feedTree.setModel((TreeModel)defaultTreeModel);
            this.feedTree.expandAll();
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    @Override
    public void reload() {
        this.load(true);
    }

    private void viewEntry(SyndEntry syndEntry) {
        Object object;
        String string;
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><body style=\"font-family:sans-serif;\">");
        String string3 = string2 = syndEntry.getTitle() != null ? syndEntry.getTitle().trim() : "";
        if (string2.trim().length() == 0) {
            string2 = "<i>" + this.resourceMap.getString("label.emptyTitle", new Object[0]) + "</i>";
        }
        stringBuilder.append("<h2>").append(ImmoToolUtils.replaceTags(string2).trim()).append("</h2>");
        Date date = syndEntry.getPublishedDate() != null ? syndEntry.getPublishedDate() : null;
        String string4 = string = syndEntry.getAuthor() != null && syndEntry.getAuthor().trim().length() > 0 ? syndEntry.getAuthor().trim() : null;
        if (date != null || string != null) {
            stringBuilder.append("<h3>");
            if (date != null) {
                object = DateFormat.getDateTimeInstance(2, 3);
                stringBuilder.append(this.resourceMap.getString("label.date", new Object[0])).append(" ").append(((DateFormat)object).format(date)).append(" ");
            }
            if (string != null) {
                stringBuilder.append(this.resourceMap.getString("label.author", new Object[0])).append(" ").append(ImmoToolUtils.replaceTags(string).trim()).append(" ");
            }
            stringBuilder.append("</h3>");
        }
        Object object2 = object = syndEntry.getDescription() != null && syndEntry.getDescription().getValue() != null ? ImmoToolUtils.replaceTags(syndEntry.getDescription().getValue()).trim() : "";
        if (((String)object).trim().length() == 0) {
            stringBuilder.append("<p><i>").append(this.resourceMap.getString("label.emptyText", new Object[0])).append("</i></p>");
        } else {
            stringBuilder.append("<p>").append(((String)object).replaceAll("\\n", "<br>")).append("</p>");
        }
        stringBuilder.append("</body></html>");
        this.feedEntryReader.setText(stringBuilder.toString());
        this.feedEntryReader.setCaretPosition(0);
        this.feedEntryReader.setVisible(true);
        this.openWebsiteButton.setEnabled(false);
        this.openWebsiteButton.setToolTipText(this.resourceMap.getString("label.emptyLink", new Object[0]));
        if (syndEntry.getLink() != null && syndEntry.getLink().trim().length() > 0) {
            try {
                this.feedEntryLink = new URL(syndEntry.getLink().trim());
                this.openWebsiteButton.setEnabled(true);
                this.openWebsiteButton.setToolTipText(this.feedEntryLink.toString());
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"invalid feed-entry-url!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
    }

    private class FeedTreeNode
    extends DefaultMutableTreeNode {
        public static final int FEED = 0;
        public static final int ENTRY = 1;
        private SyndicationFeed feed = null;
        private SyndEntry entry = null;
        private int type = 0;

        public FeedTreeNode(SyndicationFeed syndicationFeed) {
            this.feed = syndicationFeed;
            this.type = 0;
        }

        public FeedTreeNode(SyndEntry syndEntry) {
            this.entry = syndEntry;
            this.type = 1;
        }

        public SyndEntry getEntry() {
            return this.entry;
        }

        public SyndicationFeed getFeed() {
            return this.feed;
        }

        public boolean isEntry() {
            return this.type == 1;
        }

        public boolean isFeed() {
            return this.type == 0;
        }

        @Override
        public String toString() {
            if (this.isFeed()) {
                return "<html><b>" + this.feed.getTitle() + "</b></html>";
            }
            if (this.isEntry()) {
                String string;
                String string2 = string = this.entry.getTitle() != null ? this.entry.getTitle().trim() : "<i>" + SyndicationFeedReaderWidget.this.resourceMap.getString("label.emptyTitle", new Object[0]) + "</i>";
                if (string.length() > 50) {
                    string = string.substring(0, 50) + "...";
                }
                if (this.entry.getPublishedDate() != null) {
                    string = DATEFORMAT.format(this.entry.getPublishedDate()) + " | " + string;
                }
                return "<html>" + string + "</html>";
            }
            return "";
        }
    }
}

