/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.ValidationPattern;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXDatePicker;

public class ValidationHandler {
    private static final Logger LOGGER = Logger.getLogger(ValidationHandler.class);
    private Map<JComponent, ValidationRule> validationRules;
    private Map<Class, Color> validationDefaultColors;
    public static final ValidationRule NOT_BLANK = new ValidationPattern(".+");
    public static final ValidationRule NOT_NULL = new ValidationRule(){

        @Override
        public boolean isValid(Object object) {
            return object != null;
        }
    };
    public static final ValidationRule NUMERIC = new ValidationPattern("\\d+");
    public static final ValidationRule EMAIL = new ValidationRule(){

        @Override
        public boolean isValid(Object object) {
            return object != null && ImmoToolUtils.isValidMailAddress(object.toString());
        }
    };
    public static final ValidationRule HOSTNAME = new ValidationRule(){

        @Override
        public boolean isValid(Object object) {
            return object != null && ImmoToolUtils.isValidHostname(object.toString());
        }
    };
    public static final ValidationRule URL = new ValidationPattern("https?://.*");
    private boolean enabled = true;
    private Color requirdedInputColor = null;
    private Color invalidInputColor = null;
    private Color validInputColor = null;

    public ValidationHandler() {
        this(Color.YELLOW, Color.GREEN, Color.RED);
    }

    public ValidationHandler(Color color, Color color2, Color color3) {
        this.requirdedInputColor = color;
        this.validInputColor = color2;
        this.invalidInputColor = color3;
        this.validationRules = new HashMap<JComponent, ValidationRule>();
        this.validationDefaultColors = new HashMap<Class, Color>();
    }

    public Color getInvalidInputColor() {
        return this.invalidInputColor;
    }

    public Color getRequirdedInputColor() {
        return this.requirdedInputColor;
    }

    public Color getValidInputColor() {
        return this.validInputColor;
    }

    public Object getValue(JComponent jComponent) {
        return ImmoToolUtils.getComponentValue(jComponent);
    }

    public void init() {
        for (JComponent jComponent : this.validationRules.keySet()) {
            if (this.isValidatable(jComponent)) {
                this.paint(jComponent, this.isValid(jComponent) ? this.validInputColor : this.requirdedInputColor);
                continue;
            }
            this.paint(jComponent, this.validationDefaultColors.get(jComponent.getClass()));
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isValid() {
        for (JComponent jComponent : this.validationRules.keySet()) {
            if (!this.isValidatable(jComponent) || this.isValid(jComponent)) continue;
            return false;
        }
        return true;
    }

    public boolean isValid(JComponent jComponent) {
        return this.validationRules.containsKey(jComponent) ? this.isValid(jComponent, this.getValue(jComponent)) : false;
    }

    public boolean isValid(JComponent jComponent, Object object) {
        return this.validationRules.containsKey(jComponent) ? this.validationRules.get(jComponent).isValid(object) : false;
    }

    public boolean isValidatable(JComponent jComponent) {
        if (!this.isEnabled()) {
            return false;
        }
        if (!jComponent.isEnabled()) {
            return false;
        }
        return !(jComponent instanceof JTextComponent) || ((JTextComponent)jComponent).isEditable();
    }

    public void paint(JComponent jComponent, Color color) {
        if (jComponent instanceof JXDatePicker) {
            ((JXDatePicker)jComponent).getEditor().setBackground(color);
        } else if (jComponent instanceof JSpinner) {
            if (((JSpinner)jComponent).getEditor() instanceof JSpinner.DefaultEditor) {
                ((JSpinner.DefaultEditor)((JSpinner)jComponent).getEditor()).getTextField().setBackground(color);
            } else {
                ((JSpinner)jComponent).getEditor().setBackground(color);
            }
        } else if (jComponent instanceof JComboBox) {
            ((JComboBox)jComponent).setBackground(color);
            ComboBoxEditor comboBoxEditor = ((JComboBox)jComponent).getEditor();
            if (comboBoxEditor != null) {
                comboBoxEditor.getEditorComponent().setBackground(color);
            }
        } else {
            jComponent.setBackground(color);
        }
    }

    public void putRule(JComponent jComponent, ValidationRule validationRule) {
        jComponent.setOpaque(true);
        if (!this.validationDefaultColors.containsKey(jComponent.getClass())) {
            this.validationDefaultColors.put(jComponent.getClass(), jComponent.getBackground() != null ? jComponent.getBackground() : Color.WHITE);
        }
        if (!this.validationRules.containsKey(jComponent)) {
            if (jComponent instanceof JTextField) {
                jComponent.setOpaque(true);
                ((JTextField)jComponent).addFocusListener(new ValidationFocusListener(this));
                ((JTextField)jComponent).addKeyListener(new ValidationKeyListener(this));
            } else if (jComponent instanceof JComboBox) {
                jComponent.setOpaque(true);
                ((JComboBox)jComponent).addActionListener(new ValidationActionListener(this));
                ((JComboBox)jComponent).addFocusListener(new ValidationFocusListener(this));
                ComboBoxEditor comboBoxEditor = ((JComboBox)jComponent).getEditor();
                if (comboBoxEditor != null && comboBoxEditor.getEditorComponent() instanceof JComponent) {
                    ((JComponent)comboBoxEditor.getEditorComponent()).setOpaque(true);
                }
            } else if (jComponent instanceof JXDatePicker) {
                jComponent.setOpaque(true);
                ((JXDatePicker)jComponent).getEditor().setOpaque(true);
                ((JXDatePicker)jComponent).addActionListener((ActionListener)new ValidationActionListener(this));
                ((JXDatePicker)jComponent).addFocusListener((FocusListener)new ValidationFocusListener(this));
                ((JXDatePicker)jComponent).addKeyListener((KeyListener)new ValidationKeyListener(this));
            } else if (jComponent instanceof JSpinner) {
                jComponent.setOpaque(true);
                if (((JSpinner)jComponent).getEditor() instanceof JSpinner.DefaultEditor) {
                    ((JSpinner.DefaultEditor)((JSpinner)jComponent).getEditor()).getTextField().setOpaque(true);
                }
                ((JSpinner)jComponent).addChangeListener(new ValidationChangeListener(this));
                ((JSpinner)jComponent).addFocusListener(new ValidationFocusListener(this));
                ((JSpinner)jComponent).addKeyListener(new ValidationKeyListener(this));
            } else {
                LOGGER.warn((Object)("no validation handling supported for " + jComponent.getClass().getName()));
                return;
            }
        }
        this.validationRules.put(jComponent, validationRule);
        this.paint(jComponent, validationRule.isValid(this.getValue(jComponent)) ? this.validInputColor : this.requirdedInputColor);
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void validate() {
        for (JComponent jComponent : this.validationRules.keySet()) {
            this.validate(jComponent);
        }
    }

    public void validate(JComponent jComponent) {
        if (!this.isValidatable(jComponent)) {
            this.paint(jComponent, this.validationDefaultColors.get(jComponent.getClass()));
        } else if (this.isValid(jComponent)) {
            this.paint(jComponent, this.validInputColor);
        } else {
            this.paint(jComponent, this.invalidInputColor);
        }
    }

    private static class ValidationKeyListener
    implements KeyListener {
        private ValidationHandler validationHandler = null;

        public ValidationKeyListener(ValidationHandler validationHandler) {
            this.validationHandler = validationHandler;
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.validationHandler.validate((JComponent)keyEvent.getComponent());
        }
    }

    private static class ValidationFocusListener
    implements FocusListener {
        private ValidationHandler validationHandler = null;

        public ValidationFocusListener(ValidationHandler validationHandler) {
            this.validationHandler = validationHandler;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.validationHandler.validate((JComponent)focusEvent.getSource());
        }
    }

    private static class ValidationChangeListener
    implements ChangeListener {
        private ValidationHandler validationHandler = null;

        public ValidationChangeListener(ValidationHandler validationHandler) {
            this.validationHandler = validationHandler;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.validationHandler.validate((JComponent)changeEvent.getSource());
        }
    }

    private static class ValidationActionListener
    implements ActionListener {
        private ValidationHandler validationHandler = null;

        public ValidationActionListener(ValidationHandler validationHandler) {
            this.validationHandler = validationHandler;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.validationHandler.validate((JComponent)actionEvent.getSource());
        }
    }
}

