/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import com.openindex.openestate.impl.CompanyAdressImpl;
import com.openindex.openestate.impl.PersonAdressImpl;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskException;
import com.openindex.openestate.tool.ImmoToolUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.Date;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;

public abstract class XlsExportTask<XlsType>
extends ImmoToolTask<Long> {
    private static final Logger LOGGER = Logger.getLogger(XlsExportTask.class);
    private ResourceMap resourceMap = null;
    private File xlsFile = null;
    private String xlsTitle = null;
    private Charset xlsCharset = null;

    protected XlsExportTask(File file, Charset charset, String string) {
        this.xlsFile = file;
        this.xlsTitle = string;
        this.xlsCharset = charset;
        this.resourceMap = ImmoToolUtils.getResourceMap(XlsExportTask.class);
        this.setTitle(this.resourceMap.getString("title", new Object[0]));
    }

    protected WritableWorkbook createWorkbook(File file, WorkbookSettings workbookSettings) throws IOException {
        return Workbook.createWorkbook((File)file, (WorkbookSettings)workbookSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long executeExport() throws IOException, WriteException, ImmoToolException {
        if (this.xlsFile.isDirectory()) {
            throw new ImmoToolTaskException("XLS file is invalid!");
        }
        WritableWorkbook writableWorkbook = null;
        try {
            Object object2;
            WritableCellFormat writableCellFormat;
            WritableCellFormat writableCellFormat2;
            WritableCellFormat writableCellFormat3;
            WorkbookSettings workbookSettings = new WorkbookSettings();
            workbookSettings.setUseTemporaryFileDuringWrite(true);
            workbookSettings.setEncoding(this.xlsCharset != null ? this.xlsCharset.name() : Charset.defaultCharset().name());
            writableWorkbook = this.createWorkbook(this.xlsFile, workbookSettings);
            WritableSheet writableSheet = writableWorkbook.createSheet(this.xlsTitle, 0);
            WritableCellFormat writableCellFormat4 = this.loadXlsObjects();
            int n = 0;
            int n2 = -1;
            for (int i = 0; i < this.getHeadlineRowspan(); ++i) {
                String[] stringArray = this.getHeadlineValues(i);
                if (stringArray == null) continue;
                n2 = stringArray.length;
                writableCellFormat3 = this.getHeadlineFormat(true);
                writableCellFormat2 = this.getHeadlineFormat(false);
                writableCellFormat = this.getHeadlineFormat(false);
                writableCellFormat.setBorder(Border.BOTTOM, BorderLineStyle.MEDIUM, Colour.BLACK);
                for (int j = 0; j < n2; ++j) {
                    WritableCellFormat writableCellFormat5 = n == 0 ? writableCellFormat3 : (i + 1 < this.getHeadlineRowspan() ? writableCellFormat2 : writableCellFormat);
                    writableSheet.addCell((WritableCell)new Label(j, n, stringArray[j] != null ? stringArray[j] : "", (CellFormat)writableCellFormat5));
                }
                ++n;
            }
            long l = 0L;
            writableCellFormat3 = this.getRow1Format();
            writableCellFormat2 = this.getRow2Format();
            for (Object object2 : writableCellFormat4) {
                try {
                    String[] stringArray = this.loadEmptyContainer();
                    this.writeValues(object2, stringArray);
                    for (int i = 0; i < stringArray.length; ++i) {
                        WritableCellFormat writableCellFormat6 = l % 2L == 0L ? writableCellFormat3 : writableCellFormat2;
                        Label label = new Label(i, n, stringArray[i] != null ? stringArray[i] : "", (CellFormat)writableCellFormat6);
                        writableSheet.addCell((WritableCell)label);
                    }
                    ++n;
                    ++l;
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Can't execute XLS export!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
            writableCellFormat = this.getFootlineFormat(true);
            writableCellFormat.setAlignment(Alignment.RIGHT);
            WritableCellFormat writableCellFormat7 = this.getFootlineFormat(false);
            Date date = new Date();
            writableSheet.addCell((WritableCell)new Label(0, ++n, this.resourceMap.getString("label.stamp", new Object[0]), (CellFormat)writableCellFormat));
            writableSheet.addCell((WritableCell)new Label(1, n, DateFormat.getDateInstance(1).format(date) + ", " + DateFormat.getTimeInstance(2).format(date), (CellFormat)writableCellFormat7));
            if (ImmoToolApp.getApplication().getProject() != null) {
                writableSheet.addCell((WritableCell)new Label(0, ++n, this.resourceMap.getString("label.company", new Object[0]), (CellFormat)writableCellFormat));
                object2 = ImmoToolApp.getApplication().getProject().getAdress();
                writableSheet.addCell((WritableCell)new Label(1, n, ((CompanyAdressImpl)object2).getCompanyName() + " " + ((CompanyAdressImpl)object2).getCompanyType() + " (" + ((PersonAdressImpl)object2).writePersonFullName() + ")", (CellFormat)writableCellFormat7));
            }
            writableSheet.addCell((WritableCell)new Label(0, ++n, this.resourceMap.getString("label.source", new Object[0]), (CellFormat)writableCellFormat));
            writableSheet.addCell((WritableCell)new Label(1, n, ImmoToolApp.getApplicationTitle() + " v" + ImmoToolApp.getApplicationVersion(), (CellFormat)writableCellFormat7));
            writableWorkbook.write();
            object2 = l;
            return object2;
        }
        finally {
            if (writableWorkbook != null) {
                writableWorkbook.close();
            }
        }
    }

    @Override
    protected Long executeTask() throws Exception {
        return this.executeExport();
    }

    protected abstract String getFieldTitle(int var1);

    protected WritableCellFormat getFootlineFormat(boolean bl) throws WriteException {
        WritableCellFormat writableCellFormat = new WritableCellFormat(new WritableFont(WritableFont.ARIAL, 9, bl ? WritableFont.BOLD : WritableFont.NO_BOLD, true));
        return writableCellFormat;
    }

    protected WritableCellFormat getHeadlineFormat(boolean bl) throws WriteException {
        WritableCellFormat writableCellFormat = new WritableCellFormat(new WritableFont(WritableFont.ARIAL, 11, bl ? WritableFont.BOLD : WritableFont.NO_BOLD));
        writableCellFormat.setBackground(Colour.TURQUOISE);
        return writableCellFormat;
    }

    protected int getHeadlineRowspan() {
        return 1;
    }

    protected String[] getHeadlineValues(int n) {
        String[] stringArray = this.loadEmptyContainer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.getFieldTitle(i);
        }
        return stringArray;
    }

    protected WritableCellFormat getRow1Format() throws WriteException {
        WritableCellFormat writableCellFormat = new WritableCellFormat(new WritableFont(WritableFont.ARIAL, 10));
        writableCellFormat.setBorder(Border.BOTTOM, BorderLineStyle.HAIR, Colour.BLACK);
        return writableCellFormat;
    }

    protected WritableCellFormat getRow2Format() throws WriteException {
        WritableCellFormat writableCellFormat = new WritableCellFormat(new WritableFont(WritableFont.ARIAL, 10));
        writableCellFormat.setBackground(Colour.LIGHT_TURQUOISE2);
        writableCellFormat.setBorder(Border.BOTTOM, BorderLineStyle.HAIR, Colour.BLACK);
        return writableCellFormat;
    }

    protected abstract String[] loadEmptyContainer();

    protected abstract XlsType[] loadXlsObjects() throws ImmoToolException;

    protected void writeValue(int n, String string, String[] stringArray) {
        if (n < 0 || stringArray.length <= n) {
            return;
        }
        if (string == null || string.trim().length() == 0) {
            return;
        }
        stringArray[n] = string.trim();
    }

    protected abstract void writeValues(XlsType var1, String[] var2);
}

