/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils.engine;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.engine.DownloadMonitor;
import com.openindex.openestate.tool.utils.engine.PlugEngineException;
import com.openindex.openestate.tool.utils.engine.Pluggable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PlugEngine {
    private static final Logger LOGGER = Logger.getLogger(PlugEngine.class);
    public static final String FILE = "plugins.xml";
    public static final String DIR = "plugins";
    private static PlugEngine instance = new PlugEngine();
    private Object[] args;
    private int currentVersion = 0;
    private List<Pluggable> plugins = new ArrayList<Pluggable>();
    private Map<Class, String> localSources = new HashMap<Class, String>();
    private Map<Pluggable, Boolean> hiddens = new HashMap<Pluggable, Boolean>();
    private Map<Pluggable, Boolean> updateEnable = new HashMap<Pluggable, Boolean>();
    private Map<Pluggable, Boolean> enabled = new HashMap<Pluggable, Boolean>();
    private DownloadMonitor downloadMonitor = null;

    private PlugEngine() {
        File file = new File(DIR);
        if (!file.exists() && !file.mkdir()) {
            LOGGER.warn((Object)("could not create directory: " + file.getAbsolutePath()));
        }
    }

    public static PlugEngine getInstance() {
        return instance;
    }

    public static void setInstance(PlugEngine plugEngine) {
        instance = plugEngine;
    }

    public void init(Object ... objectArray) throws PlugEngineException {
        this.args = objectArray;
        this.loadPluggables(ImmoToolUtils.createHttpClient());
    }

    protected void loadPluggables(HttpClient httpClient) throws PlugEngineException {
        try {
            Object object;
            File file = new File(FILE);
            if (file.exists()) {
                object = new PlugEngineHandler(httpClient, true);
                SAXParserFactory.newInstance().newSAXParser().parse(file, (DefaultHandler)object);
            }
            object = new File(DIR);
            for (File file2 : ((File)object).listFiles(new RemovedPluginFolderFilter())) {
                for (File file3 : file2.listFiles()) {
                    if (file3.delete()) continue;
                    LOGGER.warn((Object)("could not delete: " + file3.getAbsolutePath()));
                }
                if (file2.delete()) continue;
                LOGGER.warn((Object)("could not delete: " + file2.getAbsolutePath()));
            }
        }
        catch (Exception exception) {
            throw new PlugEngineException("Unable to load plugins", exception);
        }
    }

    public void startPluggables() {
        for (Pluggable pluggable : this.plugins) {
            this.startPluggable(pluggable);
        }
    }

    public void startPluggable(Pluggable pluggable) {
        pluggable.init(this.args);
    }

    public void savePluggable() throws PlugEngineException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            document.setXmlStandalone(true);
            Element element = document.createElement("plugengine");
            document.appendChild(element);
            for (Pluggable pluggable : this.plugins) {
                Element element2 = document.createElement("plugin");
                element2.setAttribute("hidden", this.hiddens.get(pluggable).toString());
                element2.setAttribute("update", this.updateEnable.get(pluggable).toString());
                element2.setAttribute("enabled", this.enabled.get(pluggable).toString());
                element.appendChild(element2);
                Element element3 = document.createElement("source");
                element3.setTextContent(this.localSources.get(pluggable.getClass()));
                element2.appendChild(element3);
                Element element4 = document.createElement("class");
                element4.setTextContent(pluggable.getClass().getName());
                element2.appendChild(element4);
            }
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document), new StreamResult(new File(FILE)));
        }
        catch (Exception exception) {
            throw new PlugEngineException("Unable to save plugins list", exception);
        }
    }

    public Pluggable installOrUpdate(HttpClient httpClient, URI uRI) throws PlugEngineException {
        try {
            PlugEngineHandler plugEngineHandler = new PlugEngineHandler(httpClient, false);
            SAXParserFactory.newInstance().newSAXParser().parse(uRI.toString(), (DefaultHandler)plugEngineHandler);
            return plugEngineHandler.getPluggable();
        }
        catch (Exception exception) {
            throw new PlugEngineException("Unable to install plugin", exception);
        }
    }

    protected void addPluggable(Pluggable pluggable) throws PlugEngineException {
        Iterator<Pluggable> iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            Pluggable pluggable2 = iterator.next();
            if (!pluggable.getName().equals(pluggable2.getName())) continue;
            iterator.remove();
        }
        this.plugins.add(pluggable);
        this.hiddens.put(pluggable, false);
        this.updateEnable.put(pluggable, true);
        this.enabled.put(pluggable, this.isCompatible(pluggable));
        this.savePluggable();
    }

    public void removePluggable(Pluggable pluggable) throws PlugEngineException {
        pluggable.destroy();
        this.plugins.remove(pluggable);
        this.savePluggable();
        File file = new File(this.localSources.get(pluggable.getClass()));
        file.deleteOnExit();
        for (File file2 : file.listFiles()) {
            file2.deleteOnExit();
        }
    }

    public List<Pluggable> getAllPluggables() {
        return new ArrayList<Pluggable>(this.plugins);
    }

    public List<Pluggable> getAllVisiblePluggables() {
        ArrayList<Pluggable> arrayList = new ArrayList<Pluggable>();
        for (Pluggable pluggable : this.plugins) {
            if (this.isHidden(pluggable)) continue;
            arrayList.add(pluggable);
        }
        return arrayList;
    }

    public List<Pluggable> getAllUpdatablePluggables() {
        ArrayList<Pluggable> arrayList = new ArrayList<Pluggable>();
        for (Pluggable pluggable : this.plugins) {
            if (!this.isUpdateEnabled(pluggable)) continue;
            arrayList.add(pluggable);
        }
        return arrayList;
    }

    public List<Pluggable> getAllEnabledPluggables() {
        ArrayList<Pluggable> arrayList = new ArrayList<Pluggable>();
        for (Pluggable pluggable : this.plugins) {
            if (!this.isEnabled(pluggable)) continue;
            arrayList.add(pluggable);
        }
        return arrayList;
    }

    public boolean isHidden(Pluggable pluggable) {
        return this.hiddens.get(pluggable);
    }

    public boolean isUpdateEnabled(Pluggable pluggable) {
        return this.updateEnable.get(pluggable);
    }

    public void setUpdateEnabled(Pluggable pluggable, boolean bl) throws PlugEngineException {
        if (pluggable != null) {
            this.updateEnable.put(pluggable, bl);
            this.savePluggable();
        }
    }

    public boolean isEnabled(Pluggable pluggable) {
        return this.enabled.get(pluggable);
    }

    public void setEnabled(Pluggable pluggable, boolean bl) throws PlugEngineException {
        if (pluggable != null && (!bl || this.isCompatible(pluggable))) {
            this.enabled.put(pluggable, bl);
            this.savePluggable();
        }
    }

    public File getDirectory(Pluggable pluggable) {
        String string = this.localSources.get(pluggable.getClass());
        return new File(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pluggable> checkForUpdates(HttpClient httpClient) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        ArrayList<Pluggable> arrayList = new ArrayList<Pluggable>();
        for (Pluggable pluggable : this.getAllUpdatablePluggables()) {
            BufferedInputStream bufferedInputStream = null;
            try {
                PlugEngineHandler plugEngineHandler = new PlugEngineHandler(httpClient, pluggable);
                HttpResponse httpResponse = httpClient.execute((HttpUriRequest)new HttpGet(ImmoToolUtils.toIdnUrl(pluggable.getURI().toURL()).toURI()));
                if (httpResponse.getStatusLine().getStatusCode() != 200) {
                    throw new IOException("Update server send an illegal response: " + httpResponse.getStatusLine());
                }
                HttpEntity httpEntity = httpResponse.getEntity();
                bufferedInputStream = new BufferedInputStream(httpEntity.getContent());
                SAXParserFactory.newInstance().newSAXParser().parse((InputStream)bufferedInputStream, (DefaultHandler)plugEngineHandler);
                if (plugEngineHandler.isUpdate()) {
                    arrayList.add(pluggable);
                }
                EntityUtils.consume((HttpEntity)httpEntity);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)bufferedInputStream);
        }
        return arrayList;
    }

    public DownloadMonitor getDownloadMonitor() {
        return this.downloadMonitor;
    }

    public void setDownloadMonitor(DownloadMonitor downloadMonitor) {
        this.downloadMonitor = downloadMonitor;
    }

    public boolean isCompatible(Pluggable pluggable) {
        return pluggable.getMinimalVersion() <= this.getCurrentVersion();
    }

    public int getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(int n) throws PlugEngineException {
        this.currentVersion = n;
        if (this.plugins.size() > 0) {
            for (Pluggable pluggable : this.plugins) {
                if (!this.isEnabled(pluggable) || this.isCompatible(pluggable)) continue;
                this.enabled.put(pluggable, false);
            }
            this.savePluggable();
        }
    }

    protected static void addFileToClasspath(String string) throws Exception {
        PlugEngine.addFileToClasspath(new File(string));
    }

    protected static void addFileToClasspath(File file) throws Exception {
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)ClassLoader.getSystemClassLoader(), file.toURI().toURL());
    }

    protected String downloadFile(HttpClient httpClient, String string, String string2) throws PlugEngineException {
        String string3;
        BufferedOutputStream bufferedOutputStream = null;
        InputStream inputStream = null;
        String string4 = null;
        try {
            int n;
            File file = new File(DIR + File.separator + string2);
            if (!file.exists() && !file.mkdir()) {
                LOGGER.warn((Object)("could not create directory: " + file.getAbsolutePath()));
            }
            string4 = (n = string.lastIndexOf("/")) >= 0 && n < string.length() - 1 ? DIR + File.separator + string2 + File.separator + string.substring(n + 1) : DIR + File.separator + string2 + File.separator + string;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string4));
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)new HttpGet(ImmoToolUtils.toIdnUrl(string).toURI()));
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new Exception("Update server send an illegal response: " + httpResponse.getStatusLine());
            }
            HttpEntity httpEntity = httpResponse.getEntity();
            inputStream = new BufferedInputStream(httpEntity.getContent());
            if (this.getDownloadMonitor() != null) {
                inputStream = this.getDownloadMonitor().downloadStart(inputStream);
            }
            IOUtils.copy((InputStream)inputStream, (OutputStream)bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).flush();
            EntityUtils.consume((HttpEntity)httpEntity);
            string3 = string4;
        }
        catch (Exception exception) {
            try {
                LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
                throw new PlugEngineException("Unable to download file " + string, exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(bufferedOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)bufferedOutputStream);
        return string3;
    }

    private class RemovedPluginFolderFilter
    implements FileFilter {
        private RemovedPluginFolderFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory() && !file.getName().equalsIgnoreCase(".svn")) {
                String string = PlugEngine.DIR + File.separator + file.getName();
                return !PlugEngine.this.localSources.values().contains(string);
            }
            return false;
        }
    }

    protected class PlugEngineHandler
    extends DefaultHandler {
        private HttpClient client;
        private boolean inVersion = false;
        private boolean inClass = false;
        private boolean inSource = false;
        private boolean inPlugin = false;
        private boolean local;
        private boolean update = false;
        private boolean hidden = false;
        private boolean updateEnabled = true;
        private boolean enable = true;
        private String folder;
        private String source;
        private String newVersion;
        private Pluggable pluggable;

        public PlugEngineHandler(HttpClient httpClient, boolean bl) {
            this.client = httpClient;
            this.local = bl;
        }

        public PlugEngineHandler(HttpClient httpClient, Pluggable pluggable) {
            this.client = httpClient;
            this.local = false;
            this.pluggable = pluggable;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.inPlugin = string3.equalsIgnoreCase("plugin") || this.inPlugin;
            this.inVersion = this.inPlugin && string3.equalsIgnoreCase("version");
            this.inClass = this.inPlugin && string3.equalsIgnoreCase("class");
            boolean bl = this.inSource = this.inPlugin && string3.equalsIgnoreCase("source");
            if (string3.equalsIgnoreCase("plugin")) {
                this.hidden = Boolean.parseBoolean(attributes.getValue("hidden"));
                this.updateEnabled = !"false".equalsIgnoreCase(attributes.getValue("update"));
                this.enable = !"false".equalsIgnoreCase(attributes.getValue("enabled"));
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            block18: {
                try {
                    if (this.inVersion && this.pluggable != null) {
                        this.newVersion = new String(cArray, n, n2);
                        if (this.pluggable.getVersion() != null && !this.pluggable.getVersion().equalsIgnoreCase(this.newVersion)) {
                            this.update = true;
                        }
                        break block18;
                    }
                    if (this.inSource && this.pluggable == null) {
                        this.source = new String(cArray, n, n2);
                        if (this.local) {
                            File file = new File(this.source);
                            if (file != null && file.exists()) {
                                for (File file2 : file.listFiles()) {
                                    PlugEngine.addFileToClasspath(file2);
                                }
                            }
                        } else {
                            Random random = new Random();
                            if (this.folder == null) {
                                this.folder = random.nextInt(1000000000) + "";
                            }
                            this.source = PlugEngine.this.downloadFile(this.client, this.source, this.folder);
                            PlugEngine.addFileToClasspath(this.source);
                        }
                        break block18;
                    }
                    if (!this.inClass || this.pluggable != null) break block18;
                    String string = new String(cArray, n, n2);
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(string);
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)"could not load plugin!");
                        LOGGER.warn((Object)("> " + string));
                        return;
                    }
                    try {
                        this.pluggable = (Pluggable)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)"could not instantiate plugin!");
                        LOGGER.warn((Object)("> " + string));
                        return;
                    }
                    if (this.local) {
                        PlugEngine.this.plugins.add(this.pluggable);
                        PlugEngine.this.hiddens.put(this.pluggable, this.hidden);
                        PlugEngine.this.updateEnable.put(this.pluggable, this.updateEnabled);
                        PlugEngine.this.enabled.put(this.pluggable, this.enable && PlugEngine.this.isCompatible(this.pluggable));
                        String string2 = this.source;
                        if (!SystemUtils.FILE_SEPARATOR.equals("/")) {
                            while (string2.contains("/")) {
                                string2 = string2.replace("/", SystemUtils.FILE_SEPARATOR);
                            }
                        }
                        PlugEngine.this.localSources.put(this.pluggable.getClass(), string2);
                    } else {
                        String string3 = PlugEngine.DIR + File.separator + this.folder;
                        PlugEngine.this.localSources.put(this.pluggable.getClass(), string3);
                        PlugEngine.this.addPluggable(this.pluggable);
                    }
                    this.folder = null;
                }
                catch (Exception exception) {
                    LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
                    throw new SAXException(exception);
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equalsIgnoreCase("version")) {
                this.inVersion = false;
            }
            if (string3.equalsIgnoreCase("class")) {
                this.inClass = false;
            }
            if (string3.equalsIgnoreCase("plugin")) {
                this.inPlugin = false;
                if (this.local) {
                    this.pluggable = null;
                }
            }
            if (string3.equalsIgnoreCase("source")) {
                this.inSource = false;
            }
        }

        public boolean isUpdate() {
            return this.update;
        }

        public Pluggable getPluggable() {
            return this.pluggable;
        }
    }
}

