/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils.engine.ui.swing;

import com.openindex.openestate.tool.utils.engine.PlugEngine;
import com.openindex.openestate.tool.utils.engine.Pluggable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.TransferHandler;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

public class PluginsTransferHandler
extends TransferHandler {
    private static final Logger LOGGER = Logger.getLogger(PluginsTransferHandler.class);
    private final JDialog dialog;
    private final HttpClient client;

    public PluginsTransferHandler(JDialog jDialog, HttpClient httpClient) {
        this.dialog = jDialog;
        this.client = httpClient;
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(DataFlavor.javaFileListFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            try {
                if (!dataFlavorArray[i].equals(DataFlavor.javaFileListFlavor)) continue;
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : list) {
                    if (!file.getName().toLowerCase().endsWith("xml")) continue;
                    Pluggable pluggable = PlugEngine.getInstance().installOrUpdate(this.client, file.toURI());
                    PlugEngine.getInstance().startPluggable(pluggable);
                }
                if (this.dialog != null) {
                    this.dialog.repaint();
                }
                return true;
            }
            catch (Exception exception) {
                LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        return false;
    }
}

