/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils.engine.ui.swing.applestyle;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.engine.PlugEngine;
import com.openindex.openestate.tool.utils.engine.PlugEngineException;
import com.openindex.openestate.tool.utils.engine.Pluggable;
import com.openindex.openestate.tool.utils.engine.ui.swing.Messages;
import com.openindex.openestate.tool.utils.engine.ui.swing.PluginsTransferHandler;
import com.openindex.openestate.tool.utils.engine.ui.swing.applestyle.PluginCellRenderer;
import com.openindex.openestate.tool.utils.engine.ui.swing.applestyle.UpdateDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXPanel;

public class PluginDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(PluginDialog.class);
    private DefaultListModel model;
    private JList list;
    private HttpClient client;

    public PluginDialog(Frame frame, boolean bl, HttpClient httpClient) {
        super(frame, bl);
        this.client = httpClient;
        this.build();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public PluginDialog(Dialog dialog, boolean bl, HttpClient httpClient) {
        super(dialog, bl);
        this.client = httpClient;
        this.build();
        this.pack();
        this.setLocationRelativeTo(dialog);
    }

    private void build() {
        this.setName("PluginDialog");
        this.setDefaultCloseOperation(2);
        this.model = new DefaultListModel();
        this.fillModel();
        this.list = new JList(this.model);
        this.list.setCellRenderer(new PluginCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.getViewport().setBackground(Color.WHITE);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setPreferredSize(new Dimension(170, 280));
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        JPanel jPanel = new JPanel(true){

            @Override
            protected void paintComponent(Graphics graphics) {
                graphics.setColor(new Color(243, 243, 243));
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight() / 2);
                graphics.setColor(new Color(230, 230, 230));
                graphics.fillRect(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
            }
        };
        jPanel.setLayout(new FlowLayout(3, 0, 0));
        jPanel.setOpaque(true);
        jPanel.setPreferredSize(new Dimension(170, 20));
        jPanel.setBorder(new MatteBorder(1, 0, 0, 0, new Color(176, 176, 176)));
        JButton jButton = new JButton();
        jButton.setName("PluginDialog_addButton");
        jButton.setOpaque(false);
        jButton.setPreferredSize(new Dimension(20, 20));
        jButton.setBorder(new MatteBorder(0, 0, 0, 1, new Color(176, 176, 176)));
        jButton.setContentAreaFilled(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return Messages.getString("message.xmlFiles");
                    }

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml");
                    }
                });
                int n = jFileChooser.showOpenDialog(PluginDialog.this);
                if (n == 0) {
                    try {
                        Pluggable pluggable = PlugEngine.getInstance().installOrUpdate(PluginDialog.this.client, jFileChooser.getSelectedFile().toURI());
                        PlugEngine.getInstance().startPluggable(pluggable);
                        PluginDialog.this.fillModel();
                        PluginDialog.this.list.setModel(PluginDialog.this.model);
                    }
                    catch (PlugEngineException plugEngineException) {
                        LOGGER.error((Object)plugEngineException.getLocalizedMessage(), (Throwable)plugEngineException);
                        ImmoToolUtils.showMessageErrorDialog(Messages.getMap().getString("error.installError", new Object[]{jFileChooser.getSelectedFile().getName()}), plugEngineException);
                    }
                }
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton();
        jButton2.setName("PluginDialog_removeButton");
        jButton2.setOpaque(false);
        jButton2.setPreferredSize(new Dimension(20, 20));
        jButton2.setBorder(new MatteBorder(0, 0, 0, 1, new Color(176, 176, 176)));
        jButton2.setContentAreaFilled(false);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PluginDialog.this.list.getSelectedValue() != null) {
                    Pluggable pluggable = (Pluggable)PluginDialog.this.list.getSelectedValue();
                    boolean bl = ImmoToolUtils.showQuestionDialog(Messages.getMap().getString("question.deletePlugin", new Object[]{pluggable.getName()}));
                    if (!bl) {
                        return;
                    }
                    try {
                        PlugEngine.getInstance().removePluggable(pluggable);
                        PluginDialog.this.fillModel();
                        PluginDialog.this.list.setModel(PluginDialog.this.model);
                    }
                    catch (PlugEngineException plugEngineException) {
                        LOGGER.error((Object)plugEngineException.getLocalizedMessage(), (Throwable)plugEngineException);
                        ImmoToolUtils.showMessageErrorDialog(Messages.getMap().getString("error.uninstallError", new Object[]{pluggable.getName()}), plugEngineException);
                    }
                }
            }
        });
        jPanel.add(jButton2);
        final PluginDialog pluginDialog = this;
        JButton jButton3 = new JButton();
        jButton3.setName("PluginDialog_refreshButton");
        jButton3.setOpaque(false);
        jButton3.setPreferredSize(new Dimension(20, 20));
        jButton3.setBorder(new MatteBorder(0, 0, 0, 1, new Color(176, 176, 176)));
        jButton3.setContentAreaFilled(false);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    UpdateDialog updateDialog = new UpdateDialog((Dialog)pluginDialog, PluginDialog.this.client);
                    if (updateDialog.list.getModel().getSize() > 0) {
                        updateDialog.setVisible(true);
                    } else {
                        updateDialog.dispose();
                        ImmoToolUtils.showMessageInfoDialog(Messages.getString("message.noUpdatesFounds"));
                    }
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"Can't load updates!");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    ImmoToolUtils.showMessageErrorDialog("Can't load updates!", exception);
                }
            }
        });
        jPanel.add(jButton3);
        JPanel jPanel2 = new JPanel(new BorderLayout(), true);
        jPanel2.setPreferredSize(new Dimension(300, 300));
        jPanel2.setOpaque(true);
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setBorder(new LineBorder(new Color(176, 176, 176)));
        final JButton jButton4 = new JButton();
        jButton4.setName("PluginDialog_optionButton");
        jButton4.setOpaque(false);
        jButton4.setEnabled(false);
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Pluggable pluggable;
                if (PluginDialog.this.list.getSelectedValue() != null && (pluggable = (Pluggable)PluginDialog.this.list.getSelectedValue()).hasOptions() && PlugEngine.getInstance().isEnabled(pluggable)) {
                    pluggable.openOptions();
                }
            }
        });
        final JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setName("PluginDialog_updateBox");
        jCheckBox.setOpaque(false);
        jCheckBox.setEnabled(false);
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    if (PluginDialog.this.list.getSelectedValue() != null) {
                        Pluggable pluggable = (Pluggable)PluginDialog.this.list.getSelectedValue();
                        PlugEngine.getInstance().setUpdateEnabled(pluggable, itemEvent.getStateChange() == 1);
                    }
                }
                catch (PlugEngineException plugEngineException) {
                    LOGGER.error((Object)plugEngineException.getLocalizedMessage(), (Throwable)plugEngineException);
                }
            }
        });
        final JCheckBox jCheckBox2 = new JCheckBox();
        jCheckBox2.setName("PluginDialog_enableBox");
        jCheckBox2.setOpaque(false);
        jCheckBox2.setEnabled(false);
        jCheckBox2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    if (PluginDialog.this.list.getSelectedValue() != null) {
                        Pluggable pluggable = (Pluggable)PluginDialog.this.list.getSelectedValue();
                        PlugEngine.getInstance().setEnabled(pluggable, itemEvent.getStateChange() == 1);
                        jButton4.setEnabled(itemEvent.getStateChange() == 1);
                        PluginDialog.this.list.repaint();
                    }
                }
                catch (PlugEngineException plugEngineException) {
                    LOGGER.error((Object)plugEngineException.getLocalizedMessage(), (Throwable)plugEngineException);
                }
            }
        });
        final JLabel jLabel = new JLabel("");
        jLabel.setName("PluginDialog_versionLabel");
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setBorder(new EmptyBorder(6, 6, 0, 6));
        jPanel2.add((Component)jLabel, "North");
        JPanel jPanel3 = new JPanel(true);
        jPanel3.setLayout(new BoxLayout(jPanel3, 2));
        jPanel3.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel3.setOpaque(false);
        jPanel3.add(jCheckBox);
        jPanel3.add(jCheckBox2);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(jButton4);
        jPanel2.add((Component)jPanel3, "South");
        final JTextArea jTextArea = new JTextArea(""){

            @Override
            protected void paintComponent(Graphics graphics) {
                Image image = Messages.getMap().getImageIcon("PluginDialog_icon").getImage();
                graphics.drawImage(image, this.getWidth() / 2 - image.getWidth(null) / 2, this.getHeight() / 2 - image.getHeight(null) / 2, null);
                super.paintComponent(graphics);
            }
        };
        jTextArea.setName("PluginDialog_descriptionField");
        jTextArea.setFont(jLabel.getFont().deriveFont(0));
        jTextArea.setBorder(new EmptyBorder(6, 6, 6, 6));
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jPanel2.add((Component)jTextArea, "Center");
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (PluginDialog.this.list.getSelectedValue() != null) {
                    Pluggable pluggable = (Pluggable)PluginDialog.this.list.getSelectedValue();
                    jTextArea.setText(pluggable.getDescription() == null ? "" : pluggable.getDescription());
                    if (!PlugEngine.getInstance().isCompatible(pluggable)) {
                        jTextArea.setText(Messages.getString("error.versionConflict"));
                    }
                    jButton4.setEnabled(pluggable.hasOptions() && PlugEngine.getInstance().isEnabled(pluggable));
                    jCheckBox.setEnabled(true);
                    jCheckBox.setSelected(PlugEngine.getInstance().isUpdateEnabled(pluggable));
                    jCheckBox2.setEnabled(PlugEngine.getInstance().isCompatible(pluggable));
                    jCheckBox2.setSelected(PlugEngine.getInstance().isEnabled(pluggable));
                    jLabel.setText(pluggable.getVersion() == null ? "" : pluggable.getVersion());
                } else {
                    jCheckBox.setEnabled(false);
                    jButton4.setEnabled(false);
                    jCheckBox2.setEnabled(false);
                    jTextArea.setText("");
                    jLabel.setText("");
                }
            }
        });
        JPanel jPanel4 = new JPanel(new BorderLayout(), true);
        jPanel4.setOpaque(true);
        jPanel4.add((Component)jScrollPane, "Center");
        jPanel4.add((Component)jPanel, "South");
        jPanel4.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 0, 10), new LineBorder(new Color(176, 176, 176))));
        JXPanel jXPanel = new JXPanel((LayoutManager)new BorderLayout(), true);
        jXPanel.setBorder((Border)new EmptyBorder(10, 10, 10, 10));
        jXPanel.add((Component)jPanel4, (Object)"West");
        jXPanel.add((Component)jPanel2, (Object)"Center");
        jXPanel.setTransferHandler((TransferHandler)new PluginsTransferHandler(this, this.client));
        this.list.setTransferHandler(new PluginsTransferHandler(this, this.client));
        jPanel4.setTransferHandler(new PluginsTransferHandler(this, this.client));
        jPanel2.setTransferHandler(new PluginsTransferHandler(this, this.client));
        jTextArea.setTransferHandler(new PluginsTransferHandler(this, this.client));
        this.getContentPane().add((Component)jXPanel);
        this.pack();
        Messages.getMap().injectComponents((Component)this);
        PlugEngine.getInstance().setDownloadMonitor(new DownloadMonitor());
        ImmoToolUtils.configureDialog(this, jXPanel);
    }

    private void fillModel() {
        this.model.removeAllElements();
        List<Pluggable> list = PlugEngine.getInstance().getAllVisiblePluggables();
        for (Pluggable pluggable : list) {
            this.model.addElement(pluggable);
        }
    }

    @Override
    public void repaint() {
        super.repaint();
        this.fillModel();
        this.list.setModel(this.model);
    }

    protected static class DownloadMonitor
    implements com.openindex.openestate.tool.utils.engine.DownloadMonitor {
        protected DownloadMonitor() {
        }

        @Override
        public InputStream downloadStart(InputStream inputStream) {
            ProgressMonitorInputStream progressMonitorInputStream = new ProgressMonitorInputStream(null, Messages.getString("message.doInstallation"), inputStream);
            return progressMonitorInputStream;
        }
    }
}

