/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils.engine.ui.swing.applestyle;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.engine.PlugEngine;
import com.openindex.openestate.tool.utils.engine.PlugEngineException;
import com.openindex.openestate.tool.utils.engine.Pluggable;
import com.openindex.openestate.tool.utils.engine.ui.swing.Messages;
import com.openindex.openestate.tool.utils.engine.ui.swing.applestyle.UpdateCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXPanel;
import org.xml.sax.SAXException;

public class UpdateDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(UpdateDialog.class);
    private final HttpClient client;
    protected JList list;

    public UpdateDialog(Frame frame, HttpClient httpClient) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        super(frame, true);
        this.client = httpClient;
        this.build();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public UpdateDialog(Dialog dialog, HttpClient httpClient) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        super(dialog, true);
        this.client = httpClient;
        this.build();
        this.pack();
        this.setLocationRelativeTo(dialog);
    }

    private void build() throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        this.setName("UpdateDialog");
        this.setDefaultCloseOperation(2);
        DefaultListModel<Pluggable> defaultListModel = new DefaultListModel<Pluggable>();
        List<Pluggable> list = PlugEngine.getInstance().checkForUpdates(this.client);
        for (Pluggable object2 : list) {
            defaultListModel.addElement(object2);
        }
        this.list = new JList(defaultListModel);
        this.list.setCellRenderer(new UpdateCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.getViewport().setBackground(Color.WHITE);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setPreferredSize(new Dimension(170, 280));
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        JPanel jPanel = new JPanel(new BorderLayout(), true);
        jPanel.setPreferredSize(new Dimension(300, 300));
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(new LineBorder(new Color(176, 176, 176)));
        final JLabel jLabel = new JLabel("");
        jLabel.setName("UpdateDialog_versionLabel");
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setBorder(new EmptyBorder(6, 6, 0, 6));
        jPanel.add((Component)jLabel, "North");
        final JTextArea jTextArea = new JTextArea(""){

            @Override
            protected void paintComponent(Graphics graphics) {
                Image image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/plugin.jpg"));
                graphics.drawImage(image, this.getWidth() / 2 - image.getWidth(null) / 2, this.getHeight() / 2 - image.getHeight(null) / 2, null);
                super.paintComponent(graphics);
            }
        };
        jTextArea.setName("UpdateDialog_descriptionField");
        jTextArea.setFont(jLabel.getFont().deriveFont(0));
        jTextArea.setBorder(new EmptyBorder(6, 6, 6, 6));
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jPanel.add((Component)jTextArea, "Center");
        final JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setName("UpdateDialog_checkBox");
        jCheckBox.setEnabled(false);
        jCheckBox.setOpaque(false);
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    Pluggable pluggable = (Pluggable)UpdateDialog.this.list.getSelectedValue();
                    PlugEngine.getInstance().setUpdateEnabled(pluggable, itemEvent.getStateChange() == 1);
                }
                catch (PlugEngineException plugEngineException) {
                    LOGGER.error((Object)plugEngineException.getLocalizedMessage(), (Throwable)plugEngineException);
                }
            }
        });
        jPanel.add((Component)jCheckBox, "South");
        JPanel jPanel2 = new JPanel(new BorderLayout(), true);
        jPanel2.setOpaque(false);
        jPanel2.setBorder(new EmptyBorder(10, 10, 0, 0));
        final JButton jButton = new JButton();
        jButton.setName("UpdateDialog_updateButton");
        jButton.setOpaque(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jButton.setEnabled(false);
                jButton.setText(Messages.getString("message.doUpdate"));
                for (Pluggable pluggable : PlugEngine.getInstance().getAllUpdatablePluggables()) {
                    try {
                        PlugEngine.getInstance().installOrUpdate(UpdateDialog.this.client, pluggable.getURI());
                    }
                    catch (PlugEngineException plugEngineException) {
                        LOGGER.error((Object)plugEngineException.getLocalizedMessage(), (Throwable)plugEngineException);
                        ImmoToolUtils.showMessageErrorDialog(Messages.getMap().getString("error.updateError", new Object[]{pluggable.getName()}), plugEngineException);
                    }
                }
                UpdateDialog.this.dispose();
            }
        });
        jPanel2.add((Component)jButton, "East");
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (UpdateDialog.this.list.getSelectedValue() != null) {
                    Pluggable pluggable = (Pluggable)UpdateDialog.this.list.getSelectedValue();
                    jLabel.setText(pluggable.getVersion() == null ? "" : pluggable.getVersion());
                    jTextArea.setText(pluggable.getDescription() == null ? "" : pluggable.getDescription());
                    jCheckBox.setEnabled(true);
                    jCheckBox.setSelected(PlugEngine.getInstance().isUpdateEnabled(pluggable));
                } else {
                    jLabel.setText("");
                    jTextArea.setText("");
                    jCheckBox.setEnabled(false);
                }
            }
        });
        JPanel jPanel3 = new JPanel(new BorderLayout(), true);
        jPanel3.setOpaque(true);
        jPanel3.add((Component)jScrollPane, "Center");
        jPanel3.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 0, 10), new LineBorder(new Color(176, 176, 176))));
        JXPanel jXPanel = new JXPanel((LayoutManager)new BorderLayout(), true);
        jXPanel.setBorder((Border)new EmptyBorder(10, 10, 10, 10));
        jXPanel.add((Component)jPanel3, (Object)"West");
        jXPanel.add((Component)jPanel, (Object)"Center");
        jXPanel.add((Component)jPanel2, (Object)"South");
        this.getContentPane().add((Component)jXPanel);
        this.pack();
        Messages.getMap().injectComponents((Component)this);
        PlugEngine.getInstance().setDownloadMonitor(new DownloadMonitor());
        ImmoToolUtils.configureDialog(this, jXPanel);
    }

    protected static class DownloadMonitor
    implements com.openindex.openestate.tool.utils.engine.DownloadMonitor {
        protected DownloadMonitor() {
        }

        @Override
        public InputStream downloadStart(InputStream inputStream) {
            ProgressMonitorInputStream progressMonitorInputStream = new ProgressMonitorInputStream(null, Messages.getString("message.doInstallation"), inputStream);
            return progressMonitorInputStream;
        }
    }
}

