/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils.engine.ui.swing.firefoxstyle;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.engine.PlugEngine;
import com.openindex.openestate.tool.utils.engine.PlugEngineException;
import com.openindex.openestate.tool.utils.engine.Pluggable;
import com.openindex.openestate.tool.utils.engine.ui.swing.Messages;
import com.openindex.openestate.tool.utils.engine.ui.swing.PluggableWrapper;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.EventObject;
import javax.accessibility.Accessible;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;

public class PluginCellRenderer
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor {
    private static final Logger LOGGER = Logger.getLogger(PluginCellRenderer.class);
    private PluggableWrapper plugin;

    @Override
    public Component getTableCellRendererComponent(final JTable jTable, Object object, final boolean bl, boolean bl2, final int n, int n2) {
        Accessible accessible;
        Accessible accessible2;
        if (object == null) {
            return new JLabel();
        }
        final Pluggable pluggable = ((PluggableWrapper)object).getPluggable();
        final int n3 = bl ? 150 : 55;
        JPanel jPanel = new JPanel(true){

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                Paint paint = Color.WHITE;
                if (bl) {
                    paint = new GradientPaint(0.0f, 0.0f, new Color(216, 225, 233), 0.0f, n3, new Color(179, 196, 213));
                }
                graphics2D.setPaint(paint);
                graphics2D.fillRect(0, 0, jTable.getWidth(), n3 - 1);
                graphics2D.setColor(new Color(127, 157, 185));
                float[] fArray = new float[]{1.0f};
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, fArray, 0.0f));
                graphics2D.drawLine(0, n3 - 1, jTable.getWidth(), n3 - 1);
                graphics2D.setStroke(new BasicStroke());
            }
        };
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout(5, 0));
        final JLabel jLabel = new JLabel();
        jLabel.setVerticalAlignment(1);
        jLabel.setPreferredSize(new Dimension(50, n3));
        if (pluggable.getIcon() != null) {
            accessible2 = new ImageIcon(PluginCellRenderer.getThumbnail(pluggable.getIcon(), 40));
            jLabel.setIcon((Icon)((Object)accessible2));
        }
        jPanel.add((Component)jLabel, "West");
        accessible2 = new JPanel(new BorderLayout(3, 3), true);
        ((JComponent)((Object)accessible2)).setOpaque(false);
        jPanel.add((Component)((Object)accessible2), "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(), true);
        jPanel2.setOpaque(false);
        final JLabel jLabel2 = new JLabel(pluggable.getName());
        jLabel2.setFont(jLabel2.getFont().deriveFont(1));
        final JLabel jLabel3 = new JLabel(pluggable.getVersion() == null ? "" : pluggable.getVersion());
        jLabel3.setFont(jLabel2.getFont().deriveFont(0));
        jLabel3.setForeground(Color.GRAY);
        jPanel2.add((Component)jLabel2, "West");
        jPanel2.add((Component)jLabel3, "East");
        ((Container)((Object)accessible2)).add(jPanel2, "North");
        final JTextArea jTextArea = new JTextArea(pluggable.getDescription() == null ? "" : pluggable.getDescription());
        if (!PlugEngine.getInstance().isCompatible(pluggable)) {
            jTextArea.setText(Messages.getString("error.versionConflict"));
        }
        jTextArea.setName("PluginCellRenderer_descriptionField");
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setFont(jLabel2.getFont().deriveFont(0));
        ((Container)((Object)accessible2)).add(jTextArea, "Center");
        if (!PlugEngine.getInstance().isEnabled(pluggable)) {
            jLabel2.setForeground(Color.GRAY);
            jLabel3.setForeground(Color.LIGHT_GRAY);
            jTextArea.setForeground(Color.GRAY);
            if (pluggable.getIcon() != null) {
                accessible = new ImageIcon(GrayFilter.createDisabledImage(PluginCellRenderer.getThumbnail(pluggable.getIcon(), 40)));
                jLabel.setIcon((Icon)((Object)accessible));
            }
        }
        if (bl) {
            accessible = new JPanel(true);
            ((Container)((Object)accessible)).setLayout(new BoxLayout((Container)((Object)accessible), 2));
            ((JComponent)((Object)accessible)).setOpaque(false);
            final JButton jButton = new JButton();
            jButton.setName("PluginCellRenderer_optionButton");
            jButton.setOpaque(false);
            if (pluggable.hasOptions() && PlugEngine.getInstance().isEnabled(pluggable)) {
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        pluggable.openOptions();
                    }
                });
            } else {
                jButton.setEnabled(false);
            }
            JButton jButton2 = new JButton();
            jButton2.setName("PluginCellRenderer_uninstallButton");
            jButton2.setOpaque(false);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ImmoToolUtils.showQuestionDialog(Messages.getMap().getString("question.deletePlugin", new Object[]{pluggable.getName()}));
                    if (!bl) {
                        return;
                    }
                    try {
                        PlugEngine.getInstance().removePluggable(pluggable);
                        DefaultTableModel defaultTableModel = (DefaultTableModel)jTable.getModel();
                        defaultTableModel.removeRow(n);
                        jTable.setModel(new DefaultTableModel());
                        jTable.setModel(defaultTableModel);
                    }
                    catch (PlugEngineException plugEngineException) {
                        LOGGER.error((Object)plugEngineException.getLocalizedMessage(), (Throwable)plugEngineException);
                        ImmoToolUtils.showMessageErrorDialog(Messages.getMap().getString("error.uninstallError", new Object[]{pluggable.getName()}), plugEngineException);
                    }
                }
            });
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setName("PluginCellRenderer_updateBox");
            jCheckBox.setSelected(PlugEngine.getInstance().isUpdateEnabled(pluggable));
            jCheckBox.setOpaque(false);
            jCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    try {
                        boolean bl = itemEvent.getStateChange() == 1;
                        PlugEngine.getInstance().setUpdateEnabled(pluggable, bl);
                    }
                    catch (PlugEngineException plugEngineException) {
                        LOGGER.error((Object)plugEngineException.getLocalizedMessage(), (Throwable)plugEngineException);
                    }
                }
            });
            jCheckBox.setHorizontalAlignment(4);
            JCheckBox jCheckBox2 = new JCheckBox();
            jCheckBox2.setName("PluginCellRenderer_enabledBox");
            jCheckBox2.setSelected(PlugEngine.getInstance().isEnabled(pluggable));
            jCheckBox2.setOpaque(false);
            jCheckBox2.setEnabled(PlugEngine.getInstance().isCompatible(pluggable));
            jCheckBox2.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    try {
                        boolean bl = itemEvent.getStateChange() == 1;
                        PlugEngine.getInstance().setEnabled(pluggable, bl);
                        jButton.setEnabled(bl);
                        jLabel2.setForeground(bl ? Color.BLACK : Color.GRAY);
                        jLabel3.setForeground(bl ? Color.GRAY : Color.LIGHT_GRAY);
                        jTextArea.setForeground(bl ? Color.BLACK : Color.GRAY);
                        ImageIcon imageIcon = null;
                        imageIcon = bl ? new ImageIcon(PluginCellRenderer.getThumbnail(pluggable.getIcon(), 40)) : new ImageIcon(GrayFilter.createDisabledImage(PluginCellRenderer.getThumbnail(pluggable.getIcon(), 40)));
                        jLabel.setIcon(imageIcon);
                    }
                    catch (PlugEngineException plugEngineException) {
                        LOGGER.error((Object)plugEngineException.getLocalizedMessage(), (Throwable)plugEngineException);
                    }
                }
            });
            ((Container)((Object)accessible)).add(jButton);
            ((Container)((Object)accessible)).add(Box.createHorizontalGlue());
            ((Container)((Object)accessible)).add(jCheckBox);
            ((Container)((Object)accessible)).add(jCheckBox2);
            ((Container)((Object)accessible)).add(jButton2);
            ((Container)((Object)accessible2)).add((Component)((Object)accessible), "South");
        }
        if (jTable.getRowHeight(n) != n3) {
            jTable.setRowHeight(n, n3);
        }
        jPanel.setPreferredSize(new Dimension(50, n3));
        Messages.getMap().injectComponents((Component)jPanel);
        return jPanel;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.plugin = (PluggableWrapper)object;
        return this.getTableCellRendererComponent(jTable, object, bl, bl, n, n2);
    }

    @Override
    public Object getCellEditorValue() {
        return this.plugin;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    protected static BufferedImage getThumbnail(BufferedImage bufferedImage, int n) {
        int n2;
        int n3 = bufferedImage.getWidth();
        if (n3 > (n2 = bufferedImage.getHeight())) {
            float f = (float)n3 / (float)n2;
            n3 = n;
            n2 = (int)((float)n / f);
        } else {
            float f = (float)n2 / (float)n3;
            n2 = n;
            n3 = (int)((float)n / f);
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage2 = graphicsConfiguration.createCompatibleImage(n3, n2, bufferedImage.getTransparency());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(bufferedImage, 0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), null);
        graphics2D.dispose();
        return bufferedImage2;
    }
}

