/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils.engine.ui.swing.firefoxstyle;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.engine.PlugEngine;
import com.openindex.openestate.tool.utils.engine.PlugEngineException;
import com.openindex.openestate.tool.utils.engine.Pluggable;
import com.openindex.openestate.tool.utils.engine.ui.swing.Messages;
import com.openindex.openestate.tool.utils.engine.ui.swing.PluggableWrapper;
import com.openindex.openestate.tool.utils.engine.ui.swing.PluginsTransferHandler;
import com.openindex.openestate.tool.utils.engine.ui.swing.firefoxstyle.PluginCellRenderer;
import com.openindex.openestate.tool.utils.engine.ui.swing.firefoxstyle.UpdateDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.TransferHandler;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang.SystemUtils;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledSeparator;

public class PluginDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(PluginDialog.class);
    private DefaultTableModel model;
    private JTable table;
    private HttpClient client;

    public PluginDialog(Frame frame, boolean bl, HttpClient httpClient) {
        super(frame, bl);
        this.client = httpClient;
        this.model = null;
        this.table = null;
        this.build();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public PluginDialog(Dialog dialog, boolean bl, HttpClient httpClient) {
        super(dialog, bl);
        this.client = httpClient;
        this.model = null;
        this.table = null;
        this.build();
        this.pack();
        this.setLocationRelativeTo(dialog);
    }

    private void build() {
        this.setName("PluginDialog");
        this.setDefaultCloseOperation(2);
        this.model = new DefaultTableModel(){

            @Override
            public Class<?> getColumnClass(int n) {
                return PluggableWrapper.class;
            }
        };
        this.fillModel();
        this.table = new JTable(this.model){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                this.selectRow(n);
                return super.editCellAt(n, n2, eventObject);
            }

            public void selectRow(int n) {
                this.selectionModel.setSelectionInterval(n, n);
            }
        };
        this.table.setTableHeader(null);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setDefaultRenderer(PluggableWrapper.class, new PluginCellRenderer());
        this.table.setDefaultEditor(PluggableWrapper.class, new PluginCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setBackground(Color.WHITE);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(600, 350));
        jScrollPane.setBorder(new CompoundBorder(new EmptyBorder(10, 10, 10, 10), new LineBorder(new Color(127, 157, 185))));
        JPanel jPanel = new JPanel(new BorderLayout(), true);
        jPanel.setOpaque(false);
        jPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        JButton jButton = new JButton();
        jButton.setName("PluginDialog_addButton");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return Messages.getString("message.xmlFiles");
                    }

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml");
                    }
                });
                int n = jFileChooser.showOpenDialog(PluginDialog.this);
                if (n == 0) {
                    try {
                        Pluggable pluggable = PlugEngine.getInstance().installOrUpdate(PluginDialog.this.client, jFileChooser.getSelectedFile().toURI());
                        PlugEngine.getInstance().startPluggable(pluggable);
                        PluginDialog.this.fillModel();
                        PluginDialog.this.table.setModel(PluginDialog.this.model);
                    }
                    catch (PlugEngineException plugEngineException) {
                        LOGGER.error((Object)plugEngineException.getLocalizedMessage(), (Throwable)plugEngineException);
                        ImmoToolUtils.showMessageErrorDialog(Messages.getMap().getString("error.installError", new Object[]{jFileChooser.getSelectedFile().getName()}), plugEngineException);
                    }
                }
            }
        });
        final PluginDialog pluginDialog = this;
        JButton jButton2 = new JButton();
        jButton2.setName("PluginDialog_updateButton");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    UpdateDialog updateDialog = new UpdateDialog((Dialog)pluginDialog, PluginDialog.this.client);
                    if (updateDialog.table.getModel().getRowCount() > 0) {
                        updateDialog.setVisible(true);
                    } else {
                        updateDialog.dispose();
                        ImmoToolUtils.showMessageInfoDialog(Messages.getString("message.noUpdatesFounds"));
                    }
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"Can't load updates!");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    ImmoToolUtils.showMessageErrorDialog("Can't load updates!", exception);
                }
            }
        });
        JButton jButton3 = new JButton();
        jButton3.setName("PluginDialog_helpButton");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImmoToolUtils.showHelpDialog("app.modules", true);
            }
        });
        JButton jButton4 = new JButton();
        jButton4.setName("PluginDialog_submitButton");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PluginDialog.this.setVisible(false);
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.setOpaque(false);
        jPanel2.add(jButton3);
        jPanel.add((Component)jPanel2, "West");
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel3.setOpaque(false);
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel3.add(jButton4);
        jPanel3.setOpaque(false);
        jPanel.add((Component)jPanel3, "East");
        JXTitledSeparator jXTitledSeparator = ImmoToolUtils.createHead1Separator("");
        jXTitledSeparator.setName("PluginDialog_titleLabel");
        jXTitledSeparator.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        JXPanel jXPanel = new JXPanel((LayoutManager)new BorderLayout(), true);
        jXPanel.add((Component)jXTitledSeparator, (Object)"North");
        jXPanel.add((Component)jScrollPane, (Object)"Center");
        jXPanel.add((Component)jPanel, (Object)"South");
        jXPanel.setTransferHandler((TransferHandler)new PluginsTransferHandler(this, this.client));
        this.table.setTransferHandler(new PluginsTransferHandler(this, this.client));
        jPanel.setTransferHandler(new PluginsTransferHandler(this, this.client));
        if (SystemUtils.IS_OS_MAC_OSX) {
            jButton.setOpaque(false);
            jButton2.setOpaque(false);
            jButton3.setOpaque(false);
            jButton4.setOpaque(false);
        }
        this.getContentPane().add((Component)jXPanel);
        this.pack();
        Messages.getMap().injectComponents((Component)this);
        PlugEngine.getInstance().setDownloadMonitor(new DownloadMonitor());
        ImmoToolUtils.configureDialog(this, jXPanel);
    }

    private void fillModel() {
        this.model.setRowCount(0);
        this.model.setColumnCount(0);
        List<Pluggable> list = PlugEngine.getInstance().getAllVisiblePluggables();
        Object[] objectArray = new PluggableWrapper[list.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            PluggableWrapper pluggableWrapper = new PluggableWrapper(list.get(i));
            objectArray[i] = pluggableWrapper;
        }
        this.model.addColumn((Object)"", objectArray);
    }

    @Override
    public void repaint() {
        this.fillModel();
        this.table.setModel(new DefaultTableModel());
        this.table.setModel(this.model);
        this.pack();
        super.repaint();
    }

    protected static class DownloadMonitor
    implements com.openindex.openestate.tool.utils.engine.DownloadMonitor {
        protected DownloadMonitor() {
        }

        @Override
        public InputStream downloadStart(InputStream inputStream) {
            ProgressMonitorInputStream progressMonitorInputStream = new ProgressMonitorInputStream(null, Messages.getString("message.doInstallation"), inputStream);
            return progressMonitorInputStream;
        }
    }
}

