/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils.engine.ui.swing.firefoxstyle;

import com.openindex.openestate.tool.utils.engine.PlugEngine;
import com.openindex.openestate.tool.utils.engine.PlugEngineException;
import com.openindex.openestate.tool.utils.engine.Pluggable;
import com.openindex.openestate.tool.utils.engine.ui.swing.Messages;
import com.openindex.openestate.tool.utils.engine.ui.swing.PluggableWrapper;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.EventObject;
import javax.accessibility.Accessible;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;

public class UpdateCellRenderer
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor {
    private static final Logger LOGGER = Logger.getLogger(UpdateCellRenderer.class);
    private PluggableWrapper wrapper;

    @Override
    public Component getTableCellRendererComponent(final JTable jTable, final Object object, final boolean bl, boolean bl2, int n, int n2) {
        Accessible accessible;
        final Pluggable pluggable = ((PluggableWrapper)object).getPluggable();
        final int n3 = bl ? 150 : 55;
        JPanel jPanel = new JPanel(true){

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                Paint paint = Color.WHITE;
                if (bl) {
                    paint = new GradientPaint(0.0f, 0.0f, new Color(216, 225, 233), 0.0f, n3, new Color(179, 196, 213));
                }
                graphics2D.setPaint(paint);
                graphics2D.fillRect(0, 0, jTable.getWidth(), n3 - 1);
                graphics2D.setColor(new Color(127, 157, 185));
                float[] fArray = new float[]{1.0f};
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, fArray, 0.0f));
                graphics2D.drawLine(0, n3 - 1, jTable.getWidth(), n3 - 1);
                graphics2D.setStroke(new BasicStroke());
            }
        };
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout(5, 0));
        JLabel jLabel = new JLabel();
        jLabel.setVerticalAlignment(1);
        jLabel.setPreferredSize(new Dimension(50, n3));
        if (pluggable.getIcon() != null) {
            accessible = new ImageIcon(UpdateCellRenderer.getThumbnail(pluggable.getIcon(), 40));
            jLabel.setIcon((Icon)((Object)accessible));
        }
        jPanel.add((Component)jLabel, "West");
        accessible = new JPanel(new BorderLayout(3, 3), true);
        ((JComponent)((Object)accessible)).setOpaque(false);
        jPanel.add((Component)((Object)accessible), "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(), true);
        jPanel2.setOpaque(false);
        JLabel jLabel2 = new JLabel(pluggable.getName());
        jLabel2.setFont(jLabel2.getFont().deriveFont(1));
        JLabel jLabel3 = new JLabel(pluggable.getVersion() == null ? "" : pluggable.getVersion());
        jLabel3.setFont(jLabel2.getFont().deriveFont(0));
        jLabel3.setForeground(Color.GRAY);
        jPanel2.add((Component)jLabel2, "West");
        jPanel2.add((Component)jLabel3, "East");
        ((Container)((Object)accessible)).add(jPanel2, "North");
        JTextArea jTextArea = new JTextArea(pluggable.getDescription() == null ? "" : pluggable.getDescription());
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setFont(jLabel2.getFont().deriveFont(0));
        ((Container)((Object)accessible)).add(jTextArea, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(), true);
        jPanel3.setOpaque(false);
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setName("UpdateCellRenderer_checkBox");
        jCheckBox.setEnabled(bl);
        jCheckBox.setMargin(new Insets(0, 5, 0, 0));
        jCheckBox.setSelected(((PluggableWrapper)object).isSelected());
        jCheckBox.setOpaque(false);
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ((PluggableWrapper)object).setSelected(itemEvent.getStateChange() == 1);
                try {
                    PlugEngine.getInstance().setUpdateEnabled(pluggable, itemEvent.getStateChange() == 1);
                }
                catch (PlugEngineException plugEngineException) {
                    LOGGER.error((Object)plugEngineException.getLocalizedMessage(), (Throwable)plugEngineException);
                }
            }
        });
        jPanel3.add((Component)jCheckBox, "North");
        jPanel.add((Component)jPanel3, "East");
        if (jTable.getRowHeight(n) != n3) {
            jTable.setRowHeight(n, n3);
        }
        jPanel.setPreferredSize(new Dimension(50, n3));
        Messages.getMap().injectComponents((Component)jPanel);
        return jPanel;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.wrapper = (PluggableWrapper)object;
        return this.getTableCellRendererComponent(jTable, object, bl, bl, n, n2);
    }

    @Override
    public Object getCellEditorValue() {
        return this.wrapper;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    protected static BufferedImage getThumbnail(BufferedImage bufferedImage, int n) {
        int n2;
        int n3 = bufferedImage.getWidth();
        if (n3 > (n2 = bufferedImage.getHeight())) {
            float f = (float)n3 / (float)n2;
            n3 = n;
            n2 = (int)((float)n / f);
        } else {
            float f = (float)n2 / (float)n3;
            n2 = n;
            n3 = (int)((float)n / f);
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage2 = graphicsConfiguration.createCompatibleImage(n3, n2, bufferedImage.getTransparency());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(bufferedImage, 0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), null);
        graphics2D.dispose();
        return bufferedImage2;
    }
}

