/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils.engine.ui.swing.firefoxstyle;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.engine.PlugEngine;
import com.openindex.openestate.tool.utils.engine.PlugEngineException;
import com.openindex.openestate.tool.utils.engine.Pluggable;
import com.openindex.openestate.tool.utils.engine.ui.swing.Messages;
import com.openindex.openestate.tool.utils.engine.ui.swing.PluggableWrapper;
import com.openindex.openestate.tool.utils.engine.ui.swing.firefoxstyle.UpdateCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.SystemUtils;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledSeparator;
import org.xml.sax.SAXException;

public class UpdateDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(UpdateDialog.class);
    protected JTable table;
    private HttpClient client;

    public UpdateDialog(Frame frame, HttpClient httpClient) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        super(frame, true);
        this.client = httpClient;
        this.build();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public UpdateDialog(Dialog dialog, HttpClient httpClient) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        super(dialog, true);
        this.client = httpClient;
        this.build();
        this.pack();
        this.setLocationRelativeTo(dialog);
    }

    private void build() throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        Object object;
        this.setName("UpdateDialog");
        this.setDefaultCloseOperation(2);
        DefaultTableModel defaultTableModel = new DefaultTableModel(){

            @Override
            public Class<?> getColumnClass(int n) {
                return PluggableWrapper.class;
            }
        };
        List<Pluggable> list = PlugEngine.getInstance().checkForUpdates(this.client);
        Object[] objectArray = new PluggableWrapper[list.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = object = new PluggableWrapper(list.get(i));
        }
        defaultTableModel.addColumn((Object)"", objectArray);
        this.table = new JTable(defaultTableModel){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                this.selectRow(n);
                return super.editCellAt(n, n2, eventObject);
            }

            public void selectRow(int n) {
                this.selectionModel.setSelectionInterval(n, n);
            }
        };
        this.table.setTableHeader(null);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setDefaultRenderer(PluggableWrapper.class, new UpdateCellRenderer());
        this.table.setDefaultEditor(PluggableWrapper.class, new UpdateCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setBackground(Color.WHITE);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(500, 300));
        jScrollPane.setBorder(new CompoundBorder(new EmptyBorder(10, 10, 10, 10), new LineBorder(new Color(127, 157, 185))));
        object = new JPanel(new FlowLayout(2), true);
        ((JComponent)object).setOpaque(false);
        ((JComponent)object).setBorder(new EmptyBorder(0, 10, 10, 10));
        final JButton jButton = new JButton();
        jButton.setName("UpdateDialog_updateButton");
        jButton.addActionListener(new ActionListener((PluggableWrapper[])objectArray){
            final /* synthetic */ PluggableWrapper[] val$wrappers;
            {
                this.val$wrappers = pluggableWrapperArray;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jButton.setEnabled(false);
                jButton.setText(Messages.getString("message.doUpdate"));
                for (PluggableWrapper pluggableWrapper : this.val$wrappers) {
                    if (!pluggableWrapper.isSelected()) continue;
                    try {
                        PlugEngine.getInstance().installOrUpdate(UpdateDialog.this.client, pluggableWrapper.getPluggable().getURI());
                    }
                    catch (PlugEngineException plugEngineException) {
                        LOGGER.error((Object)plugEngineException.getLocalizedMessage(), (Throwable)plugEngineException);
                        ImmoToolUtils.showMessageErrorDialog(Messages.getMap().getString("error.updateError", new Object[]{pluggableWrapper.getPluggable().getName()}), plugEngineException);
                    }
                }
                UpdateDialog.this.dispose();
            }
        });
        JButton jButton2 = new JButton();
        jButton2.setName("UpdateDialog_cancelButton");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateDialog.this.dispose();
            }
        });
        ((Container)object).add(jButton);
        ((Container)object).add(jButton2);
        JXTitledSeparator jXTitledSeparator = ImmoToolUtils.createHead1Separator("");
        jXTitledSeparator.setName("UpdateDialog_titleLabel");
        jXTitledSeparator.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        JXPanel jXPanel = new JXPanel((LayoutManager)new BorderLayout(), true);
        jXPanel.add((Component)jXTitledSeparator, (Object)"North");
        jXPanel.add((Component)jScrollPane, (Object)"Center");
        jXPanel.add((Component)object, (Object)"South");
        if (SystemUtils.IS_OS_MAC_OSX) {
            jButton.setOpaque(false);
            jButton2.setOpaque(false);
        }
        this.getContentPane().add((Component)jXPanel);
        this.pack();
        Messages.getMap().injectComponents((Component)this);
        PlugEngine.getInstance().setDownloadMonitor(new DownloadMonitor());
        ImmoToolUtils.configureDialog(this, jXPanel);
    }

    protected static class DownloadMonitor
    implements com.openindex.openestate.tool.utils.engine.DownloadMonitor {
        protected DownloadMonitor() {
        }

        @Override
        public InputStream downloadStart(InputStream inputStream) {
            ProgressMonitorInputStream progressMonitorInputStream = new ProgressMonitorInputStream(null, Messages.getString("message.doInstallation"), inputStream);
            return progressMonitorInputStream;
        }
    }
}

