/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils.tabs;

import com.openindex.openestate.tool.utils.tabs.CloseTabPaneUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class CloseTabPaneEclipseUI
extends CloseTabPaneUI {
    private static final Color whiteColor = Color.white;
    private static final Color transparent = new Color(0, 0, 0, 0);
    private static final Color lightBlue = new Color(130, 200, 250, 50);
    private static final Color lightWhite = new Color(200, 200, 200, 50);
    private static final Color selectedColor = new Color(15, 70, 180);

    public static ComponentUI createUI(JComponent jComponent) {
        return new CloseTabPaneEclipseUI();
    }

    @Override
    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        graphics.setColor(this.shadow);
        graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 1);
        graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
        graphics.drawLine(n3 + 2, n4, n3 + n5 - 3, n4);
        graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 1);
        graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
        if (bl) {
            graphics.setColor(this.lightHighlight);
            graphics.drawLine(n3 + 2, n4 + 2, n3 + 2, n4 + n6 - 1);
            graphics.drawLine(n3 + 3, n4 + 1, n3 + n5 - 3, n4 + 1);
            graphics.drawLine(n3 + n5 - 3, n4 + 2, n3 + n5 - 3, n4 + 2);
            graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 1);
        }
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.shadow);
        graphics.drawLine(n3, n4, n3 + n5 - 2, n4);
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.shadow);
        graphics.drawLine(n3, n4, n3, n4 + n6 - 3);
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.shadow);
        graphics.drawLine(n3 + 1, n4 + n6 - 3, n3 + n5 - 2, n4 + n6 - 3);
        graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
        graphics.setColor(this.shadow.brighter());
        graphics.drawLine(n3 + 2, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.shadow);
        graphics.drawLine(n3 + n5 - 3, n4 + 1, n3 + n5 - 3, n4 + n6 - 3);
        graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + n6 - 3);
        graphics.setColor(this.shadow.brighter());
        graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 2);
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (bl) {
            GradientPaint gradientPaint;
            GradientPaint gradientPaint2;
            int n7 = 10;
            int n8 = 8;
            if (this.isCloseEnabled()) {
                n7 += 23;
                n8 += 18;
            }
            if (this.isMaxEnabled()) {
                n7 += 23;
                n8 += 18;
            }
            if (this.tabPane.isEnabledAt(n2)) {
                gradientPaint2 = new GradientPaint(n3, n4, selectedColor, n3 + n5 / 2, n4, lightBlue);
                gradientPaint = new GradientPaint(n3 + n5 / 2, n4, lightBlue, n3 + n5 + n7, n4, transparent);
            } else {
                gradientPaint2 = new GradientPaint(n3, n4, this.shadow, n3 + n5 / 2, n4, lightWhite);
                gradientPaint = new GradientPaint(n3 + n5 / 2, n4, lightWhite, n3 + n5 + n7, n4, transparent);
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(gradientPaint2);
            graphics2D.fillRect(n3 + 2, n4 + 2, n5 / 2, n6 - 2);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(n3 + 2 + n5 / 2, n4 + 2, n5 / 2 - n8, n6 - 2);
        }
    }

    @Override
    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        graphics.setFont(font);
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            int n3 = this.tabPane.getDisplayedMnemonicIndexAt(n2);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n2)) {
                if (bl) {
                    graphics.setColor(whiteColor);
                } else {
                    graphics.setColor(this.tabPane.getForegroundAt(n2));
                }
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(this.tabPane.getBackgroundAt(n2).brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(this.tabPane.getBackgroundAt(n2).darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            }
        }
    }

    @Override
    protected CloseTabPaneUI.ScrollableTabButton createScrollableTabButton(int n) {
        return new ScrollableTabButton(n);
    }

    protected class ScrollableTabButton
    extends CloseTabPaneUI.ScrollableTabButton {
        public ScrollableTabButton(int n) {
            super(CloseTabPaneEclipseUI.this, n);
            this.setRolloverEnabled(true);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(16, CloseTabPaneEclipseUI.this.calculateMaxTabHeight(0));
        }

        @Override
        public void paint(Graphics graphics) {
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            Color color = graphics.getColor();
            boolean bl = this.getModel().isPressed();
            boolean bl2 = this.getModel().isRollover();
            boolean bl3 = this.isEnabled();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(CloseTabPaneEclipseUI.this.shadow);
            if (this.direction == 7) {
                graphics.drawLine(0, 0, 0, n2 - 1);
                graphics.drawLine(n - 1, 0, n - 1, 0);
            } else {
                graphics.drawLine(n - 2, n2 - 1, n - 2, 0);
            }
            graphics.drawLine(0, 0, n - 2, 0);
            if (bl2) {
                Color color2;
                Color color3;
                if (bl) {
                    color3 = whiteColor;
                    color2 = CloseTabPaneEclipseUI.this.shadow;
                } else {
                    color2 = whiteColor;
                    color3 = CloseTabPaneEclipseUI.this.shadow;
                }
                graphics.setColor(color2);
                if (this.direction == 7) {
                    graphics.drawLine(1, 1, 1, n2 - 1);
                    graphics.drawLine(1, 1, n - 2, 1);
                    graphics.setColor(color3);
                    graphics.drawLine(n - 1, n2 - 1, n - 1, 1);
                } else {
                    graphics.drawLine(0, 1, 0, n2 - 1);
                    graphics.drawLine(0, 1, n - 3, 1);
                    graphics.setColor(color3);
                    graphics.drawLine(n - 3, n2 - 1, n - 3, 1);
                }
            }
            if (n2 < 5 || n < 5) {
                graphics.setColor(color);
                return;
            }
            if (bl) {
                graphics.translate(1, 1);
            }
            int n3 = Math.min((n2 - 4) / 3, (n - 4) / 3);
            n3 = Math.max(n3, 2);
            this.paintTriangle(graphics, (n - n3) / 2, (n2 - n3) / 2, n3, this.direction, bl3);
            if (bl) {
                graphics.translate(-1, -1);
            }
            graphics.setColor(color);
        }
    }
}

