<?xml version="1.0" encoding="utf-8"?>
<!--

 $Author: doug $
 $Date: 2005/10/01 02:19:19 $
 $Header: /home/cvs/INET-Consulting/iCalendar/libINET-iCalSimple/test/toXML/xCal2iCal.xslt,v 1.2 2005/10/01 02:19:19 doug Exp $

Copyright (C) 2005 IntelliCal LLC, All Rights Reserved.
Written By: Doug@Royer.com

THIS SOURCE CODE BELONGS TO INTELLICAL LLC, CORPORATION, A MARYLAND
CORPORATION.  THIS CODE IS PROPERTY OF THE COPYRIGHT HOLDER.

ALL OF THIS CODE IS ORIGINAL WORK BY THE COPYRIGHT HOLDER.

THIS SOFTWARE AND MANUAL ARE BOTH PROTECTED BY UNITED STATES COPYRIGHT
LAW (TITLE 17 UNITED STATES CODE). UNAUTHORIZED REPRODUCTION AND/OR
SALE MAY RESULT IN IMPRISONMENT OF UP TO ONE YEAR AND FINES OF UP
TO $100,000 (17 USC 506). COPYRIGHT INFRINGERS MAY ALSO BE SUBJECT
TO CIVIL LIABILITY.
NOTICE:

REDISTRIBUTION AND USE IN SOURCE AND BINARY FORMS, WITH OR WITHOUT
MODIFICATION, ARE PERMITTED PROVIDED THAT THE FOLLOWING CONDITIONS
ARE MET:

1. REDISTRIBUTIONS OF SOURCE CODE MUST RETAIN THE ABOVE COPYRIGHT
   NOTICE, THIS LIST OF CONDITIONS AND THE FOLLOWING DISCLAIMER.

2. REDISTRIBUTIONS IN BINARY FORM MUST REPRODUCE THE ABOVE COPYRIGHT
   NOTICE, THIS LIST OF CONDITIONS AND THE FOLLOWING DISCLAIMER IN THE
   DOCUMENTATION AND/OR OTHER MATERIALS PROVIDED WITH THE DISTRIBUTION.

3. NEITHER THE NAME OF THE AUTHOR NOR THE NAMES OF THE CONTRIBUTORS
   MAY BE USED TO ENDORSE OR PROMOTE PRODUCTS DERIVED FROM THIS SOFTWARE
   WITHOUT SPECIFIC PRIOR WRITTEN PERMISSION.

THIS NOTICE AND THE ABOVE COPYRIGHT NOTICE MUST REMAIN IN ALL COPIES
AND ANY DERIVED WORK.

THIS DOCUMENT AND THE INFORMATION CONTAINED HEREIN IS PROVIDED ON
AN "AS IS" BASIS AND INTELLICAL LLC DISCLAIM ALL WARRANTIES, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO ANY WARRANTY THAT THE USE
OF THE INFORMATION HEREIN WILL NOT INFRINGE ANY RIGHTS OR ANY IMPLIED
WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
ANY SERVICE CONTRACT WILL BE UNDER A SEPARATE LICENSE.

 $Log: xCal2iCal.xslt,v $
 Revision 1.2  2005/10/01 02:19:19  doug

 Added code to convert xml:lang -> LANGUAGE

 Revision 1.1  2005/08/08 23:28:05  doug

 New to CVS


-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xCal="http://ietf.org/rfc/rfcXXXX.txt">
  <xsl:strip-space elements="*"/>
  <xsl:preserve-space elements="text"/>
  <xsl:output method="text" media-type="text/calendar" encoding="utf-8"/>
  <xsl:template match="/">
    <xsl:text>Content-Type:text/calendar; charset=utf-8&#x0D;&#x0A;&#x0D;&#x0A;</xsl:text>
    <xsl:apply-templates select="iCalendar"/>
  </xsl:template>
  <xsl:template match="xCal:vcalendar">
    <xsl:text>BEGIN:VCALENDAR&#x0D;&#x0A;</xsl:text>
    <xsl:for-each select="xCal:vevent">
      <xsl:text>BEGIN:VEVENT&#x0D;&#x0A;</xsl:text>
      <xsl:for-each select="xCal:valarm">
        <xsl:text>BEGIN:VALARM&#x0D;&#x0A;</xsl:text>
        <xsl:apply-templates select="xCal:*"/>
        <xsl:text>END:VALARM&#x0D;&#x0A;</xsl:text>
      </xsl:for-each>
      <xsl:apply-templates select="xCal:*"/>
      <xsl:text>END:VEVENT&#x0D;&#x0A;</xsl:text>
    </xsl:for-each>
    <xsl:for-each select="xCal:vtodo">
      <xsl:text>BEGIN:VTODO&#x0D;&#x0A;</xsl:text>
      <xsl:for-each select="xCal:valarm">
        <xsl:text>BEGIN:VALARM&#x0D;&#x0A;</xsl:text>
        <xsl:apply-templates select="xCal:*"/>
        <xsl:text>END:VALARM&#x0D;&#x0A;</xsl:text>
      </xsl:for-each>
      <xsl:apply-templates select="xCal:*"/>
      <xsl:text>END:VTODO&#x0D;&#x0A;</xsl:text>
    </xsl:for-each>
    <xsl:for-each select="xCal:vcard">
      <xsl:text>BEGIN:VCARD&#x0D;&#x0A;</xsl:text>
      <xsl:apply-templates select="xCal:*"/>
      <xsl:text>END:VCARD&#x0D;&#x0A;</xsl:text>
    </xsl:for-each>
    <xsl:for-each select="xCal:vjournal">
      <xsl:text>BEGIN:VJOURNAL&#x0D;&#x0A;</xsl:text>
      <xsl:for-each select="xCal:valarm">
        <xsl:text>BEGIN:VALARM&#x0D;&#x0A;</xsl:text>
        <xsl:apply-templates select="xCal:*"/>
        <xsl:text>END:VALARM&#x0D;&#x0A;</xsl:text>
      </xsl:for-each>
      <xsl:apply-templates select="xCal:*"/>
      <xsl:text>END:VJOURNAL&#x0D;&#x0A;</xsl:text>
    </xsl:for-each>
    <xsl:for-each select="xCal:vtimezone">
      <xsl:text>BEGIN:VTIMEZONE&#x0D;&#x0A;</xsl:text>
      <xsl:apply-templates select="xCal:tzid"/>
      <xsl:apply-templates select="xCal:x-lic-location"/>
      <xsl:for-each select="xCal:standard">
        <xsl:text>BEGIN:STANDARD&#x0D;&#x0A;</xsl:text>
        <xsl:apply-templates select="xCal:*"/>
        <xsl:text>END:STANDARD&#x0D;&#x0A;</xsl:text>
      </xsl:for-each>
      <xsl:for-each select="xCal:daylight">
        <xsl:text>BEGIN:DAYLIGHT&#x0D;&#x0A;</xsl:text>
        <xsl:apply-templates select="xCal:*"/>
        <xsl:text>END:DAYLIGHT&#x0D;&#x0A;</xsl:text>
      </xsl:for-each>
      <xsl:text>END:VTIMEZONE&#x0D;&#x0A;</xsl:text>
    </xsl:for-each>
    <!--<xsl:text>X-INTELLICAL-COMMENT;url="http://IntelliCal.com/xml/xCal2iCal.xslt":Generated by INTELLICAL-XSLT xCal to iCal converter V1.0&#x0D;&#x0A;</xsl:text>-->
    <xsl:text>END:VCALENDAR&#x0D;&#x0A;</xsl:text>
  </xsl:template>
  <xsl:template match="xCal:*">
    <xsl:choose>
      <xsl:when test="local-name()!='valarm'">
        <xsl:value-of select="translate(local-name(), 'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
        <xsl:for-each select="@xml:lang">
          <xsl:call-template name="convert-lang"/>
        </xsl:for-each>
        <xsl:variable name="LangName">lang</xsl:variable>
        <xsl:for-each select="@*">
          <xsl:variable name="ParamName" select="local-name()"/>
          <xsl:choose>
            <xsl:when test="$ParamName!=$LangName">;
              <xsl:value-of select="translate(local-name(), 'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>="
              <xsl:value-of select="."/>"
            </xsl:when>
          </xsl:choose>
        </xsl:for-each>:
        <xsl:call-template name="data-lf-wrap">
          <xsl:with-param name="sometext" select="."/>
        </xsl:call-template>
        <xsl:text>&#x0D;&#x0A;</xsl:text>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="data-lf-wrap">
    <xsl:param name="sometext"/>
    <xsl:variable name="lf">
      <xsl:text>
      </xsl:text>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="contains($sometext,$lf)">
        <xsl:value-of select="substring-before($sometext,$lf)"/>
        <xsl:text>&#x0D;&#x0A; </xsl:text>
        <xsl:call-template name="data-lf-wrap">
          <xsl:with-param name="sometext" select="substring-after($sometext,$lf)"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$sometext"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="convert-lang">
    <xsl:text>;LANGUAGE="</xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>"</xsl:text>
  </xsl:template>
</xsl:stylesheet>
