/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.util.Debug;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class JavaCondition
extends Condition {
    private static final long serialVersionUID = -7649870719815066537L;
    protected String classname;
    protected String methodname;
    protected String fieldname;
    protected boolean complete;
    protected String returnvalue;
    protected String returnvaluetype;
    protected Class usedclass;
    protected Field usedfield;
    protected Method usedmethod;

    public boolean isTrue() {
        if (!this.complete) {
            return false;
        }
        if (this.usedclass == null) {
            try {
                this.usedclass = Class.forName(this.classname);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.log("Can't find class " + this.classname);
                return false;
            }
        }
        if (this.usedfield == null && this.fieldname != null) {
            try {
                this.usedfield = this.usedclass.getField(this.fieldname);
            }
            catch (SecurityException securityException) {
                Debug.log("No permission to access specified field: " + this.fieldname);
                return false;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Debug.log("No such field: " + this.fieldname);
                return false;
            }
        }
        if (this.usedmethod == null && this.methodname != null) {
            Debug.log("not implemented yet.");
            return false;
        }
        if (this.usedfield != null) {
            if ("boolean".equals(this.returnvaluetype)) {
                try {
                    boolean bl = this.usedfield.getBoolean(null);
                    boolean bl2 = Boolean.valueOf(this.returnvalue);
                    return bl == bl2;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Debug.log("IllegalArgumentexeption " + this.fieldname);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Debug.log("IllegalAccessException " + this.fieldname);
                }
            } else {
                Debug.log("not implemented yet.");
                return false;
            }
        }
        return false;
    }

    public void readFromXML(IXMLElement iXMLElement) {
        IXMLElement iXMLElement2;
        if (iXMLElement.getChildrenCount() != 2) {
            Debug.log("Condition of type java needs (java,returnvalue)");
            return;
        }
        IXMLElement iXMLElement3 = iXMLElement.getFirstChildNamed("java");
        IXMLElement iXMLElement4 = iXMLElement3.getFirstChildNamed("class");
        if (iXMLElement4 == null) {
            Debug.log("Java-Element needs (class,method?,field?)");
            return;
        }
        this.classname = iXMLElement4.getContent();
        IXMLElement iXMLElement5 = iXMLElement3.getFirstChildNamed("method");
        if (iXMLElement5 != null) {
            this.methodname = iXMLElement5.getContent();
        }
        if ((iXMLElement2 = iXMLElement3.getFirstChildNamed("field")) != null) {
            this.fieldname = iXMLElement2.getContent();
        }
        if (this.methodname == null && this.fieldname == null) {
            Debug.log("java element needs (class, method?,field?)");
            return;
        }
        IXMLElement iXMLElement6 = iXMLElement.getFirstChildNamed("returnvalue");
        if (iXMLElement6 == null) {
            Debug.log("no returnvalue-element specified.");
            return;
        }
        this.returnvalue = iXMLElement6.getContent();
        this.returnvaluetype = iXMLElement6.getAttribute("type");
        this.complete = true;
    }

    public void makeXMLData(IXMLElement iXMLElement) {
        XMLElementImpl xMLElementImpl;
        XMLElementImpl xMLElementImpl2 = new XMLElementImpl("java", iXMLElement);
        iXMLElement.addChild(xMLElementImpl2);
        XMLElementImpl xMLElementImpl3 = new XMLElementImpl("class", xMLElementImpl2);
        xMLElementImpl3.setContent(this.classname);
        xMLElementImpl2.addChild(xMLElementImpl3);
        if (this.methodname != null) {
            xMLElementImpl = new XMLElementImpl("method", xMLElementImpl2);
            xMLElementImpl.setContent(this.methodname);
            xMLElementImpl2.addChild(xMLElementImpl);
        }
        if (this.fieldname != null) {
            xMLElementImpl = new XMLElementImpl("field", xMLElementImpl2);
            xMLElementImpl.setContent(this.fieldname);
            xMLElementImpl2.addChild(xMLElementImpl);
        }
        xMLElementImpl = new XMLElementImpl("returnvalue", xMLElementImpl2);
        xMLElementImpl.setContent(this.returnvalue);
        xMLElementImpl.setAttribute("type", this.returnvaluetype);
        xMLElementImpl2.addChild(xMLElementImpl);
    }

    public String getDependenciesDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.id);
        stringBuffer.append(" depends on the ");
        if (this.fieldname != null) {
            stringBuffer.append("value of field <b>");
            stringBuffer.append(this.fieldname);
            stringBuffer.append("</b>");
        } else {
            stringBuffer.append("return value of method <b>");
            stringBuffer.append(this.methodname);
            stringBuffer.append("</b>");
        }
        stringBuffer.append(" on an instance of class <b>");
        stringBuffer.append(this.classname);
        stringBuffer.append("</b> which should be <b>");
        stringBuffer.append(this.returnvalue);
        stringBuffer.append("</b><br/>");
        return stringBuffer.toString();
    }
}

