/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.atlanticbb.tantlinger.io.CopyMonitor;
import net.atlanticbb.tantlinger.io.FileCopyMonitor;

public class IOUtils {
    private static final int BUFFER_SIZE = 4096;
    private static final NullCopyMonitor nullMon = new NullCopyMonitor();

    private static void getDirectoryContents(List list, File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                IOUtils.getDirectoryContents(list, file2);
                continue;
            }
            if (!file2.isFile()) continue;
            list.add(file2);
        }
    }

    public static File[] getDirectoryContents(File file) {
        ArrayList arrayList = new ArrayList();
        IOUtils.getDirectoryContents(arrayList, file);
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public static String sanitize(String string) {
        return string.replaceAll("[^\\w\\.\\-\\:\\;\\#\\_]", "_");
    }

    public static String getExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n == -1 || n == string.length() - 1) {
            return "";
        }
        return string.substring(n + 1, string.length());
    }

    public static String getName(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static File createUniqueFile(File file) {
        while (file.exists()) {
            String string;
            String string2;
            String string3 = IOUtils.getExtension(file);
            String string4 = IOUtils.getName(file);
            int n = string4.lastIndexOf(45);
            if (n == -1) {
                string4 = string4 + "-1";
            } else {
                string2 = string4.substring(n + 1, string4.length());
                string = string4.substring(0, n);
                try {
                    int n2 = Integer.parseInt(string2) + 1;
                    string4 = string + "-" + n2;
                }
                catch (NumberFormatException numberFormatException) {
                    string4 = string4 + "-1";
                }
            }
            string2 = string4;
            if (!string3.equals("")) {
                string2 = string2 + "." + string3;
            }
            string = "";
            if (file.getParent() != null) {
                string = file.getParent();
            }
            file = new File(string, string2);
        }
        return file;
    }

    public static void copy(Reader reader, Writer writer) throws IOException {
        char[] cArray = new char[4096];
        int n = 0;
        while ((n = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n);
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtils.copy(inputStream, outputStream, (CopyMonitor)nullMon);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, CopyMonitor copyMonitor) throws IOException {
        byte[] byArray = new byte[4096];
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1 && !copyMonitor.isCopyAborted()) {
            outputStream.write(byArray, 0, n);
            copyMonitor.bytesCopied(n);
        }
    }

    public static void copy(File file, File file2) throws FileNotFoundException, IOException {
        IOUtils.copy(file, file2, (FileCopyMonitor)nullMon);
    }

    public static void copy(File file, File file2, boolean bl) throws FileNotFoundException, IOException {
        IOUtils.copy(file, file2, (FileCopyMonitor)nullMon, bl);
    }

    public static void copy(File file, File file2, FileCopyMonitor fileCopyMonitor) throws FileNotFoundException, IOException {
        IOUtils.copy(file, file2, fileCopyMonitor, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copy(File file, File file2, FileCopyMonitor fileCopyMonitor, boolean bl) throws FileNotFoundException, IOException {
        if (!bl) {
            file2 = IOUtils.createUniqueFile(file2);
        }
        fileCopyMonitor.copyingFile(file);
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            IOUtils.copy(fileInputStream, fileOutputStream, (CopyMonitor)fileCopyMonitor);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw fileNotFoundException;
                catch (IOException iOException) {
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(fileInputStream);
                IOUtils.close(fileOutputStream);
                throw throwable;
            }
        }
        IOUtils.close(fileInputStream);
        IOUtils.close(fileOutputStream);
    }

    public static void copy(String string, String string2) throws FileNotFoundException, IOException {
        IOUtils.copy(new File(string), new File(string2));
    }

    public static void copy(String string, String string2, FileCopyMonitor fileCopyMonitor) throws FileNotFoundException, IOException {
        IOUtils.copy(new File(string), new File(string2), fileCopyMonitor);
    }

    public static void copy(String string, String string2, boolean bl) throws FileNotFoundException, IOException {
        IOUtils.copy(new File(string), new File(string2), bl);
    }

    public static void copy(String string, String string2, FileCopyMonitor fileCopyMonitor, boolean bl) throws FileNotFoundException, IOException {
        IOUtils.copy(new File(string), new File(string2), fileCopyMonitor, bl);
    }

    public static void copyFiles(File file, File file2) throws IOException, FileNotFoundException {
        IOUtils.copyFiles(file, file2, nullMon);
    }

    public static void copyFiles(File file, File file2, FileCopyMonitor fileCopyMonitor) throws FileNotFoundException, IOException {
        IOUtils.copyFilesRecursively(file, file2, fileCopyMonitor);
    }

    private static void copyFilesRecursively(File file, File file2, FileCopyMonitor fileCopyMonitor) throws FileNotFoundException, IOException {
        if (fileCopyMonitor.isCopyAborted()) {
            return;
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File not found:" + file);
        }
        if (file.isDirectory()) {
            if (!file2.exists()) {
                file2.mkdirs();
            }
            Object[] objectArray = file.list();
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                IOUtils.copyFilesRecursively(new File(file, (String)objectArray[i]), new File(file2, (String)objectArray[i]), fileCopyMonitor);
            }
        } else {
            IOUtils.copy(file, file2, fileCopyMonitor, true);
        }
    }

    public static long getTotalBytes(File file) {
        long l = 0L;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                l += IOUtils.getTotalBytes(fileArray[i]);
            }
        } else {
            l = file.length();
        }
        return l;
    }

    public static String read(InputStream inputStream) throws IOException {
        return IOUtils.read(new InputStreamReader(inputStream));
    }

    public static String read(File file) throws FileNotFoundException, IOException {
        return IOUtils.read(new FileReader(file));
    }

    public static String read(Reader reader) throws IOException {
        int n;
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = bufferedReader.read()) != -1) {
            stringBuffer.append((char)n);
        }
        IOUtils.close(bufferedReader);
        return stringBuffer.toString();
    }

    public static void write(File file, String string) throws FileNotFoundException, IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.print(string);
        IOUtils.close(printWriter);
    }

    public static void write(File file, InputStream inputStream) throws FileNotFoundException, IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
            ((OutputStream)bufferedOutputStream).write(n);
        }
        IOUtils.close(bufferedInputStream);
        IOUtils.close(bufferedOutputStream);
    }

    public static boolean deleteRecursively(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                boolean bl = IOUtils.deleteRecursively(fileArray[i]);
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class NullCopyMonitor
    implements FileCopyMonitor {
        private NullCopyMonitor() {
        }

        @Override
        public void bytesCopied(int n) {
        }

        @Override
        public void copyingFile(File file) {
        }

        @Override
        public boolean isCopyAborted() {
            return false;
        }
    }
}

