/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.ImageView;

public class CachedImageView
extends ImageView {
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String PROP_DIR = USER_HOME + File.separator + ".thinga";
    public static final String IMG_CACHE_DIR = PROP_DIR + File.separator + "img_cache";
    private boolean hasCached;

    public CachedImageView(Element element) {
        super(element);
    }

    @Override
    public void paint(Graphics graphics, Shape shape) {
        boolean bl;
        super.paint(graphics, shape);
        Image image = this.getImage();
        int n = Toolkit.getDefaultToolkit().checkImage(image, -1, -1, this.getContainer());
        boolean bl2 = bl = (n & 0x20) != 0;
        if (bl && !this.hasCached) {
            this.cacheImage(image);
        }
    }

    private void cacheImage(final Image image) {
        final File file = this.getCachedImg();
        if (image == null || file == null || file.exists()) {
            return;
        }
        this.hasCached = true;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string = "png";
                if (file.getAbsolutePath().endsWith("jpg")) {
                    string = "jpg";
                }
                BufferedImage bufferedImage = CachedImageView.this.makeBufferedImage(image);
                try {
                    ImageIO.write((RenderedImage)bufferedImage, string, file);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        Thread thread = new Thread(runnable, "Image Cacher");
        thread.setPriority(5);
        thread.start();
    }

    private String srcAttribute() {
        return (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
    }

    @Override
    public URL getImageURL() {
        String string = this.srcAttribute();
        if (string == null) {
            return null;
        }
        URL uRL = null;
        File file = this.getCachedImg();
        try {
            if (file.exists()) {
                uRL = file.toURL();
            } else {
                URL uRL2 = ((HTMLDocument)this.getDocument()).getBase();
                uRL = new URL(uRL2, string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    private BufferedImage makeBufferedImage(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, null, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    private File getCachedImg() {
        String string = this.srcAttribute();
        if (string == null) {
            return null;
        }
        String string2 = ".png";
        if (string.toLowerCase().endsWith(".jpg") || string.toLowerCase().endsWith(".jpeg")) {
            string2 = ".jpg";
        }
        int n = Math.abs(string.hashCode());
        File file = new File(IMG_CACHE_DIR, n + string2);
        return file;
    }
}

