/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.html.HTMLDocument;
import net.atlanticbb.tantlinger.ui.DefaultAction;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.AbstractToolBar;
import net.atlanticbb.tantlinger.ui.text.AbstractWysiwygEditor;
import net.atlanticbb.tantlinger.ui.text.CompoundUndoManager;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLEditorActionFactory;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLFontColorAction;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLImageAction;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLInlineAction;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLLinkAction;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTableAction;
import org.bushe.swing.action.ActionList;
import org.bushe.swing.action.ActionUIFactory;

public class DefaultWysiwygToolBar
extends AbstractToolBar {
    private final AbstractWysiwygEditor wysiwygEditor;
    private JComboBox fontFamilyCombo;
    private JComboBox paragraphCombo;
    private ActionList actionList;
    private ActionListener fontChangeHandler = new FontChangeHandler();
    private ActionListener paragraphComboHandler = new ParagraphComboHandler();

    public DefaultWysiwygToolBar(AbstractWysiwygEditor abstractWysiwygEditor) {
        this.wysiwygEditor = abstractWysiwygEditor;
        this.wysiwygEditor.addCaretListener(new CaretHandler());
        this.build();
    }

    private void build() {
        Object object2;
        this.actionList = new ActionList((Object)"wysiwygToolbar");
        ActionList actionList = new ActionList((Object)"blockActions");
        actionList.addAll((Collection)HTMLEditorActionFactory.createBlockElementActionList());
        actionList.addAll((Collection)HTMLEditorActionFactory.createListElementActionList());
        ActionList actionList2 = new ActionList((Object)"fontSizeActions");
        actionList2.addAll((Collection)HTMLEditorActionFactory.createFontSizeActionList());
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("selected") && propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    DefaultWysiwygToolBar.this.paragraphCombo.setEnabled(false);
                    DefaultWysiwygToolBar.this.paragraphCombo.setSelectedItem(propertyChangeEvent.getSource());
                    DefaultWysiwygToolBar.this.paragraphCombo.setEnabled(true);
                }
            }
        };
        for (Object object2 : actionList) {
            if (!(object2 instanceof DefaultAction)) continue;
            ((DefaultAction)((Object)object2)).addPropertyChangeListener(propertyChangeListener);
        }
        this.paragraphCombo = new JComboBox<Action>(this.toArray(actionList));
        this.paragraphCombo.setPreferredSize(new Dimension(120, 22));
        this.paragraphCombo.setMinimumSize(new Dimension(120, 22));
        this.paragraphCombo.setMaximumSize(new Dimension(120, 22));
        this.paragraphCombo.addActionListener(this.paragraphComboHandler);
        this.paragraphCombo.setRenderer(new ParagraphComboRenderer());
        this.add(this.paragraphCombo);
        this.addSeparator();
        ArrayList arrayList = new ArrayList();
        arrayList.add("Default");
        arrayList.add("serif");
        arrayList.add("sans-serif");
        arrayList.add("monospaced");
        object2 = GraphicsEnvironment.getLocalGraphicsEnvironment();
        arrayList.addAll(Arrays.asList(((GraphicsEnvironment)object2).getAvailableFontFamilyNames()));
        this.fontFamilyCombo = new JComboBox<String>(arrayList.toArray(new String[arrayList.size()]));
        this.fontFamilyCombo.setPreferredSize(new Dimension(150, 22));
        this.fontFamilyCombo.setMinimumSize(new Dimension(150, 22));
        this.fontFamilyCombo.setMaximumSize(new Dimension(150, 22));
        this.fontFamilyCombo.addActionListener(this.fontChangeHandler);
        this.add(this.fontFamilyCombo);
        final JButton jButton = new JButton(UIUtils.getIcon("resources/images/x16/", "fontsize.png"));
        final JPopupMenu jPopupMenu = ActionUIFactory.getInstance().createPopupMenu(actionList2);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jPopupMenu.show(jButton, 0, jButton.getHeight());
            }
        };
        jButton.addActionListener(actionListener);
        this.configToolbarButton(jButton);
        this.add(jButton);
        Object object32 = new HTMLFontColorAction();
        this.actionList.add(object32);
        this.addToToolBar((Action)object32);
        this.addSeparator();
        object32 = new HTMLInlineAction(6);
        object32.putValue("BUTTON_TYPE", "toggle");
        this.actionList.add(object32);
        this.addToToolBar((Action)object32);
        object32 = new HTMLInlineAction(7);
        object32.putValue("BUTTON_TYPE", "toggle");
        this.actionList.add(object32);
        this.addToToolBar((Action)object32);
        object32 = new HTMLInlineAction(8);
        object32.putValue("BUTTON_TYPE", "toggle");
        this.actionList.add(object32);
        this.addToToolBar((Action)object32);
        this.addSeparator();
        ActionList actionList3 = HTMLEditorActionFactory.createListElementActionList();
        for (Object object32 : actionList3) {
            object32.putValue("BUTTON_TYPE", "toggle");
            this.actionList.add(object32);
            this.addToToolBar((Action)object32);
        }
        this.addSeparator();
        actionList3 = HTMLEditorActionFactory.createAlignActionList();
        for (Object object32 : actionList3) {
            object32.putValue("BUTTON_TYPE", "toggle");
            this.actionList.add(object32);
            this.addToToolBar((Action)object32);
        }
        this.addSeparator();
        object32 = new HTMLLinkAction();
        this.actionList.add(object32);
        this.addToToolBar((Action)object32);
        object32 = new HTMLImageAction();
        this.actionList.add(object32);
        this.addToToolBar((Action)object32);
        object32 = new HTMLTableAction();
        this.actionList.add(object32);
        this.addToToolBar((Action)object32);
        this.actionList.addAll((Collection)actionList);
        this.actionList.addAll((Collection)actionList2);
        this.wysiwygEditor.registerEditor(this.actionList);
    }

    public void setFontName(String string) {
        String string2;
        String string3 = string2 = this.fontFamilyCombo.getSelectedItem() != null ? this.fontFamilyCombo.getSelectedItem().toString() : "";
        if (string != null && string.equalsIgnoreCase(string2)) {
            return;
        }
        try {
            this.fontFamilyCombo.setEnabled(false);
            if (string != null && string.trim().length() > 0) {
                this.fontFamilyCombo.setSelectedItem(string);
            } else {
                this.fontFamilyCombo.setSelectedIndex(0);
            }
        }
        finally {
            this.fontFamilyCombo.setEnabled(true);
        }
    }

    private Action[] toArray(ActionList actionList) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        for (Object e : actionList) {
            if (e == null || !(e instanceof Action)) continue;
            arrayList.add((Action)e);
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private void updateState() {
        String string = this.wysiwygEditor.getFontFamily();
        this.setFontName(string);
        this.wysiwygEditor.registerEditor(this.actionList);
        this.actionList.updateEnabledForAll();
    }

    private class FontChangeHandler
    implements ActionListener {
        private FontChangeHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!DefaultWysiwygToolBar.this.fontFamilyCombo.isEnabled()) {
                return;
            }
            HTMLDocument hTMLDocument = (HTMLDocument)DefaultWysiwygToolBar.this.wysiwygEditor.getDocument();
            CompoundUndoManager.beginCompoundEdit(hTMLDocument);
            if (DefaultWysiwygToolBar.this.fontFamilyCombo.getSelectedIndex() > 0) {
                DefaultWysiwygToolBar.this.wysiwygEditor.setFontFamily(DefaultWysiwygToolBar.this.fontFamilyCombo.getSelectedItem().toString());
            } else {
                DefaultWysiwygToolBar.this.wysiwygEditor.setFontFamily(null);
            }
            CompoundUndoManager.endCompoundEdit(hTMLDocument);
        }
    }

    private class ParagraphComboRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private ParagraphComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Action) {
                object = ((Action)object).getValue("Name");
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }

    private class ParagraphComboHandler
    implements ActionListener {
        private ParagraphComboHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!DefaultWysiwygToolBar.this.paragraphCombo.isEnabled()) {
                return;
            }
            Action action = (Action)DefaultWysiwygToolBar.this.paragraphCombo.getSelectedItem();
            action.actionPerformed(actionEvent);
        }
    }

    private class CaretHandler
    implements CaretListener {
        private CaretHandler() {
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            DefaultWysiwygToolBar.this.updateState();
        }
    }
}

