/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.CompoundUndoManager;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;
import org.bushe.swing.action.ShouldBeEnabledDelegate;

public class PasteAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;

    public PasteAction() {
        super(i18n.str("paste"));
        this.putValue("MnemonicKey", new Integer(i18n.mnem("paste")));
        this.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "paste.png"));
        this.putValue("LARGE_ICON", UIUtils.getIcon("resources/images/x24/", "paste.png"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 2));
        this.addShouldBeEnabledDelegate(new ShouldBeEnabledDelegate(){

            public boolean shouldBeEnabled(Action action) {
                JEditorPane jEditorPane = PasteAction.this.getCurrentEditor();
                if (jEditorPane == null) {
                    return true;
                }
                return jEditorPane.isEditable() && jEditorPane.isEnabled();
            }
        });
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    @Override
    protected void updateWysiwygContextState(JEditorPane jEditorPane) {
        this.updateEnabledState();
    }

    @Override
    protected void updateSourceContextState(JEditorPane jEditorPane) {
        this.updateEnabledState();
    }

    @Override
    protected void sourceEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        jEditorPane.paste();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void wysiwygEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)jEditorPane.getEditorKit();
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            CompoundUndoManager.beginCompoundEdit(hTMLDocument);
            Transferable transferable = clipboard.getContents((Object)this);
            String string = transferable.getTransferData(new DataFlavor(String.class, "String")).toString();
            hTMLDocument.replace(jEditorPane.getSelectionStart(), jEditorPane.getSelectionEnd() - jEditorPane.getSelectionStart(), string, hTMLEditorKit.getInputAttributes());
        }
        catch (Exception exception) {
        }
        finally {
            CompoundUndoManager.endCompoundEdit(hTMLDocument);
        }
    }
}

