/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import net.atlanticbb.tantlinger.i18n.I18n;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;

public class BGColorPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final I18n i18n = I18n.getInstance("net.atlanticbb.tantlinger.ui.text.dialogs");
    private JCheckBox bgColorCB = null;
    private JPanel colorPanel = null;
    private JButton colorButton = null;
    private Color selColor = Color.WHITE;

    public BGColorPanel() {
        this.initialize();
    }

    public void setSelected(boolean bl) {
        this.bgColorCB.setSelected(bl);
        this.colorButton.setEnabled(bl);
    }

    public boolean isSelected() {
        return this.bgColorCB.isSelected();
    }

    public String getColor() {
        return HTMLUtils.colorToHex(this.selColor);
    }

    public void setColor(String string) {
        this.selColor = HTMLUtils.stringToColor(string);
        this.colorPanel.setBackground(this.selColor);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints2.gridy = 0;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints3.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(175, 30);
        this.setPreferredSize(new Dimension(175, 30));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        this.add((Component)this.getBgColorCB(), gridBagConstraints3);
        this.add((Component)this.getColorPanel(), gridBagConstraints2);
        this.add((Component)this.getColorButton(), gridBagConstraints);
        this.colorButton.setEnabled(this.bgColorCB.isSelected());
    }

    private JCheckBox getBgColorCB() {
        if (this.bgColorCB == null) {
            this.bgColorCB = new JCheckBox();
            this.bgColorCB.setText(i18n.str("background"));
            this.bgColorCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    BGColorPanel.this.colorButton.setEnabled(BGColorPanel.this.bgColorCB.isSelected());
                    if (BGColorPanel.this.bgColorCB.isSelected()) {
                        BGColorPanel.this.colorPanel.setBackground(BGColorPanel.this.selColor);
                    } else {
                        BGColorPanel.this.colorPanel.setBackground(BGColorPanel.this.getBackground());
                    }
                }
            });
        }
        return this.bgColorCB;
    }

    private JPanel getColorPanel() {
        if (this.colorPanel == null) {
            this.colorPanel = new JPanel();
            this.colorPanel.setPreferredSize(new Dimension(50, 20));
            this.colorPanel.setBorder(BorderFactory.createBevelBorder(1));
        }
        return this.colorPanel;
    }

    private JButton getColorButton() {
        if (this.colorButton == null) {
            this.colorButton = new JButton();
            this.colorButton.setIcon(UIUtils.getIcon("resources/images/x16/", "color.png"));
            this.colorButton.setPreferredSize(new Dimension(20, 20));
            this.colorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(BGColorPanel.this, i18n.str("color"), BGColorPanel.this.selColor);
                    if (color != null) {
                        BGColorPanel.this.selColor = color;
                        BGColorPanel.this.colorPanel.setBackground(color);
                        BGColorPanel.this.colorPanel.setToolTipText(HTMLUtils.colorToHex(color));
                    }
                }
            });
        }
        return this.colorButton;
    }
}

