/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.atlanticbb.tantlinger.i18n.I18n;
import net.atlanticbb.tantlinger.ui.OptionDialog;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.dialogs.TableAttributesPanel;

public class NewTableDialog
extends OptionDialog {
    private static final long serialVersionUID = 1L;
    private static final I18n i18n = I18n.getInstance("net.atlanticbb.tantlinger.ui.text.dialogs");
    private LayoutPanel layoutPanel = new LayoutPanel();
    private TableAttributesPanel propsPanel;
    private static Icon icon = UIUtils.getIcon("resources/images/x32/", "table.png");

    public NewTableDialog(Frame frame) {
        super(frame, i18n.str("new_table"), i18n.str("new_table_desc"), icon);
        this.init();
    }

    public NewTableDialog(Dialog dialog) {
        super(dialog, i18n.str("new_table"), i18n.str("new_table_desc"), icon);
        this.init();
    }

    private void init() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("border", "1");
        hashtable.put("width", "100%");
        this.propsPanel = new TableAttributesPanel();
        this.propsPanel.setAttributes(hashtable);
        this.propsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(i18n.str("properties")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.layoutPanel, "North");
        jPanel.add((Component)this.propsPanel, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setContentPane(jPanel);
        this.setSize(new Dimension(330, 380));
        this.setResizable(false);
    }

    public String getHTML() {
        String string = "<table";
        Map map = this.propsPanel.getAttributes();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            String string3 = map.get(string2).toString();
            string = string + ' ' + string2 + "=\"" + string3 + "\"";
        }
        string = string + ">\n";
        int n = this.layoutPanel.getRows();
        int n2 = this.layoutPanel.getColumns();
        for (int i = 1; i <= n; ++i) {
            string = string + "<tr>\n";
            for (int j = 1; j <= n2; ++j) {
                string = string + "\t<td>\n</td>\n";
            }
            string = string + "</tr>\n";
        }
        return string + "</table>";
    }

    private class LayoutPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel rowsLabel = null;
        private JLabel colsLabel = null;
        private int iRows;
        private int iCols;
        private JSpinner rowsField = null;
        private JSpinner colsField = null;

        public LayoutPanel() {
            this(1, 1);
        }

        public LayoutPanel(int n, int n2) {
            this.iRows = n > 0 ? n : 1;
            this.iCols = n2 > 0 ? n2 : 1;
            this.initialize();
        }

        public int getRows() {
            return Integer.parseInt(this.rowsField.getModel().getValue().toString());
        }

        public int getColumns() {
            return Integer.parseInt(this.colsField.getModel().getValue().toString());
        }

        private void initialize() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 3;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 15);
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints3.gridy = 0;
            this.colsLabel = new JLabel();
            this.colsLabel.setText(i18n.str("columns"));
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints4.weighty = 0.0;
            gridBagConstraints4.gridy = 0;
            this.rowsLabel = new JLabel();
            this.rowsLabel.setText(i18n.str("rows"));
            this.setLayout(new GridBagLayout());
            this.setSize(330, 60);
            this.setPreferredSize(new Dimension(330, 60));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, i18n.str("layout"), 0, 0, null, null), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.add((Component)this.rowsLabel, gridBagConstraints4);
            this.add((Component)this.colsLabel, gridBagConstraints3);
            this.add((Component)this.getRowsField(), gridBagConstraints2);
            this.add((Component)this.getColsField(), gridBagConstraints);
        }

        private JSpinner getRowsField() {
            if (this.rowsField == null) {
                this.rowsField = new JSpinner(new SpinnerNumberModel(this.iRows, 1, 999, 1));
            }
            return this.rowsField;
        }

        private JSpinner getColsField() {
            if (this.colsField == null) {
                this.colsField = new JSpinner(new SpinnerNumberModel(this.iCols, 1, 999, 1));
            }
            return this.colsField;
        }
    }
}

