/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlType;
import java.util.Date;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchDateTimeImpl
extends AbstractImplItem
implements SerializableXmlType {
    private static final long serialVersionUID = 3496570929639934566L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchDateTimeImpl.class);
    private static final String XML_ATTRIB_BEGIN = "Begin";
    private static final String XML_ATTRIB_END = "End";
    private Date begin = null;
    private Date end = null;
    private long order = 0L;

    public Date getBegin() {
        return this.begin != null ? (Date)this.begin.clone() : null;
    }

    public Date getEnd() {
        return this.end != null ? (Date)this.end.clone() : null;
    }

    public long getOrder() {
        return this.order;
    }

    public boolean isMatching(Date date) {
        if (this.begin != null && this.begin.after(date)) {
            return false;
        }
        return this.end == null || !this.end.before(date);
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        this.setBegin(SearchDateTimeImpl.selectAttributeAsDateTime(element, XML_ATTRIB_BEGIN, null));
        this.setEnd(SearchDateTimeImpl.selectAttributeAsDateTime(element, XML_ATTRIB_END, null));
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        if (this.begin != null) {
            element.addAttribute(XML_ATTRIB_BEGIN, OpenEstateUtils.getXsdDateTimeFormat().format(this.begin));
        }
        if (this.end != null) {
            element.addAttribute(XML_ATTRIB_END, OpenEstateUtils.getXsdDateTimeFormat().format(this.end));
        }
    }

    public void setBegin(Date date) {
        this.begin = date != null ? (Date)date.clone() : null;
    }

    public void setEnd(Date date) {
        this.end = date != null ? (Date)date.clone() : null;
    }

    public void setOrder(long l) {
        this.order = l;
    }
}

