/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.SearchAttribImpl;
import com.openindex.openestate.impl.SearchEqualsImpl;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchImpl
extends AbstractImplItem
implements SerializableXmlElement {
    private static final long serialVersionUID = -3703451053086719650L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchImpl.class);
    private static final String XML_ATTRIB_NAME = "Name";
    private static final String XML_ATTRIB_ENABLED = "Enabled";
    private static final String XML_ELEMENT = "Search";
    private static final String XML_ELEMENT_CONDITIONS = "Conditions";
    private static final String XML_ELEMENT_CONDITIONS_STREET = "Street";
    private static final String XML_ELEMENT_CONDITIONS_STREET_NR = "StreetNr";
    private static final String XML_ELEMENT_CONDITIONS_CITY = "City";
    private static final String XML_ELEMENT_CONDITIONS_DISTRICT = "District";
    private static final String XML_ELEMENT_CONDITIONS_POSTALCODE = "PostalCode";
    private static final String XML_ELEMENT_CONDITIONS_REGION = "Region";
    private static final String XML_ELEMENT_CONDITIONS_COUNTRY = "Country";
    private static final String XML_ELEMENT_CONDITIONS_ESTATE_ATTRIB = "EstateAttribute";
    private static final String XML_ELEMENT_CONDITIONS_ESTATE_ACTION = "EstateAction";
    private static final String XML_ELEMENT_CONDITIONS_ESTATE_TYPE = "EstateType";
    private static final String XML_ELEMENT_PARAMS = "Params";
    private static final String XML_ELEMENT_PARAMS_PARAM = "Param";
    private static final String XML_ELEMENT_PARAMS_PARAM_KEY = "Key";
    private static final String XML_ELEMENT_PARAMS_PARAM_VALUE = "Value";
    private static final String XML_ELEMENT_NOTES = "Notes";
    private String name = null;
    private String notes = null;
    private boolean enabled = true;
    private final Map<String, String> params = new HashMap<String, String>();
    private final List<SearchAttribImpl> attribConditions = new ArrayList<SearchAttribImpl>();
    private final Map<SimpleConditionType, List<SearchEqualsImpl>> simpleConditions = new EnumMap<SimpleConditionType, List<SearchEqualsImpl>>(SimpleConditionType.class);

    public SearchImpl() {
        for (SimpleConditionType simpleConditionType : SimpleConditionType.values()) {
            this.simpleConditions.put(simpleConditionType, new ArrayList());
        }
    }

    public List<SearchAttribImpl> getAttribConditions() {
        return this.attribConditions;
    }

    public String getName() {
        return this.name;
    }

    public String getNotes() {
        return this.notes;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public List<SearchEqualsImpl> getSimpleConditions(SimpleConditionType simpleConditionType) {
        return this.simpleConditions.get((Object)simpleConditionType);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMatching(EstateImpl estateImpl) {
        Object object;
        void searchAttribImpl;
        Object object22;
        List<SearchEqualsImpl> list = this.getSimpleConditions(SimpleConditionType.ESTATE_TYPE);
        if (list != null && !list.isEmpty()) {
            Object[] objectArray;
            boolean bl = false;
            OpenEstateType openEstateType = estateImpl.getType();
            Object[] objectArray2 = objectArray = openEstateType != null ? openEstateType.getParentPath() : null;
            if (objectArray != null && !ArrayUtils.isEmpty((Object[])objectArray)) {
                for (Object object22 : this.getSimpleConditions(SimpleConditionType.ESTATE_TYPE)) {
                    for (Object object3 : objectArray) {
                        if (!((SearchEqualsImpl)object22).isMatching(((Enum)object3).name())) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                    break;
                }
            }
            if (!bl) {
                return false;
            }
        }
        Object enumMap = SimpleConditionType.values();
        int n = ((SimpleConditionType[])enumMap).length;
        boolean bl = false;
        while (searchAttribImpl < n) {
            object = enumMap[searchAttribImpl];
            if (!SimpleConditionType.ESTATE_TYPE.equals(object)) {
                switch (object) {
                    case CITY: {
                        object22 = estateImpl.getAddress().getCity();
                        break;
                    }
                    case DISTRICT: {
                        object22 = estateImpl.getAddress().getDistrict();
                        break;
                    }
                    case COUNTRY: {
                        object22 = estateImpl.getAddress().getCountry();
                        break;
                    }
                    case ESTATE_ACTION: {
                        object22 = estateImpl.getAction().name();
                        break;
                    }
                    case POSTAL_CODE: {
                        object22 = estateImpl.getAddress().getPostalCode();
                        break;
                    }
                    case REGION: {
                        object22 = estateImpl.getAddress().getRegion();
                        break;
                    }
                    case STREET: {
                        object22 = estateImpl.getAddress().getStreet();
                        break;
                    }
                    case STREET_NR: {
                        object22 = estateImpl.getAddress().getStreetNr();
                        break;
                    }
                    default: {
                        object22 = null;
                    }
                }
                Object[] bl2 = this.getSimpleConditions((SimpleConditionType)((Object)object));
                if (!bl2.isEmpty()) {
                    int n2 = 0;
                    for (Object object3 : bl2) {
                        if (!((SearchEqualsImpl)object3).isMatching((String)object22)) continue;
                        n2 = 1;
                        break;
                    }
                    if (n2 == 0) {
                        return false;
                    }
                }
            }
            ++searchAttribImpl;
        }
        enumMap = new EnumMap(OpenEstateAttrib.class);
        for (SearchAttribImpl entry : this.getAttribConditions()) {
            object = entry.getAttribute();
            if (!estateImpl.hasAttribute((OpenEstateAttrib)object)) {
                return false;
            }
            if (!enumMap.containsKey(object)) {
                enumMap.put(object, new ArrayList());
            }
            ((List)enumMap.get(object)).add(entry);
        }
        for (Map.Entry entry : enumMap.entrySet()) {
            object = (OpenEstateAttrib)entry.getKey();
            object22 = estateImpl.hasAttribute((OpenEstateAttrib)object) ? estateImpl.getAttributes().get(object) : null;
            boolean bl3 = false;
            for (SearchAttribImpl searchAttribImpl2 : (List)entry.getValue()) {
                if (!searchAttribImpl2.isMatching((AbstractAttribImpl)object22)) continue;
                bl3 = true;
                break;
            }
            if (bl3) continue;
            return false;
        }
        return true;
    }

    @Override
    public void readFromXml(Document document) throws DocumentException {
        this.readFromXml(document.getRootElement());
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        this.setName(SearchImpl.selectAttribute(element, XML_ATTRIB_NAME, null));
        this.setEnabled(SearchImpl.selectAttributeAsBoolean(element, XML_ATTRIB_ENABLED, true));
        this.setNotes(null);
        this.params.clear();
        this.attribConditions.clear();
        for (SimpleConditionType simpleConditionType : SimpleConditionType.values()) {
            this.simpleConditions.get((Object)simpleConditionType).clear();
        }
        int n = 0;
        for (Node node : SearchImpl.selectChildElements(element)) {
            Object object;
            if (XML_ELEMENT_NOTES.equals(node.getName())) {
                this.setNotes(node.getText());
                continue;
            }
            if (XML_ELEMENT_PARAMS.equals(node.getName())) {
                for (Node node2 : SearchImpl.selectChildElements((Element)node)) {
                    if (!XML_ELEMENT_PARAMS_PARAM.equals(node2.getName())) continue;
                    object = SearchImpl.selectAttribute((Element)node2, XML_ELEMENT_PARAMS_PARAM_KEY, null);
                    String string = SearchImpl.selectAttribute((Element)node2, XML_ELEMENT_PARAMS_PARAM_VALUE, null);
                    if (object == null || string == null) continue;
                    this.params.put((String)object, string);
                }
                continue;
            }
            if (!XML_ELEMENT_CONDITIONS.equals(node.getName())) continue;
            for (Node node2 : SearchImpl.selectChildElements((Element)node)) {
                if (XML_ELEMENT_CONDITIONS_CITY.equals(node2.getName())) {
                    object = new SearchEqualsImpl();
                    ((SearchEqualsImpl)object).readFromXml((Element)node2);
                    ((SearchEqualsImpl)object).setOrder(n++);
                    this.simpleConditions.get((Object)SimpleConditionType.CITY).add((SearchEqualsImpl)object);
                    continue;
                }
                if (XML_ELEMENT_CONDITIONS_DISTRICT.equals(node2.getName())) {
                    object = new SearchEqualsImpl();
                    ((SearchEqualsImpl)object).readFromXml((Element)node2);
                    ((SearchEqualsImpl)object).setOrder(n++);
                    this.simpleConditions.get((Object)SimpleConditionType.DISTRICT).add((SearchEqualsImpl)object);
                    continue;
                }
                if (XML_ELEMENT_CONDITIONS_COUNTRY.equals(node2.getName())) {
                    object = new SearchEqualsImpl();
                    ((SearchEqualsImpl)object).readFromXml((Element)node2);
                    ((SearchEqualsImpl)object).setOrder(n++);
                    this.simpleConditions.get((Object)SimpleConditionType.COUNTRY).add((SearchEqualsImpl)object);
                    continue;
                }
                if (XML_ELEMENT_CONDITIONS_ESTATE_ACTION.equals(node2.getName())) {
                    object = new SearchEqualsImpl();
                    ((SearchEqualsImpl)object).readFromXml((Element)node2);
                    ((SearchEqualsImpl)object).setOrder(n++);
                    this.simpleConditions.get((Object)SimpleConditionType.ESTATE_ACTION).add((SearchEqualsImpl)object);
                    continue;
                }
                if (XML_ELEMENT_CONDITIONS_ESTATE_ATTRIB.equals(node2.getName())) {
                    object = new SearchAttribImpl();
                    ((SearchAttribImpl)object).readFromXml((Element)node2);
                    ((SearchAttribImpl)object).setOrder(n++);
                    this.attribConditions.add((SearchAttribImpl)object);
                    continue;
                }
                if (XML_ELEMENT_CONDITIONS_ESTATE_TYPE.equals(node2.getName())) {
                    object = new SearchEqualsImpl();
                    ((SearchEqualsImpl)object).readFromXml((Element)node2);
                    ((SearchEqualsImpl)object).setOrder(n++);
                    this.simpleConditions.get((Object)SimpleConditionType.ESTATE_TYPE).add((SearchEqualsImpl)object);
                    continue;
                }
                if (XML_ELEMENT_CONDITIONS_POSTALCODE.equals(node2.getName())) {
                    object = new SearchEqualsImpl();
                    ((SearchEqualsImpl)object).readFromXml((Element)node2);
                    ((SearchEqualsImpl)object).setOrder(n++);
                    this.simpleConditions.get((Object)SimpleConditionType.POSTAL_CODE).add((SearchEqualsImpl)object);
                    continue;
                }
                if (XML_ELEMENT_CONDITIONS_REGION.equals(node2.getName())) {
                    object = new SearchEqualsImpl();
                    ((SearchEqualsImpl)object).readFromXml((Element)node2);
                    ((SearchEqualsImpl)object).setOrder(n++);
                    this.simpleConditions.get((Object)SimpleConditionType.REGION).add((SearchEqualsImpl)object);
                    continue;
                }
                if (XML_ELEMENT_CONDITIONS_STREET.equals(node2.getName())) {
                    object = new SearchEqualsImpl();
                    ((SearchEqualsImpl)object).readFromXml((Element)node2);
                    ((SearchEqualsImpl)object).setOrder(n++);
                    this.simpleConditions.get((Object)SimpleConditionType.STREET).add((SearchEqualsImpl)object);
                    continue;
                }
                if (!XML_ELEMENT_CONDITIONS_STREET_NR.equals(node2.getName())) continue;
                object = new SearchEqualsImpl();
                ((SearchEqualsImpl)object).readFromXml((Element)node2);
                ((SearchEqualsImpl)object).setOrder(n++);
                this.simpleConditions.get((Object)SimpleConditionType.STREET_NR).add((SearchEqualsImpl)object);
            }
        }
    }

    @Override
    public void serializeToXml(Document document) throws DocumentException {
        Element element = DocumentFactory.getInstance().createElement(XML_ELEMENT, "http://www.openestate.org/1.0/");
        this.serializeToXml(element);
        document.setRootElement(element);
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        String string;
        element.addAttribute(XML_ATTRIB_ENABLED, Boolean.toString(this.isEnabled()));
        if (this.name != null) {
            element.addAttribute(XML_ATTRIB_NAME, this.name);
        }
        Element element2 = null;
        for (Map.Entry<SimpleConditionType, List<SearchEqualsImpl>> object2 : this.simpleConditions.entrySet()) {
            SimpleConditionType simpleConditionType = object2.getKey();
            if (SimpleConditionType.CITY.equals((Object)simpleConditionType)) {
                string = XML_ELEMENT_CONDITIONS_CITY;
            } else if (SimpleConditionType.DISTRICT.equals((Object)simpleConditionType)) {
                string = XML_ELEMENT_CONDITIONS_DISTRICT;
            } else if (SimpleConditionType.COUNTRY.equals((Object)simpleConditionType)) {
                string = XML_ELEMENT_CONDITIONS_COUNTRY;
            } else if (SimpleConditionType.ESTATE_ACTION.equals((Object)simpleConditionType)) {
                string = XML_ELEMENT_CONDITIONS_ESTATE_ACTION;
            } else if (SimpleConditionType.ESTATE_TYPE.equals((Object)simpleConditionType)) {
                string = XML_ELEMENT_CONDITIONS_ESTATE_TYPE;
            } else if (SimpleConditionType.POSTAL_CODE.equals((Object)simpleConditionType)) {
                string = XML_ELEMENT_CONDITIONS_POSTALCODE;
            } else if (SimpleConditionType.REGION.equals((Object)simpleConditionType)) {
                string = XML_ELEMENT_CONDITIONS_REGION;
            } else if (SimpleConditionType.STREET.equals((Object)simpleConditionType)) {
                string = XML_ELEMENT_CONDITIONS_STREET;
            } else {
                if (!SimpleConditionType.STREET_NR.equals((Object)simpleConditionType)) continue;
                string = XML_ELEMENT_CONDITIONS_STREET_NR;
            }
            for (SearchEqualsImpl searchEqualsImpl : object2.getValue()) {
                if (element2 == null) {
                    element2 = element.addElement(XML_ELEMENT_CONDITIONS);
                }
                Element element3 = element2.addElement(string);
                searchEqualsImpl.serializeToXml(element3);
            }
        }
        for (SearchAttribImpl searchAttribImpl : this.attribConditions) {
            if (element2 == null) {
                element2 = element.addElement(XML_ELEMENT_CONDITIONS);
            }
            Element element4 = element2.addElement(XML_ELEMENT_CONDITIONS_ESTATE_ATTRIB);
            searchAttribImpl.serializeToXml(element4);
        }
        Iterator<Object> iterator = null;
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            SearchEqualsImpl searchEqualsImpl;
            string = entry.getKey();
            String string2 = StringUtils.trimToNull((String)entry.getValue());
            if (string2 == null) continue;
            if (iterator == null) {
                iterator = element.addElement(XML_ELEMENT_PARAMS);
            }
            searchEqualsImpl = iterator.addElement(XML_ELEMENT_PARAMS_PARAM);
            searchEqualsImpl.addAttribute(XML_ELEMENT_PARAMS_PARAM_KEY, string);
            searchEqualsImpl.addAttribute(XML_ELEMENT_PARAMS_PARAM_VALUE, string2);
        }
        if (this.notes != null) {
            Element element5 = element.addElement(XML_ELEMENT_NOTES);
            element5.setText(this.notes);
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNotes(String string) {
        this.notes = string;
    }

    public static enum SimpleConditionType {
        STREET,
        STREET_NR,
        CITY,
        DISTRICT,
        POSTAL_CODE,
        REGION,
        COUNTRY,
        ESTATE_ACTION,
        ESTATE_TYPE;

    }
}

