/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.SimpleAttrib;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleNumericAttrib
extends SimpleAttrib<Number> {
    private static final long serialVersionUID = -1328635202209111755L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleNumericAttrib.class);
    private final Integer precision;
    private final Long maximum;
    private final Long minimum;
    private final boolean groupedFormat;
    private Number value = null;

    public SimpleNumericAttrib(OpenEstateAttrib openEstateAttrib, Integer n, Boolean bl, String[] stringArray) {
        this(openEstateAttrib, n, null, null, bl, stringArray);
    }

    public SimpleNumericAttrib(OpenEstateAttrib openEstateAttrib, Integer n, Long l, Long l2, Boolean bl, String[] stringArray) {
        super(openEstateAttrib, stringArray);
        this.precision = n;
        this.maximum = l;
        this.minimum = l2;
        this.groupedFormat = bl == null || Boolean.TRUE.equals(bl);
    }

    @Override
    public Number getDefaultValue() {
        if (this.getPrecision() <= 0) {
            return BigInteger.ZERO;
        }
        return BigDecimal.ZERO;
    }

    protected static Number get(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        try {
            SimpleNumericAttrib simpleNumericAttrib = (SimpleNumericAttrib)estateImpl.getAttribute(openEstateAttrib);
            return simpleNumericAttrib != null ? (Number)simpleNumericAttrib.getValue() : (Number)null;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read attribute \"" + openEstateAttrib + "\" as Number!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    protected static BigDecimal getAsBigDecimal(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        Number number = SimpleNumericAttrib.get(estateImpl, openEstateAttrib);
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        if (number instanceof Integer) {
            return BigDecimal.valueOf(number.longValue());
        }
        if (number instanceof Long) {
            return BigDecimal.valueOf(number.longValue());
        }
        if (number != null) {
            return BigDecimal.valueOf(number.doubleValue());
        }
        return null;
    }

    protected static BigInteger getAsBigInteger(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        Number number = SimpleNumericAttrib.get(estateImpl, openEstateAttrib);
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).toBigInteger();
        }
        if (number != null) {
            return BigInteger.valueOf(number.longValue());
        }
        return null;
    }

    protected static Double getAsDouble(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        Number number = SimpleNumericAttrib.get(estateImpl, openEstateAttrib);
        if (number instanceof Double) {
            return (Double)number;
        }
        if (number != null) {
            return number.doubleValue();
        }
        return null;
    }

    protected static Float getAsFloat(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        Number number = SimpleNumericAttrib.get(estateImpl, openEstateAttrib);
        if (number instanceof Float) {
            return (Float)number;
        }
        if (number != null) {
            return Float.valueOf(number.floatValue());
        }
        return null;
    }

    protected static Integer getAsInteger(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        Number number = SimpleNumericAttrib.get(estateImpl, openEstateAttrib);
        if (number instanceof Integer) {
            return (Integer)number;
        }
        if (number != null) {
            return number.intValue();
        }
        return null;
    }

    protected static Long getAsLong(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        Number number = SimpleNumericAttrib.get(estateImpl, openEstateAttrib);
        if (number instanceof Long) {
            return (Long)number;
        }
        if (number != null) {
            return number.longValue();
        }
        return null;
    }

    protected static String getAsString(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        return SimpleNumericAttrib.getAsString(estateImpl, openEstateAttrib, null);
    }

    protected static String getAsString(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Locale locale) {
        try {
            AbstractAttribImpl abstractAttribImpl = estateImpl.getAttribute(openEstateAttrib);
            return abstractAttribImpl != null ? abstractAttribImpl.getFormattedValue(locale) : null;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read attribute \"" + openEstateAttrib + "\" as String!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public final NumberFormat getFormat() {
        return this.getFormat(null);
    }

    public final NumberFormat getFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        NumberFormat numberFormat = this.precision < 1 ? NumberFormat.getIntegerInstance(locale) : NumberFormat.getNumberInstance(locale);
        numberFormat.setGroupingUsed(this.groupedFormat);
        if (this.precision > 0) {
            numberFormat.setMaximumFractionDigits(this.precision);
            numberFormat.setMinimumFractionDigits(0);
        }
        return numberFormat;
    }

    @Override
    public String getFormattedValue(Number number, Locale locale, String string) {
        return number != null ? this.getFormat(locale).format(number) : "";
    }

    public final Long getMaximum() {
        return this.maximum;
    }

    public final Long getMinimum() {
        return this.minimum;
    }

    public final int getPrecision() {
        return this.precision != null ? this.precision : 0;
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    @Override
    public final Number parseValue(String string) {
        return OpenEstateUtils.parseNumber(string, this.getFormat());
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, String string) {
        SimpleNumericAttrib.put(estateImpl, openEstateAttrib, string != null ? (Number)OpenEstateUtils.parseNumber(string) : (Number)null);
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Number number) {
        try {
            if (number == null) {
                estateImpl.removeAttribute(openEstateAttrib);
            } else {
                SimpleNumericAttrib simpleNumericAttrib = (SimpleNumericAttrib)openEstateAttrib.createImpl();
                simpleNumericAttrib.setValue(number);
                estateImpl.putAttribute(simpleNumericAttrib);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't put numeric attribute \"" + openEstateAttrib + "\"!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    @Override
    public void setValue(Number number) {
        this.value = number;
    }

    @Override
    protected String writeValue(Number number) {
        return number != null ? number.toString() : "";
    }
}

