/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs.administration;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import com.openindex.openestate.impl.utils.Translatable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.xnap.commons.i18n.I18n;

public final class BuildableWith
extends ComplexEnumAttrib<Option> {
    public BuildableWith() {
        super(OpenEstateAttrib.ADMINISTRATION_BUILDABLE_WITH, null);
    }

    public BuildableWith(Option option) {
        Option[] optionArray;
        if (option != null) {
            Option[] optionArray2 = new Option[1];
            optionArray = optionArray2;
            optionArray2[0] = option;
        } else {
            optionArray = null;
        }
        this(optionArray);
    }

    public BuildableWith(Option[] optionArray) {
        this();
        if (optionArray != null) {
            ((AbstractAttribImpl)this).setValue(optionArray);
        }
    }

    public static Option[] get(EstateImpl estateImpl) {
        return (Option[])BuildableWith.get(estateImpl, OpenEstateAttrib.ADMINISTRATION_BUILDABLE_WITH);
    }

    public static List<Option> getAsList(EstateImpl estateImpl) {
        ArrayList<Option> arrayList = new ArrayList<Option>();
        Option[] optionArray = BuildableWith.get(estateImpl);
        if (optionArray != null) {
            arrayList.addAll(Arrays.asList(optionArray));
        }
        return arrayList;
    }

    public static String getAsString(EstateImpl estateImpl, String string) {
        return BuildableWith.getAsString(estateImpl, OpenEstateAttrib.ADMINISTRATION_BUILDABLE_WITH, string);
    }

    public static String getAsString(EstateImpl estateImpl, String string, Locale locale) {
        return BuildableWith.getAsString(estateImpl, OpenEstateAttrib.ADMINISTRATION_BUILDABLE_WITH, string, locale);
    }

    @Override
    public Option getOption(String string) {
        try {
            return Option.valueOf(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Option[] getOptions() {
        return Option.values();
    }

    public Option[] getOptionsArray(Collection<Option> collection) {
        return collection != null && !collection.isEmpty() ? collection.toArray(new Option[collection.size()]) : new Option[]{};
    }

    public static boolean hasOption(EstateImpl estateImpl, Option option) {
        return BuildableWith.hasOption(estateImpl, OpenEstateAttrib.ADMINISTRATION_BUILDABLE_WITH, option);
    }

    public static void put(EstateImpl estateImpl, Option[] optionArray) {
        BuildableWith.put(estateImpl, OpenEstateAttrib.ADMINISTRATION_BUILDABLE_WITH, optionArray);
    }

    public static void put(EstateImpl estateImpl, String[] stringArray) {
        BuildableWith.put(estateImpl, OpenEstateAttrib.ADMINISTRATION_BUILDABLE_WITH, stringArray);
    }

    public static void putOption(EstateImpl estateImpl, Option option) {
        BuildableWith.putOption(estateImpl, OpenEstateAttrib.ADMINISTRATION_BUILDABLE_WITH, option);
    }

    public static void putOption(EstateImpl estateImpl, String string) {
        BuildableWith.putOption(estateImpl, OpenEstateAttrib.ADMINISTRATION_BUILDABLE_WITH, string);
    }

    public static void removeOption(EstateImpl estateImpl, Option option) {
        BuildableWith.removeOption(estateImpl, OpenEstateAttrib.ADMINISTRATION_BUILDABLE_WITH, option);
    }

    public static void removeOption(EstateImpl estateImpl, String string) {
        BuildableWith.removeOption(estateImpl, OpenEstateAttrib.ADMINISTRATION_BUILDABLE_WITH, string);
    }

    public static enum Option implements Translatable
    {
        FARMLAND(I18n.marktr((String)"farmland")),
        DEVELOPMENT_AREA(I18n.marktr((String)"greenfield development")),
        JETTY(I18n.marktr((String)"jetty / pier")),
        OFFICE(I18n.marktr((String)"office")),
        CAMPING(I18n.marktr((String)"camping")),
        DUPLEX_HOUSE(I18n.marktr((String)"duplex house")),
        SINGLE_FAMILY_HOUSE(I18n.marktr((String)"single-family house")),
        RETAIL_LARGE(I18n.marktr((String)"large retail")),
        RETAIL_SMALL(I18n.marktr((String)"small retail unit")),
        GARAGE(I18n.marktr((String)"garage")),
        GARDEN(I18n.marktr((String)"garden")),
        GASTRONOMY(I18n.marktr((String)"catering business")),
        BUSINESS_BIG(I18n.marktr((String)"commercial")),
        HOTEL(I18n.marktr((String)"hotel")),
        INDUSTRY(I18n.marktr((String)"industry")),
        NO_DEVELOPMENT(I18n.marktr((String)"no development")),
        BUSINESS_SMALL(I18n.marktr((String)"small business")),
        WAREHOUSE(I18n.marktr((String)"warehouse")),
        MULTI_FAMILY_HOUSE(I18n.marktr((String)"multi-family house")),
        FRUIT_PLANTING(I18n.marktr((String)"fruit planting")),
        PARKING_STRUCTURE(I18n.marktr((String)"parking structure")),
        PRODUCTION(I18n.marktr((String)"production")),
        TERRACED_HOUSE(I18n.marktr((String)"terraced house")),
        CAR_PARKING_SPACES(I18n.marktr((String)"car parking spaces")),
        VILLA(I18n.marktr((String)"villa")),
        FOREST(I18n.marktr((String)"forest"));

        private final String i18nKey;

        private Option(String string2) {
            this.i18nKey = string2;
        }

        @Override
        public String getTranslation() {
            return this.getTranslation(null);
        }

        @Override
        public String getTranslation(Locale locale) {
            return OpenEstateUtils.getI18nString(this.i18nKey, locale);
        }
    }
}

