/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.db;

import com.openindex.openestate.impl.GeoCountryImpl;
import com.openindex.openestate.impl.GeoImpl;
import com.openindex.openestate.impl.db.DbGeoCountry;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbGeo
implements Serializable {
    private static final long serialVersionUID = -561960341188332543L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DbGeo.class);
    public long id = 0L;
    public String name = null;
    public String provider = null;
    public Date buildTime = null;
    public Date createdAt = null;
    public Date modifiedAt = null;
    public List<DbGeoCountry> countries = null;

    public static DbGeo createFromXml(GeoImpl geoImpl) {
        if (geoImpl == null) {
            return null;
        }
        DbGeo dbGeo = new DbGeo();
        dbGeo.buildTime = geoImpl.getBuildTime();
        dbGeo.name = geoImpl.getName();
        dbGeo.provider = geoImpl.getProvider();
        dbGeo.countries = new ArrayList<DbGeoCountry>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GeoCountryImpl geoCountryImpl : geoImpl.getCountries()) {
            String string;
            if (geoCountryImpl.getIsoCode() == null || arrayList.contains(string = geoCountryImpl.getIsoCode().toLowerCase())) continue;
            dbGeo.countries.add(DbGeoCountry.createFromXml(geoCountryImpl));
            arrayList.add(string);
        }
        return dbGeo;
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass().equals(object.getClass())) {
            DbGeo dbGeo = (DbGeo)object;
            if (this.id > 0L && dbGeo.id == this.id) {
                return true;
            }
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = 0;
        n += Long.valueOf(this.id).hashCode();
        if (this.name != null) {
            n += this.name.hashCode();
        }
        if (this.provider != null) {
            n += this.provider.hashCode();
        }
        if (this.buildTime != null) {
            n += this.buildTime.hashCode();
        }
        return n;
    }
}

