/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.db;

import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.GeoAreaLevel;
import com.openindex.openestate.impl.db.DbGeo;
import com.openindex.openestate.impl.db.DbGeoCountry;
import com.openindex.openestate.impl.db.DbGeoHandler;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbGeoArea
implements Serializable {
    private static final long serialVersionUID = 1431376868418666495L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DbGeoArea.class);
    public long id = 0L;
    public long countryId = 0L;
    public long parentAreaId = 0L;
    public String name = null;
    public String providerId = null;
    public GeoAreaLevel level = null;
    public DbGeo geo = null;
    public DbGeoCountry country = null;
    public DbGeoArea parentArea = null;
    public List<DbGeoArea> childAreas = null;

    public static DbGeoArea createFromXml(GeoAreaImpl geoAreaImpl) {
        DbGeoArea dbGeoArea = new DbGeoArea();
        dbGeoArea.name = geoAreaImpl.getName();
        dbGeoArea.level = geoAreaImpl.getLevel();
        dbGeoArea.providerId = geoAreaImpl.getProviderId();
        dbGeoArea.childAreas = new ArrayList<DbGeoArea>();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (GeoAreaImpl geoAreaImpl2 : geoAreaImpl.getAreas()) {
            String string;
            if (geoAreaImpl2.getName() == null || arrayList.contains(string = geoAreaImpl2.getName().toLowerCase())) continue;
            arrayList.add(string);
            String string2 = geoAreaImpl2.getProviderId();
            if (string2 != null && string2.trim().length() > 0) {
                if (arrayList2.contains(string2)) continue;
                arrayList2.add(string2);
            }
            dbGeoArea.childAreas.add(DbGeoArea.createFromXml(geoAreaImpl2));
        }
        return dbGeoArea;
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass().equals(object.getClass())) {
            DbGeoArea dbGeoArea = (DbGeoArea)object;
            if (this.id > 0L && dbGeoArea.id == this.id) {
                return true;
            }
        }
        return super.equals(object);
    }

    public DbGeoArea[] getChildAreas(boolean bl) {
        if (this.childAreas == null) {
            return null;
        }
        ArrayList<DbGeoArea> arrayList = new ArrayList<DbGeoArea>();
        if (bl) {
            for (DbGeoArea dbGeoArea : this.childAreas) {
                arrayList.add(dbGeoArea);
                DbGeoArea[] dbGeoAreaArray = dbGeoArea.getChildAreas(true);
                if (dbGeoAreaArray == null) continue;
                arrayList.addAll(Arrays.asList(dbGeoAreaArray));
            }
        } else {
            arrayList.addAll(this.childAreas);
        }
        return arrayList.toArray(new DbGeoArea[0]);
    }

    public DbGeoArea[] getPath(Connection connection, DbGeoHandler dbGeoHandler) throws SQLException {
        ArrayList<DbGeoArea> arrayList = new ArrayList<DbGeoArea>();
        if (this.parentAreaId > 0L) {
            DbGeoArea dbGeoArea = dbGeoHandler.getGeoArea(connection, this.parentAreaId);
            arrayList.addAll(Arrays.asList(dbGeoArea.getPath(connection, dbGeoHandler)));
        }
        arrayList.add(this);
        return arrayList.toArray(new DbGeoArea[0]);
    }

    public int hashCode() {
        int n = 0;
        n += Long.valueOf(this.id).hashCode();
        n += Long.valueOf(this.countryId).hashCode();
        n += Long.valueOf(this.parentAreaId).hashCode();
        if (this.name != null) {
            n += this.name.hashCode();
        }
        if (this.providerId != null) {
            n += this.providerId.hashCode();
        }
        if (this.level != null) {
            n += this.level.hashCode();
        }
        return n;
    }
}

