/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.db;

import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.GeoCountryImpl;
import com.openindex.openestate.impl.db.DbGeo;
import com.openindex.openestate.impl.db.DbGeoArea;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD", "UWF_NULL_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbGeoCountry
implements Serializable {
    private static final long serialVersionUID = 8961764083513811043L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DbGeoCountry.class);
    public long id = 0L;
    public long geoId = 0L;
    public Locale locale = null;
    public String name = null;
    public String providerId = null;
    public DbGeo geo = null;
    public List<DbGeoArea> areas = null;

    public static DbGeoCountry createFromXml(GeoCountryImpl geoCountryImpl) {
        if (geoCountryImpl == null) {
            return null;
        }
        DbGeoCountry dbGeoCountry = new DbGeoCountry();
        dbGeoCountry.name = geoCountryImpl.getName();
        dbGeoCountry.locale = new Locale("", geoCountryImpl.getIsoCode().toUpperCase());
        dbGeoCountry.providerId = geoCountryImpl.getProviderId();
        dbGeoCountry.areas = new ArrayList<DbGeoArea>();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (GeoAreaImpl geoAreaImpl : geoCountryImpl.getAreas()) {
            String string;
            if (geoAreaImpl.getName() == null || arrayList.contains(string = geoAreaImpl.getName().toLowerCase())) continue;
            arrayList.add(string);
            String string2 = geoAreaImpl.getProviderId();
            if (string2 != null && string2.trim().length() > 0) {
                if (arrayList2.contains(string2)) continue;
                arrayList2.add(string2);
            }
            dbGeoCountry.areas.add(DbGeoArea.createFromXml(geoAreaImpl));
        }
        return dbGeoCountry;
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass().equals(object.getClass())) {
            DbGeoCountry dbGeoCountry = (DbGeoCountry)object;
            if (this.id > 0L && dbGeoCountry.id == this.id) {
                return true;
            }
        }
        return super.equals(object);
    }

    public DbGeoArea[] getChildAreas(boolean bl) {
        if (this.areas == null) {
            return null;
        }
        ArrayList<DbGeoArea> arrayList = new ArrayList<DbGeoArea>();
        for (DbGeoArea dbGeoArea : this.areas) {
            arrayList.add(dbGeoArea);
            if (!bl || dbGeoArea.childAreas == null) continue;
            arrayList.addAll(Arrays.asList(dbGeoArea.getChildAreas(true)));
        }
        return arrayList.toArray(new DbGeoArea[0]);
    }

    public int hashCode() {
        int n = 0;
        n += Long.valueOf(this.id).hashCode();
        n += Long.valueOf(this.geoId).hashCode();
        if (this.locale != null) {
            n += this.locale.hashCode();
        }
        if (this.name != null) {
            n += this.name.hashCode();
        }
        if (this.providerId != null) {
            n += this.providerId.hashCode();
        }
        return n;
    }
}

