/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.utils;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.utils.AbstractConverter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.openestate.io.core.XmlDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXmlWriter<DocType extends XmlDocument, XmlType>
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractXmlWriter.class);
    private String xmlLineSeparator = "<br/>";

    protected abstract XmlType convertToXmlObject(AgencyImpl var1);

    protected abstract XmlType convertToXmlObject(TransferImpl var1);

    protected abstract DocType createXmlDocument(XmlType var1) throws ParserConfigurationException, JAXBException;

    public String getXmlLineSeparator() {
        return this.xmlLineSeparator;
    }

    public void setXmlLineSeparator(String string) {
        if (string == null) {
            throw new NullPointerException("line-separator may not be null!");
        }
        this.xmlLineSeparator = string;
    }

    public final void write(AgencyImpl agencyImpl, File file) throws TransformerException, IOException, ParserConfigurationException, JAXBException {
        this.write(agencyImpl, file, true);
    }

    public void write(AgencyImpl agencyImpl, File file, boolean bl) throws TransformerException, IOException, ParserConfigurationException, JAXBException {
        this.getErrorMap().clear();
        XmlType XmlType = this.convertToXmlObject(agencyImpl);
        if (XmlType == null) {
            throw new IOException("Can't convert agency into a XML object!");
        }
        DocType DocType = this.createXmlDocument(XmlType);
        if (DocType == null) {
            throw new IOException("Can't create XML document for the agency!");
        }
        DocType.toXml(file, bl);
    }

    public final void write(AgencyImpl agencyImpl, OutputStream outputStream) throws TransformerException, IOException, ParserConfigurationException, JAXBException {
        this.write(agencyImpl, outputStream, true);
    }

    public void write(AgencyImpl agencyImpl, OutputStream outputStream, boolean bl) throws TransformerException, IOException, ParserConfigurationException, JAXBException {
        this.getErrorMap().clear();
        XmlType XmlType = this.convertToXmlObject(agencyImpl);
        if (XmlType == null) {
            throw new IOException("Can't convert agency into a XML object!");
        }
        DocType DocType = this.createXmlDocument(XmlType);
        if (DocType == null) {
            throw new IOException("Can't create XML document for the agency!");
        }
        DocType.toXml(outputStream, bl);
    }

    public final void write(AgencyImpl agencyImpl, Writer writer) throws TransformerException, IOException, ParserConfigurationException, JAXBException {
        this.write(agencyImpl, writer, true);
    }

    public void write(AgencyImpl agencyImpl, Writer writer, boolean bl) throws TransformerException, IOException, ParserConfigurationException, JAXBException {
        this.getErrorMap().clear();
        XmlType XmlType = this.convertToXmlObject(agencyImpl);
        if (XmlType == null) {
            throw new IOException("Can't convert agency into a XML object!");
        }
        DocType DocType = this.createXmlDocument(XmlType);
        if (DocType == null) {
            throw new IOException("Can't create XML document for the agency!");
        }
        DocType.toXml(writer, bl);
    }

    public final void write(TransferImpl transferImpl, File file) throws TransformerException, IOException, ParserConfigurationException, JAXBException {
        this.write(transferImpl, file, true);
    }

    public void write(TransferImpl transferImpl, File file, boolean bl) throws TransformerException, IOException, ParserConfigurationException, JAXBException {
        this.getErrorMap().clear();
        XmlType XmlType = this.convertToXmlObject(transferImpl);
        if (XmlType == null) {
            throw new IOException("Can't convert transfer into a XML object!");
        }
        DocType DocType = this.createXmlDocument(XmlType);
        if (DocType == null) {
            throw new IOException("Can't create XML document for the transfer!");
        }
        DocType.toXml(file, bl);
    }

    public final void write(TransferImpl transferImpl, OutputStream outputStream) throws TransformerException, IOException, ParserConfigurationException, JAXBException {
        this.write(transferImpl, outputStream, true);
    }

    public void write(TransferImpl transferImpl, OutputStream outputStream, boolean bl) throws TransformerException, IOException, ParserConfigurationException, JAXBException {
        this.getErrorMap().clear();
        XmlType XmlType = this.convertToXmlObject(transferImpl);
        if (XmlType == null) {
            throw new IOException("Can't convert transfer into a XML object!");
        }
        DocType DocType = this.createXmlDocument(XmlType);
        if (DocType == null) {
            throw new IOException("Can't create XML document for the transfer!");
        }
        DocType.toXml(outputStream, bl);
    }

    public final void write(TransferImpl transferImpl, Writer writer) throws TransformerException, IOException, ParserConfigurationException, JAXBException {
        this.write(transferImpl, writer, true);
    }

    public void write(TransferImpl transferImpl, Writer writer, boolean bl) throws TransformerException, IOException, ParserConfigurationException, JAXBException {
        this.getErrorMap().clear();
        XmlType XmlType = this.convertToXmlObject(transferImpl);
        if (XmlType == null) {
            throw new IOException("Can't convert transfer into a XML object!");
        }
        DocType DocType = this.createXmlDocument(XmlType);
        if (DocType == null) {
            throw new IOException("Can't create XML document for the transfer!");
        }
        DocType.toXml(writer, bl);
    }

    public XmlType writeToObject(AgencyImpl agencyImpl) {
        this.getErrorMap().clear();
        return this.convertToXmlObject(agencyImpl);
    }

    public XmlType writeToObject(TransferImpl transferImpl) {
        this.getErrorMap().clear();
        return this.convertToXmlObject(transferImpl);
    }

    public final String writeToString(AgencyImpl agencyImpl) throws TransformerException, IOException, ParserConfigurationException, JAXBException {
        return this.writeToString(agencyImpl, true);
    }

    public final String writeToString(AgencyImpl agencyImpl, boolean bl) throws TransformerException, IOException, ParserConfigurationException, JAXBException {
        try (StringWriter stringWriter = new StringWriter();){
            this.write(agencyImpl, (Writer)stringWriter, bl);
            String string = ((Object)stringWriter).toString();
            return string;
        }
    }

    public final String writeToString(TransferImpl transferImpl) throws TransformerException, IOException, ParserConfigurationException, JAXBException {
        return this.writeToString(transferImpl, true);
    }

    public final String writeToString(TransferImpl transferImpl, boolean bl) throws TransformerException, IOException, ParserConfigurationException, JAXBException {
        try (StringWriter stringWriter = new StringWriter();){
            this.write(transferImpl, (Writer)stringWriter, bl);
            String string = ((Object)stringWriter).toString();
            return string;
        }
    }
}

