/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.values;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.values.UnitValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Currency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrencyValue
extends Number
implements UnitValue<Currency>,
Comparable<CurrencyValue> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CurrencyValue.class);
    private BigDecimal value;
    private Currency currency;

    public CurrencyValue() {
        this(null, null);
    }

    public CurrencyValue(BigDecimal bigDecimal, Currency currency) {
        this.value = bigDecimal;
        this.currency = currency != null ? currency : Currency.getInstance("EUR");
    }

    @Override
    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"}, justification="Comparison does not use equals() - possibly a bug in FindBugs.")
    public int compareTo(CurrencyValue currencyValue) {
        if (currencyValue == null) {
            return -1;
        }
        BigDecimal bigDecimal = this.getValue();
        BigDecimal bigDecimal2 = currencyValue.getValue();
        if (bigDecimal == null && bigDecimal2 == null) {
            return 0;
        }
        if (bigDecimal == null) {
            return 1;
        }
        if (bigDecimal2 == null) {
            return -1;
        }
        return bigDecimal.compareTo(bigDecimal2);
    }

    @Override
    public double doubleValue() {
        if (this.value == null) {
            throw new NullPointerException("Unknown value!");
        }
        return this.value.doubleValue();
    }

    @Override
    public float floatValue() {
        if (this.value == null) {
            throw new NullPointerException("Unknown value!");
        }
        return this.value.floatValue();
    }

    @Deprecated
    public Currency getCurrency() {
        return this.getUnit();
    }

    @Override
    public Currency getUnit() {
        return this.currency;
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        if (this.value == null) {
            throw new NullPointerException("Unknown value!");
        }
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        if (this.value == null) {
            throw new NullPointerException("Unknown value!");
        }
        return this.value.longValue();
    }

    public static CurrencyValue parse(Object object) {
        return CurrencyValue.parse(object, null);
    }

    public static CurrencyValue parse(Object object, Currency currency) {
        if (object instanceof CurrencyValue) {
            return (CurrencyValue)object;
        }
        if (currency == null) {
            currency = Currency.getInstance("EUR");
        }
        if (object instanceof String) {
            object = OpenEstateUtils.parseNumber((String)object);
        }
        if (object instanceof BigDecimal) {
            return new CurrencyValue((BigDecimal)object, currency);
        }
        if (object instanceof BigInteger) {
            return new CurrencyValue(BigDecimal.valueOf(((Number)object).longValue()), currency);
        }
        if (object instanceof Long) {
            return new CurrencyValue(BigDecimal.valueOf(((Number)object).longValue()), currency);
        }
        if (object instanceof Integer) {
            return new CurrencyValue(BigDecimal.valueOf(((Number)object).longValue()), currency);
        }
        if (object instanceof Number) {
            return new CurrencyValue(BigDecimal.valueOf(((Number)object).doubleValue()), currency);
        }
        return null;
    }

    @Deprecated
    public void setCurrency(Currency currency) {
        this.setUnit(currency);
    }

    @Override
    public void setUnit(Currency currency) {
        this.currency = currency;
    }

    @Override
    public void setValue(BigDecimal bigDecimal) {
        this.value = bigDecimal;
    }

    public String toString() {
        return this.value != null ? this.value.toString() : "null";
    }
}

