/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.values;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.values.UnitValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LengthValue
extends Number
implements UnitValue<Unit>,
Comparable<LengthValue> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LengthValue.class);
    private BigDecimal value;
    private Unit unit;

    public LengthValue() {
        this(null, null);
    }

    public LengthValue(BigDecimal bigDecimal, Unit unit) {
        this.value = bigDecimal;
        this.unit = unit != null ? unit : Unit.getBaseUnit();
    }

    @Override
    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"}, justification="Comparison does not use equals() - possibly a bug in FindBugs.")
    public int compareTo(LengthValue lengthValue) {
        Unit unit;
        if (lengthValue == null) {
            return -1;
        }
        BigDecimal bigDecimal = this.getValue();
        BigDecimal bigDecimal2 = lengthValue.getValue();
        if (bigDecimal == null && bigDecimal2 == null) {
            return 0;
        }
        if (bigDecimal == null) {
            return 1;
        }
        if (bigDecimal2 == null) {
            return -1;
        }
        Unit unit2 = this.getUnit();
        if (unit2 == null) {
            unit2 = Unit.getBaseUnit();
        }
        if ((unit = lengthValue.getUnit()) == null) {
            unit = Unit.getBaseUnit();
        }
        if (unit2 != unit) {
            bigDecimal2 = LengthValue.convert(bigDecimal2, unit, unit2);
        }
        return bigDecimal.compareTo(bigDecimal2);
    }

    public static BigDecimal convert(LengthValue lengthValue, Unit unit) {
        return LengthValue.convert(lengthValue.getValue(), lengthValue.getUnit(), unit);
    }

    public static BigDecimal convert(BigDecimal bigDecimal, Unit unit, Unit unit2) {
        if (unit == null) {
            throw new IllegalArgumentException("Invalid source unit!");
        }
        if (unit2 == null) {
            throw new IllegalArgumentException("Invalid target unit!");
        }
        if (unit == unit2) {
            return bigDecimal;
        }
        MathContext mathContext = new MathContext(10, RoundingMode.HALF_UP);
        BigDecimal bigDecimal2 = unit.getBaseUnitFactor();
        if (bigDecimal2.compareTo(BigDecimal.ZERO) < 1) {
            throw new IllegalArgumentException("An invalid source unit was provided!");
        }
        BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2, mathContext);
        if (Unit.getBaseUnit() == unit2) {
            return bigDecimal3;
        }
        BigDecimal bigDecimal4 = unit2.getBaseUnitFactor();
        if (bigDecimal4.compareTo(BigDecimal.ZERO) < 1) {
            throw new IllegalArgumentException("An invalid target unit was provided!");
        }
        return bigDecimal3.divide(bigDecimal4, mathContext);
    }

    @Override
    public double doubleValue() {
        if (this.value == null) {
            throw new NullPointerException("Unknown value!");
        }
        return this.value.doubleValue();
    }

    @Override
    public float floatValue() {
        if (this.value == null) {
            throw new NullPointerException("Unknown value!");
        }
        return this.value.floatValue();
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        if (this.value == null) {
            throw new NullPointerException("Unknown value!");
        }
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        if (this.value == null) {
            throw new NullPointerException("Unknown value!");
        }
        return this.value.longValue();
    }

    public static LengthValue parse(Object object) {
        return LengthValue.parse(object, null);
    }

    public static LengthValue parse(Object object, Unit unit) {
        if (object instanceof LengthValue) {
            return (LengthValue)object;
        }
        if (unit == null) {
            unit = Unit.getBaseUnit();
        }
        if (object instanceof String) {
            object = OpenEstateUtils.parseNumber((String)object);
        }
        if (object instanceof BigDecimal) {
            return new LengthValue((BigDecimal)object, unit);
        }
        if (object instanceof BigInteger) {
            return new LengthValue(BigDecimal.valueOf(((Number)object).longValue()), unit);
        }
        if (object instanceof Long) {
            return new LengthValue(BigDecimal.valueOf(((Number)object).longValue()), unit);
        }
        if (object instanceof Integer) {
            return new LengthValue(BigDecimal.valueOf(((Number)object).longValue()), unit);
        }
        if (object instanceof Number) {
            return new LengthValue(BigDecimal.valueOf(((Number)object).doubleValue()), unit);
        }
        return null;
    }

    @Override
    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    @Override
    public void setValue(BigDecimal bigDecimal) {
        this.value = bigDecimal;
    }

    public String toString() {
        return this.value != null ? this.value.toString() : "null";
    }

    public static enum Unit {
        MM,
        CM,
        DM,
        M,
        KM,
        IN,
        FT,
        YD,
        MI;


        public static Unit getBaseUnit() {
            return M;
        }

        public BigDecimal getBaseUnitFactor() {
            switch (this) {
                case MM: {
                    return new BigDecimal("1e-4");
                }
                case CM: {
                    return new BigDecimal("1e-2");
                }
                case DM: {
                    return new BigDecimal("1e-1");
                }
                case M: {
                    return BigDecimal.ONE;
                }
                case KM: {
                    return new BigDecimal("1e3");
                }
                case IN: {
                    return new BigDecimal("0.0254");
                }
                case FT: {
                    return new BigDecimal("0.3048");
                }
                case YD: {
                    return new BigDecimal("0.9144");
                }
                case MI: {
                    return new BigDecimal("1609.344");
                }
            }
            return BigDecimal.ZERO;
        }

        public String toString() {
            return this.write();
        }

        public String write() {
            switch (this) {
                case M: {
                    return "m";
                }
                case KM: {
                    return "km";
                }
                case DM: {
                    return "dm";
                }
                case CM: {
                    return "cm";
                }
                case MM: {
                    return "mm";
                }
                case IN: {
                    return "in";
                }
                case FT: {
                    return "ft";
                }
                case YD: {
                    return "yd";
                }
                case MI: {
                    return "mi";
                }
            }
            return null;
        }
    }
}

