/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.exception;

import java.awt.Frame;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JDialog;
import org.bushe.swing.exception.ExceptionDialog;

public class AWTExceptionHandler {
    private static String emailAddress;
    private static AWTErrorLogger logger;

    public static String getErrorEmailAddress() {
        return emailAddress;
    }

    public static void setErrorEmailAddress(String emailAddy) {
        emailAddress = emailAddy;
    }

    public static void setLogger(AWTErrorLogger logger) {
        AWTExceptionHandler.logger = logger;
    }

    public void handle(Throwable t) {
        Frame f = this.getFrameForMessageDialog();
        if (f == null) {
            this.handleThrowableWithoutFrame(t);
        } else {
            this.handleThrowableWithFrame(f, t);
        }
    }

    protected void handleThrowableWithoutFrame(Throwable t) {
        this.logError(t);
    }

    protected void handleThrowableWithFrame(Frame f, Throwable t) {
        this.logError(t);
        JDialog dialog = this.createErrorDialog(f, t);
        dialog.pack();
        dialog.setVisible(true);
    }

    protected void logError(Throwable t) {
        if (logger == null) {
            System.err.println(t);
            t.printStackTrace(System.err);
        } else {
            logger.log(t);
        }
    }

    protected JDialog createErrorDialog(Frame f, Throwable t) {
        return new ExceptionDialog(f, t, false);
    }

    protected Frame getFrameForMessageDialog() {
        Frame f = null;
        Frame[] frames = Frame.getFrames();
        if (frames != null && frames.length > 0) {
            f = frames[0];
        }
        return f;
    }

    public static String stackTraceToString(Throwable t) {
        if (t == null) {
            return "No stack trace available.";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.getBuffer().toString();
    }

    public static interface AWTErrorLogger {
        public void log(Throwable var1);
    }
}

