/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.bic;

public final class BicFormatException
extends RuntimeException {
    private final String inputString;

    private BicFormatException(String input, String message) {
        super(message);
        this.inputString = input;
    }

    static BicFormatException forNotProperlyFormattedInput(String input) {
        return new BicFormatException(input, String.format("'%s' format is not appropriate for a BIC", input));
    }

    static BicFormatException forUnknownCountryCode(String input) {
        return new BicFormatException(input, String.format("'%s' country code is unknown", input));
    }

    public String getInputString() {
        return this.inputString;
    }
}

