/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.core.ssl;

import com.openindex.openestate.tool.core.CoreUtils;
import com.openindex.openestate.tool.core.ssl.SavingTrustManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SSLUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSLUtils.class);

    public static void addCertificate(KeyStore keyStore, X509Certificate x509Certificate) throws KeyStoreException, InvalidNameException {
        ArrayList<String> arrayList = new ArrayList<String>(Collections.list(keyStore.aliases()));
        Map<String, String> map = SSLUtils.parseDN(x509Certificate.getSubjectX500Principal().toString());
        if (!map.containsKey("CN")) {
            throw new InvalidNameException("Can't load subject CN from certificate!");
        }
        String string = map.get("CN");
        int n = 0;
        while (arrayList.contains(string)) {
            string = map.get("CN") + "_" + ++n;
        }
        keyStore.setCertificateEntry(string, x509Certificate);
    }

    public static KeyStore createEmptyKeyStore() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return SSLUtils.loadKeyStore((InputStream)null, null);
    }

    public static boolean equals(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        if (x509Certificate == x509Certificate2) {
            return true;
        }
        if (x509Certificate == null || x509Certificate2 == null) {
            return false;
        }
        return x509Certificate.getIssuerX500Principal().toString().equals(x509Certificate2.getIssuerX500Principal().toString()) && x509Certificate.getSerialNumber().equals(x509Certificate2.getSerialNumber());
    }

    public static String getCertificateAlias(KeyStore keyStore, X509Certificate x509Certificate) {
        try {
            return keyStore.getCertificateAlias(x509Certificate);
        }
        catch (Exception exception) {
            LOGGER.warn("Can't lookup certificate in keystore!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public static X509Certificate[] getCertificateChain(String string) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        return SSLUtils.getCertificateChain(string, 443);
    }

    public static X509Certificate[] getCertificateChain(String string, int n) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        return SSLUtils.getCertificateChain(string, n, 20000);
    }

    public static X509Certificate[] getCertificateChain(String string, int n, int n2) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        SavingTrustManager savingTrustManager = new SavingTrustManager();
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(null, new TrustManager[]{savingTrustManager}, null);
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        try (SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n);){
            sSLSocket.setSoTimeout(n2);
            try {
                sSLSocket.startHandshake();
            }
            catch (SSLException sSLException) {
                // empty catch block
            }
        }
        return savingTrustManager.chain;
    }

    public static Map<String, X509Certificate> getCertificates(KeyStore keyStore) {
        TreeMap<String, X509Certificate> treeMap = new TreeMap<String, X509Certificate>();
        try {
            for (String string : Collections.list(keyStore.aliases())) {
                if (!keyStore.isCertificateEntry(string)) continue;
                treeMap.put(string, (X509Certificate)keyStore.getCertificate(string));
            }
            return null;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't lookup certificate in keystore!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return treeMap;
        }
    }

    public static X509TrustManager getCustomTrustManager(KeyStore keyStore) {
        TrustManagerFactory trustManagerFactory;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
        }
        catch (Exception exception) {
            LOGGER.warn("Can't init custom trust store!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        LOGGER.warn("Can't find custom trust store!");
        return null;
    }

    public static X509TrustManager getDefaultTrustManager() {
        TrustManagerFactory trustManagerFactory;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
        }
        catch (Exception exception) {
            LOGGER.warn("Can't init default trust store!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        LOGGER.warn("Can't find default trust store!");
        return null;
    }

    public static File getCustomTrustStoreFile() {
        return CoreUtils.getWorkDir("truststore.jks");
    }

    public static X509Certificate[] getExpiredCertificates(KeyStore keyStore) {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        try {
            for (String string : Collections.list(keyStore.aliases())) {
                if (!keyStore.isCertificateEntry(string)) continue;
                X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
                try {
                    x509Certificate.checkValidity();
                }
                catch (CertificateExpiredException certificateExpiredException) {
                    arrayList.add(x509Certificate);
                }
                catch (CertificateNotYetValidException certificateNotYetValidException) {}
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't lookup certificate in keystore!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return arrayList.toArray(new X509Certificate[0]);
    }

    public static Set<X509Certificate> getTrustedCertificates(KeyStore keyStore) {
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                Certificate[] certificateArray;
                String string = enumeration.nextElement();
                if (keyStore.isCertificateEntry(string)) {
                    certificateArray = keyStore.getCertificate(string);
                    if (!(certificateArray instanceof X509Certificate)) continue;
                    hashSet.add((X509Certificate)certificateArray);
                    continue;
                }
                if (!keyStore.isKeyEntry(string) || (certificateArray = keyStore.getCertificateChain(string)) == null || certificateArray.length <= 0 || !(certificateArray[0] instanceof X509Certificate)) continue;
                hashSet.add((X509Certificate)certificateArray[0]);
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return hashSet;
    }

    public static boolean hasTrustedCertificates(KeyStore keyStore) {
        HashSet hashSet = new HashSet();
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                Certificate[] certificateArray;
                String string = enumeration.nextElement();
                if (!(keyStore.isCertificateEntry(string) ? (certificateArray = keyStore.getCertificate(string)) instanceof X509Certificate : keyStore.isKeyEntry(string) && (certificateArray = keyStore.getCertificateChain(string)) != null && certificateArray.length > 0 && certificateArray[0] instanceof X509Certificate)) continue;
                return true;
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return false;
    }

    public static KeyStore loadKeyStore(File file, char[] cArray) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        if (file == null) {
            return SSLUtils.loadKeyStore((InputStream)null, null);
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            KeyStore keyStore = SSLUtils.loadKeyStore(fileInputStream, cArray);
            return keyStore;
        }
    }

    public static KeyStore loadKeyStore(InputStream inputStream, char[] cArray) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        if (inputStream != null) {
            keyStore.load(inputStream, cArray);
        } else {
            keyStore.load(null, null);
        }
        return keyStore;
    }

    public static Map<String, String> parseDN(String string) throws InvalidNameException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        LdapName ldapName = new LdapName(string);
        for (int i = 0; i < ldapName.size(); ++i) {
            Object object;
            Rdn rdn = ldapName.getRdn(i);
            String string2 = rdn.getType().toUpperCase().trim();
            if (hashMap.containsKey(string2) || !((object = rdn.getValue()) instanceof String)) continue;
            hashMap.put(string2, (String)object);
        }
        return hashMap;
    }

    public static void saveEmptyKeyStore(File file, char[] cArray) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        KeyStore keyStore = SSLUtils.createEmptyKeyStore();
        SSLUtils.saveKeyStore(keyStore, file, cArray);
    }

    public static void saveKeyStore(KeyStore keyStore, File file, char[] cArray) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            keyStore.store(fileOutputStream, cArray);
        }
    }

    public static void writeCertificate(Certificate certificate, File file, boolean bl) throws IOException, CertificateEncodingException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            if (bl) {
                SSLUtils.writeCertificateAsBinary(certificate, fileOutputStream);
            } else {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));
                SSLUtils.writeCertificateAsAscii(certificate, outputStreamWriter);
            }
        }
    }

    public static void writeCertificateAsAscii(Certificate certificate, Writer writer) throws IOException, CertificateEncodingException {
        writer.write("-----BEGIN CERTIFICATE-----\n");
        writer.write(new String(Base64.encodeBase64Chunked((byte[])certificate.getEncoded()), StandardCharsets.UTF_8));
        writer.write("\n-----END CERTIFICATE-----\n");
        writer.flush();
    }

    public static void writeCertificateAsBinary(Certificate certificate, OutputStream outputStream) throws IOException, CertificateEncodingException {
        outputStream.write(certificate.getEncoded());
        outputStream.flush();
    }

    public static String writeMD5FingerPrint(X509Certificate x509Certificate) throws CertificateEncodingException {
        return SSLUtils.writePrettifiedHex(DigestUtils.md5Hex((byte[])x509Certificate.getEncoded()));
    }

    private static String writePrettifiedHex(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; string.length() > i; i += 2) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(":");
            }
            stringBuilder.append(StringUtils.substring((String)string, (int)i, (int)(i + 2)).toUpperCase());
        }
        return stringBuilder.toString();
    }

    public static String writeSerialNumber(X509Certificate x509Certificate) {
        return SSLUtils.writePrettifiedHex(x509Certificate.getSerialNumber().toString(16));
    }

    public static String writeSHA1FingerPrint(X509Certificate x509Certificate) throws CertificateEncodingException {
        return SSLUtils.writePrettifiedHex(DigestUtils.sha1Hex((byte[])x509Certificate.getEncoded()));
    }

    public static String writeSHA256FingerPrint(X509Certificate x509Certificate) throws CertificateEncodingException {
        return SSLUtils.writePrettifiedHex(DigestUtils.sha256Hex((byte[])x509Certificate.getEncoded()));
    }
}

