/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.Calendar;
import bizcal.common.CalendarModel;
import bizcal.common.CalendarViewConfig;
import bizcal.common.Event;
import bizcal.swing.CalendarListener;
import bizcal.swing.ColumnHeaderPanel;
import bizcal.swing.PopupMenuCallback;
import bizcal.swing.util.ErrorHandler;
import bizcal.swing.util.FrameArea;
import bizcal.swing.util.GradientArea;
import bizcal.swing.util.LassoArea;
import bizcal.util.BizcalException;
import bizcal.util.DateInterval;
import bizcal.util.DateUtil;
import bizcal.util.TimeOfDay;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import lu.tudor.santec.bizcal.NamedCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CalendarView {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarView.class);
    public CalendarModel broker;
    protected CalendarListener listener;
    protected List<String> bottomCategories = new ArrayList<String>();
    protected PopupMenuCallback popupMenuCallback;
    private boolean visible = false;
    private Map<String, FrameArea> _frameAreaMap = new HashMap<String, FrameArea>();
    private Map<Object, List<Object>> _eventMap = new HashMap<Object, List<Object>>();
    private List<Event> _selectedEvents = new ArrayList<Event>();
    protected Font font;
    private LassoArea _lassoArea;
    private FrameArea _newEventArea;
    private JComponent _dragArea;
    private CalendarViewConfig desc;
    private static boolean draggingEnabled = true;
    private boolean isDragging = false;
    private boolean isCreating = false;
    private boolean isResizeing = false;
    private static FrameArea originalClickedFrameArea = null;
    private static final int LINE_OFFSET = 5;
    private static boolean isMousePressed = false;
    private static boolean isResizeable = false;
    private List<JLabel> vLines = new ArrayList<JLabel>();
    private List<JLabel> hLines = new ArrayList<JLabel>();
    Map<Event, FrameArea> frameAreaHash = Collections.synchronizedMap(new HashMap());
    private JComponent calPanel;
    private Date selectionDate;
    private NamedCalendar selectedCalendar;

    public CalendarView(CalendarViewConfig calendarViewConfig) throws Exception {
        this.desc = calendarViewConfig;
        this.font = calendarViewConfig.getFont();
    }

    protected LayoutManager getLayout() {
        return null;
    }

    public final void refresh() throws Exception {
        this._frameAreaMap.clear();
        this._eventMap.clear();
        try {
            this.refresh0();
        }
        catch (Exception exception) {
            LOGGER.error("Can't refresh calendar view.");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public abstract void refresh0() throws Exception;

    public void setBroker(CalendarModel calendarModel) throws Exception {
        this.broker = calendarModel;
    }

    public void setModel(CalendarModel calendarModel) {
        this.broker = calendarModel;
    }

    public void addListener(CalendarListener calendarListener) {
        this.listener = calendarListener;
    }

    public void addBottomCategory(String string) {
        this.bottomCategories.add(string);
    }

    protected void fireDateChanged(Date date) throws Exception {
        if (this.listener != null) {
            this.listener.dateChanged(date);
        }
    }

    protected DateInterval incDay(DateInterval dateInterval) throws Exception {
        DateInterval dateInterval2 = new DateInterval(DateUtil.move(dateInterval.getStartDate(), 1), DateUtil.move(dateInterval.getEndDate(), 1));
        return dateInterval2;
    }

    protected void fireDateSelected(Date date) throws Exception {
        if (this.listener != null) {
            this.listener.dateSelected(date);
        }
    }

    protected FrameArea createFrameArea(Object object, Event event) throws Exception {
        FrameArea frameArea = new FrameArea();
        frameArea.setEvent(event);
        String string = event.getSummary();
        if (string != null) {
            frameArea.setDescription(string);
        }
        DateFormat dateFormat = DateFormat.getTimeInstance(3, Locale.getDefault());
        StringBuffer stringBuffer = new StringBuffer();
        if (event.isShowTime()) {
            stringBuffer.append(dateFormat.format(event.getStart()) + "-" + dateFormat.format(event.getEnd()) + " ");
        }
        if (event.getSummary() != null) {
            stringBuffer.append(event.getSummary());
        }
        frameArea.setHeadLine(stringBuffer.toString());
        frameArea.setStartTime(event.getStart());
        frameArea.setEndTime(event.getEnd());
        if (event.getDescription() != null) {
            frameArea.setDescription(event.getDescription());
        }
        frameArea.setBackground(event.getColor());
        frameArea.setBorder(event.isFrame());
        frameArea.setBordercolor(event.getBordercolor());
        frameArea.setRoundedRectangle(event.isRoundedCorner());
        frameArea.showHeader(event.showHeader());
        FrameAreaMouseListener frameAreaMouseListener = new FrameAreaMouseListener(frameArea, object, event);
        frameArea.addMouseListener(frameAreaMouseListener);
        frameArea.addMouseMotionListener(frameAreaMouseListener);
        if (event.isEditable()) {
            frameArea.addKeyListener(new FrameAreaKeyListener(event));
        }
        frameArea.setToolTipText(event.getToolTip());
        frameArea.setIcon(event.getIcon());
        frameArea.setUpperRightIcon(event.getUpperRightIcon());
        frameArea.setCursor(new Cursor(12));
        try {
            frameArea.setLineDistance((Integer)event.get("linedistance"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        frameArea.setSelected(this.isSelected(event));
        this.register(object, event, frameArea);
        return frameArea;
    }

    protected void showEventpopup(MouseEvent mouseEvent, Object object, Event event) throws Exception {
        if (this.popupMenuCallback == null) {
            return;
        }
        JPopupMenu jPopupMenu = this.popupMenuCallback.getEventPopupMenu(object, event);
        if (jPopupMenu == null) {
            return;
        }
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        jPopupMenu.setVisible(true);
    }

    protected void showEmptyPopup(MouseEvent mouseEvent, Object object) throws Exception {
        if (this.popupMenuCallback == null) {
            return;
        }
        Date date = this.getDate(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        JPopupMenu jPopupMenu = this.popupMenuCallback.getEmptyPopupMenu(object, date);
        if (jPopupMenu != null) {
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void setPopupMenuCallback(PopupMenuCallback popupMenuCallback) {
        this.popupMenuCallback = popupMenuCallback;
    }

    public int getTimeSlotHeight() {
        if (this.hLines != null) {
            Integer n = null;
            Integer n2 = null;
            for (JLabel jLabel : this.hLines) {
                if (jLabel.getY() <= 0) continue;
                if (n == null) {
                    n = jLabel.getY();
                    continue;
                }
                n2 = jLabel.getY();
                break;
            }
            if (n != null && n2 != null) {
                return -1 * (n - n2);
            }
        }
        return -1;
    }

    private int getColumnWidth() {
        if (this.vLines != null) {
            if (this.vLines.size() > 0) {
                return this.vLines.get(0).getX();
            }
            return this.calPanel.getWidth();
        }
        return -1;
    }

    public Date getSelectionDate() {
        return this.selectionDate;
    }

    private void setSelectionDate(int n, int n2) {
        try {
            this.setSelectionDate(this.getDate(n, n2));
        }
        catch (Exception exception) {
            LOGGER.error("Can't set selection date.");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private void setSelectionDate(Date date) {
        this.selectionDate = date;
        try {
            this.fireDateSelected(this.selectionDate);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected abstract Date getDate(int var1, int var2) throws Exception;

    private synchronized FrameArea findLastFrameArea(FrameArea frameArea) {
        if (frameArea.getChildren() == null || frameArea.getChildren().size() < 1) {
            return null;
        }
        return frameArea.getChildren().get(frameArea.getChildren().size() - 1);
    }

    private int findNextGreaterHorizontalLinePos(int n) {
        if (this.hLines == null) {
            return -1;
        }
        int n2 = 100000000;
        for (JLabel jLabel : this.hLines) {
            if (jLabel.getY() <= n || jLabel.getY() >= n2) continue;
            n2 = jLabel.getY();
        }
        if (n2 == 100000000) {
            return -1;
        }
        return n2;
    }

    private int findNextSmallerHorizontalLinePos(int n) {
        if (this.hLines == null) {
            return -1;
        }
        if (n < this.getTimeSlotHeight()) {
            return this.calPanel.getY();
        }
        int n2 = this.calPanel.getHeight();
        for (JLabel jLabel : this.hLines) {
            if (jLabel.getY() >= n2 || jLabel.getY() < n - this.getTimeSlotHeight()) continue;
            n2 = jLabel.getY();
        }
        return n2;
    }

    private List<Integer> findUndrawnLines(int n, int n2, Integer n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (n2 > n) {
            for (JLabel jLabel : this.vLines) {
                if (jLabel.getX() <= n3 || jLabel.getX() >= n2 || arrayList.contains(jLabel.getX())) continue;
                arrayList.add(jLabel.getX());
            }
        }
        return arrayList;
    }

    private int findNextGreaterVerticalLine(int n) {
        if (this.vLines != null) {
            int n2 = this.calPanel.getWidth();
            for (JLabel jLabel : this.vLines) {
                if (jLabel.getX() <= n || jLabel.getX() >= n2) continue;
                n2 = jLabel.getX();
            }
            return n2;
        }
        return -1;
    }

    private int findNextSmallerVerticalLine(int n) {
        if (this.vLines != null) {
            int n2 = -1;
            for (JLabel jLabel : this.vLines) {
                if (jLabel.getX() >= n || jLabel.getX() <= n2) continue;
                n2 = jLabel.getX();
            }
            return n2;
        }
        return -1;
    }

    private JLabel findSmallestLine() {
        if (this.vLines == null) {
            return null;
        }
        if (this.vLines.size() == 0) {
            JLabel jLabel = new JLabel();
            jLabel.setBounds(this.calPanel.getWidth(), 0, 0, 0);
            this.vLines.add(jLabel);
            return jLabel;
        }
        if (this.vLines.size() == 1) {
            this.vLines.get(0).setBounds(this.calPanel.getWidth(), 0, 0, 0);
        }
        JLabel jLabel = this.vLines.get(0);
        for (JLabel jLabel2 : this.vLines) {
            if (jLabel2.getX() >= jLabel.getX()) continue;
            jLabel = jLabel2;
        }
        return jLabel;
    }

    public void addVerticalLine(JLabel jLabel) {
        this.vLines.add(jLabel);
    }

    public void resetVerticalLines() {
        this.vLines.clear();
    }

    public void addHorizontalLine(JLabel jLabel) {
        this.hLines.add(jLabel);
    }

    public void resetHorizontalLines() {
        this.hLines.clear();
    }

    protected void addDraggingComponents(JComponent jComponent) throws Exception {
        this._lassoArea = new LassoArea();
        jComponent.add((Component)this._lassoArea, 1000);
        this._newEventArea = new FrameArea();
        this._newEventArea.setRoundedRectangle(false);
        this._newEventArea.setVisible(false);
        jComponent.add((Component)this._newEventArea, (Object)2);
        this.calPanel = jComponent;
    }

    protected Object getCalendarId(int n, int n2) throws Exception {
        return null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) throws Exception {
        this.visible = bl;
        if (bl) {
            this.refresh();
        }
    }

    protected int getXOffset() {
        return 0;
    }

    protected int getCaptionRowHeight() {
        return 0;
    }

    public void setCursor(Cursor cursor) {
        this.getComponent().setCursor(cursor);
    }

    protected void register(Object object, Event event, FrameArea frameArea) {
        this._frameAreaMap.put("" + object + event.getId() + event.getStart().getTime(), frameArea);
        List<Object> list = this._eventMap.get(object);
        if (list == null) {
            list = new ArrayList<Object>();
            this._eventMap.put(object, list);
        }
        list.add(event);
    }

    protected FrameArea getFrameArea(Object object, Event event) {
        return this._frameAreaMap.get("" + object + event.getId() + event.getStart().getTime());
    }

    public void select(Object object, Event event, boolean bl) throws Exception {
        FrameArea frameArea = this.frameAreaHash.get(event);
        if (frameArea != null) {
            frameArea.setSelected(bl);
            if (frameArea.getChildren() != null) {
                for (FrameArea frameArea2 : frameArea.getChildren()) {
                    frameArea2.setSelected(true);
                }
            }
        }
        if (bl) {
            if (!this._selectedEvents.contains(event)) {
                this._selectedEvents.add(event);
            }
        } else {
            this._selectedEvents.remove(event);
        }
        if (this.listener != null) {
            this.listener.eventsSelected(this._selectedEvents);
            this.listener.eventSelected(object, event);
        }
        this.setSelectionDate(event.getStart());
    }

    public void deselect() throws Exception {
        this._selectedEvents.clear();
        for (Calendar calendar : this.broker.getSelectedCalendars()) {
            Object object = calendar.getId();
            List<Object> list = this._eventMap.get(object);
            if (list == null) {
                return;
            }
            for (Event event : list) {
                FrameArea frameArea = this.frameAreaHash.get(event);
                if (frameArea == null) continue;
                frameArea.setSelected(false);
                if (frameArea.getChildren() == null) continue;
                for (FrameArea frameArea2 : frameArea.getChildren()) {
                    frameArea2.setSelected(false);
                }
            }
        }
        if (this.listener != null) {
            this.listener.eventsSelected(this._selectedEvents);
            this.listener.selectionReset();
        }
        this.calPanel.requestFocus();
    }

    public void copy() throws Exception {
        if (this.listener != null) {
            this.listener.copy(this._selectedEvents);
        }
    }

    protected boolean supportsDrag() {
        return true;
    }

    private void lasso(Object object, Date date, Date date2) throws Exception {
        Serializable serializable;
        this.deselect();
        if (DateUtil.round2Day(date).getTime() != DateUtil.round2Day(date2).getTime()) {
            TimeOfDay timeOfDay = DateUtil.getTimeOfDay(date);
            TimeOfDay comparable = DateUtil.getTimeOfDay(date2);
            serializable = date;
            while (true) {
                Date date3 = DateUtil.setTimeOfDate((Date)serializable, timeOfDay);
                Date date4 = DateUtil.setTimeOfDate((Date)serializable, comparable);
                if (!date4.after(date2)) {
                    this._selectedEvents.addAll(this.getEditibleEvents(object, new DateInterval(date3, date4)));
                    serializable = DateUtil.getDiffDay((Date)serializable, 1);
                    continue;
                }
                break;
            }
        } else {
            this._selectedEvents.addAll(this.getEditibleEvents(object, new DateInterval(date, date2)));
        }
        for (Event event : this._selectedEvents) {
            serializable = this.getFrameArea(object, event);
            ((FrameArea)serializable).setSelected(true);
            if (this.listener == null) continue;
            this.listener.eventSelected(object, event);
        }
        if (this.listener != null) {
            this.listener.eventsSelected(this._selectedEvents);
        }
    }

    private List<Event> getEditibleEvents(Object object, DateInterval dateInterval) throws Exception {
        ArrayList<Event> arrayList = new ArrayList<Event>();
        List<Object> list = this._eventMap.get(object);
        if (list == null || list.size() < 1) {
            return arrayList;
        }
        for (Event event : list) {
            DateInterval dateInterval2;
            boolean bl;
            if (!event.isEditable() || !(bl = (dateInterval2 = new DateInterval(event.getStart(), event.getEnd())).overlap(dateInterval))) continue;
            arrayList.add(event);
        }
        return arrayList;
    }

    private boolean isSelected(Event event) {
        if (event == null || event.getId() == null) {
            return false;
        }
        for (Event event2 : this._selectedEvents) {
            if (event2.getId() == null || !event2.getId().equals(event.getId())) continue;
            return true;
        }
        return false;
    }

    public void setDescriptor(CalendarViewConfig calendarViewConfig) {
        this.desc = calendarViewConfig;
    }

    public CalendarViewConfig getDescriptor() {
        return this.desc;
    }

    protected JComponent createCorner(boolean bl, boolean bl2) throws Exception {
        String string = "LEFT_RIGHT";
        if (!bl && bl2) {
            string = "TOP_BOTTOM";
        } else if (bl && bl2) {
            string = "TOPLEFT_BOTTOMRIGHT";
        }
        GradientArea gradientArea = new GradientArea(string, Color.WHITE, ColumnHeaderPanel.GRADIENT_COLOR);
        gradientArea.setOpaque(true);
        gradientArea.setBorder(false);
        return gradientArea;
    }

    protected int getInitYPos() throws Exception {
        return 0;
    }

    protected List<?> getSelectedCalendars() throws Exception {
        return this.broker.getSelectedCalendars();
    }

    protected DateInterval getInterval() throws Exception {
        return this.broker.getInterval();
    }

    public CalendarModel getModel() {
        return this.broker;
    }

    protected FrameArea getBaseFrameArea(Event event) {
        return this.frameAreaHash.get(event);
    }

    protected Map<Date, List<Event>> createEventsPerDay(Object object) throws Exception {
        HashMap<Date, List<Event>> hashMap = new HashMap<Date, List<Event>>();
        List<Event> list = this.getModel().getEvents(object);
        if (list != null) {
            for (Event event : list) {
                Date date = DateUtil.round2Day(event.getStart());
                List<Event> list2 = (ArrayList<Event>)hashMap.get(date);
                if (list2 == null) {
                    list2 = new ArrayList<Event>();
                    hashMap.put(date, list2);
                }
                list2.add(event);
                if (DateUtil.isSameDay(event.getStart(), event.getEnd())) continue;
                Date date2 = DateUtil.move(event.getStart(), 1);
                while (DateUtil.isBeforeDay(date2, event.getEnd()) || DateUtil.isSameDay(event.getEnd(), date2)) {
                    date = DateUtil.round2Day(date2);
                    list2 = (List)hashMap.get(date);
                    if (list2 == null) {
                        list2 = new ArrayList();
                        hashMap.put(date, list2);
                    }
                    list2.add(event);
                    date2 = DateUtil.move(date2, 1);
                }
            }
        }
        return hashMap;
    }

    public abstract JComponent getComponent();

    public void clear() {
        this._selectedEvents.clear();
    }

    public static Point convertPoint(Point point, Component component, Component component2) {
        Point point2 = new Point(point);
        SwingUtilities.convertPointToScreen(point2, component);
        SwingUtilities.convertPointFromScreen(point2, component2);
        return point2;
    }

    public void setSelectedCalendarInCV(NamedCalendar namedCalendar) {
        this.selectedCalendar = namedCalendar;
    }

    public boolean getIsCreating() {
        return this.isCreating;
    }

    public boolean getIsDragging() {
        return this.isDragging;
    }

    public boolean getIsResizeing() {
        return this.isResizeing;
    }

    protected class CalHeaderMouseListener
    extends MouseAdapter {
        private Object calId;

        public CalHeaderMouseListener(Object object) {
            this.calId = object;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            try {
                if (mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = CalendarView.this.popupMenuCallback.getCalendarPopupMenu(this.calId);
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    protected class ThisMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private Point _startDrag;
        private boolean _dragging = false;
        private boolean _lasso = true;
        private Object _dragCalId = null;
        private int currPos = 0;
        private HashMap<Integer, FrameArea> additionalFrames = new HashMap();
        private FrameArea lastCreatedFrameArea = null;
        private Integer lastCreatedKey = null;
        private int mouseXold = -1;
        private int startDragMouseY = -1;

        protected ThisMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.maybeShowPopup(mouseEvent);
            } else {
                try {
                    if (mouseEvent.getClickCount() < 2) {
                        int n = CalendarView.this.findNextSmallerVerticalLine(mouseEvent.getX());
                        int n2 = CalendarView.this.findNextSmallerHorizontalLinePos(mouseEvent.getY());
                        int n3 = CalendarView.this.findNextGreaterVerticalLine(mouseEvent.getX()) - n;
                        int n4 = CalendarView.this.getTimeSlotHeight();
                        CalendarView.this._lassoArea.setBounds(n, n2, n3, n4);
                        CalendarView.this.setSelectionDate(n + n3 / 2, n2);
                        CalendarView.this._lassoArea.setVisible(true);
                    } else {
                        int n = CalendarView.this.findNextSmallerHorizontalLinePos(mouseEvent.getPoint().y);
                        Date date = CalendarView.this.getDate(mouseEvent.getPoint().x, n);
                        Object object = CalendarView.this.getCalendarId(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                        if (CalendarView.this.listener == null) {
                            return;
                        }
                        if (!CalendarView.this.getModel().isInsertable(object, date)) {
                            return;
                        }
                        CalendarView.this.listener.newEvent(object, date);
                    }
                }
                catch (Exception exception) {
                    ErrorHandler.handleError(exception);
                }
            }
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            try {
                if (mouseEvent.isPopupTrigger()) {
                    Object object = CalendarView.this.getCalendarId(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                    CalendarView.this.showEmptyPopup(mouseEvent, object);
                }
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.maybeShowPopup(mouseEvent);
            } else {
                try {
                    CalendarView.this.deselect();
                    this._startDrag = mouseEvent.getPoint();
                    this._dragCalId = CalendarView.this.getCalendarId(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                    this._lasso = (mouseEvent.getModifiersEx() & 0x40) != 0;
                }
                catch (Exception exception) {
                    throw BizcalException.create(exception);
                }
                this.startDragMouseY = CalendarView.this.findNextSmallerHorizontalLinePos(mouseEvent.getPoint().y);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && draggingEnabled) {
                this.maybeShowPopup(mouseEvent);
            } else {
                CalendarView.this.isCreating = false;
                try {
                    this._dragging = false;
                    if (CalendarView.this._dragArea == null) {
                        return;
                    }
                    Object object = null;
                    try {
                        object = CalendarView.this.getCalendarId(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                    }
                    catch (Exception exception) {
                        return;
                    }
                    Date date = CalendarView.this.getDate(CalendarView.this._dragArea.getX() + 5, CalendarView.this._dragArea.getY());
                    Date date2 = null;
                    if (this.additionalFrames != null && this.additionalFrames.size() > 0) {
                        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.additionalFrames.keySet());
                        Collections.sort(arrayList);
                        FrameArea frameArea = this.additionalFrames.get(arrayList.get(arrayList.size() - 1));
                        date2 = CalendarView.this.getDate(frameArea.getX() + 2, frameArea.getY() + frameArea.getHeight());
                    } else {
                        date2 = CalendarView.this.getDate(CalendarView.this._dragArea.getX() + 10, CalendarView.this._dragArea.getY() + CalendarView.this._dragArea.getHeight());
                    }
                    if (this._lasso) {
                        int n = CalendarView.this._dragArea.getX() + CalendarView.this._dragArea.getWidth();
                        int n2 = CalendarView.this._dragArea.getY() + CalendarView.this._dragArea.getHeight();
                        Date date3 = CalendarView.this.getDate(n, n2);
                        CalendarView.this.lasso(object, date, date3);
                    }
                    if (!this._lasso && CalendarView.this.listener != null) {
                        if (CalendarView.this.selectedCalendar != null && CalendarView.this.selectedCalendar.getId() != null) {
                            CalendarView.this.listener.newEvent((Object)CalendarView.this.selectedCalendar.getId(), new DateInterval(date, date2));
                        } else {
                            CalendarView.this.listener.newEvent(this._dragCalId, new DateInterval(date, date2));
                        }
                    }
                    CalendarView.this._dragArea.setVisible(false);
                    if (this.additionalFrames != null && this.additionalFrames.values() != null) {
                        for (FrameArea frameArea : this.additionalFrames.values()) {
                            frameArea.setVisible(false);
                        }
                    }
                    CalendarView.this._dragArea.setCursor(new Cursor(0));
                    this._lasso = false;
                    CalendarView.this._dragArea = null;
                    this._dragCalId = null;
                }
                catch (Exception exception) {
                    throw BizcalException.create(exception);
                }
                draggingEnabled = true;
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            try {
                int n;
                Object object2;
                CalendarView.this.isCreating = true;
                if (!this._dragging) {
                    Date date;
                    this._dragging = true;
                    object2 = CalendarView.this.getCalendarId(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                    if (!CalendarView.this.broker.isInsertable(object2, date = CalendarView.this.getDate(mouseEvent.getPoint().x, mouseEvent.getPoint().y))) {
                        return;
                    }
                    if (this._lasso) {
                        CalendarView.this._dragArea = CalendarView.this._lassoArea;
                    } else {
                        CalendarView.this._dragArea = CalendarView.this._newEventArea;
                    }
                    CalendarView.this._dragArea.setVisible(true);
                    CalendarView.this._dragArea.setBounds(mouseEvent.getPoint().x, mouseEvent.getPoint().y, 1, CalendarView.this.getTimeSlotHeight());
                    CalendarView.this.getComponent().revalidate();
                }
                if (CalendarView.this._dragArea == null) {
                    return;
                }
                object2 = null;
                try {
                    object2 = CalendarView.this.getCalendarId(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                }
                catch (Exception exception) {
                    return;
                }
                if (!object2.equals(this._dragCalId)) {
                    mouseEvent.consume();
                    return;
                }
                int n2 = this.startDragMouseY;
                int n3 = mouseEvent.getPoint().x;
                int n4 = CalendarView.this.findNextGreaterHorizontalLinePos(mouseEvent.getPoint().y);
                Integer n5 = null;
                if (draggingEnabled) {
                    CalendarView.this._dragArea.setCursor(new Cursor(9));
                    if (n3 >= this._startDrag.x) {
                        if (n3 < CalendarView.this.findSmallestLine().getX()) {
                            this.currPos = 0;
                        } else {
                            for (Object object3 : CalendarView.this.vLines) {
                                Integer object4 = ((JComponent)object3).getX();
                                if (n3 < object4) continue;
                                if (n5 == null) {
                                    n5 = n3 - object4;
                                    this.currPos = object4;
                                    continue;
                                }
                                if (n5 <= n3 - object4) continue;
                                n5 = n3 - object4;
                                this.currPos = object4;
                            }
                        }
                    }
                    if (CalendarView.this._dragArea instanceof FrameArea) {
                        ((FrameArea)CalendarView.this._dragArea).setStartTime(CalendarView.this.getDate(this.currPos, this.startDragMouseY));
                    }
                }
                try {
                    n = ((JLabel)CalendarView.this.vLines.get(0)).getX();
                }
                catch (Exception exception) {
                    n = CalendarView.this.calPanel.getWidth();
                }
                if (n3 >= this.currPos) {
                    if (n3 <= this.currPos || n3 >= this.currPos + n) {
                        Object object3;
                        if (this._lasso) {
                            object3 = CalendarView.this.findUndrawnLines(this.mouseXold, mouseEvent.getPoint().x, this.currPos);
                            int n6 = CalendarView.this._dragArea.getX();
                            Integer n7 = n6;
                            try {
                                n7 = (Integer)Collections.max(object3);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            int n8 = CalendarView.this._dragArea.getY();
                            int n9 = n7 - n6 + CalendarView.this.getColumnWidth();
                            CalendarView.this._dragArea.setBounds(n6, n8, n9, CalendarView.this.findNextGreaterHorizontalLinePos(mouseEvent.getPoint().y) - n8);
                            CalendarView.this.getComponent().revalidate();
                            return;
                        }
                        if (this.lastCreatedFrameArea != null && n3 <= this.lastCreatedFrameArea.getX()) {
                            this.additionalFrames.values().remove(this.lastCreatedFrameArea);
                            this.lastCreatedFrameArea.setVisible(false);
                            CalendarView.this.calPanel.remove(this.lastCreatedFrameArea);
                            this.additionalFrames.remove(this.lastCreatedKey);
                            object3 = 0;
                            for (Integer n10 : this.additionalFrames.keySet()) {
                                if (n10 <= (Integer)object3) continue;
                                object3 = n10;
                            }
                            this.lastCreatedFrameArea = this.additionalFrames.get(object3);
                            this.lastCreatedKey = object3;
                        }
                        object3 = null;
                        object3 = this.lastCreatedKey == null ? CalendarView.this.findUndrawnLines(this.mouseXold, mouseEvent.getPoint().x, this.currPos) : CalendarView.this.findUndrawnLines(this.mouseXold, mouseEvent.getPoint().x, this.lastCreatedKey);
                        if (object3 != null && object3.size() > 0) {
                            Iterator iterator = object3.iterator();
                            while (iterator.hasNext()) {
                                Integer n10;
                                n10 = (Integer)iterator.next();
                                if (this.additionalFrames.containsKey(n10)) continue;
                                FrameArea frameArea = new FrameArea();
                                frameArea.setBounds(n10, 0, n, n4);
                                CalendarView.this.calPanel.add((Component)frameArea, (Object)3);
                                frameArea.setVisible(true);
                                this.additionalFrames.put(n10, frameArea);
                                if (this.lastCreatedFrameArea != null) {
                                    this.lastCreatedFrameArea.setBounds(this.lastCreatedFrameArea.getX(), 0, n, ((CalendarView)CalendarView.this).calPanel.getMaximumSize().height);
                                }
                                this.lastCreatedFrameArea = frameArea;
                                this.lastCreatedKey = n10;
                            }
                            CalendarView.this._dragArea.setBounds(this.currPos, n2, n, ((CalendarView)CalendarView.this).calPanel.getMaximumSize().height);
                        }
                        try {
                            this.lastCreatedFrameArea.setBounds(this.lastCreatedFrameArea.getX(), 0, n, CalendarView.this.findNextGreaterHorizontalLinePos(mouseEvent.getPoint().y));
                            this.lastCreatedFrameArea.setEndTime(CalendarView.this.getDate(this.currPos, this.lastCreatedFrameArea.getY() + this.lastCreatedFrameArea.getHeight()));
                        }
                        catch (Exception exception) {}
                    } else {
                        for (Integer n11 : this.additionalFrames.keySet()) {
                            this.additionalFrames.get(n11).setVisible(false);
                            CalendarView.this.calPanel.remove(this.additionalFrames.get(n11));
                        }
                        this.additionalFrames.clear();
                        this.lastCreatedFrameArea = null;
                        this.lastCreatedKey = null;
                        CalendarView.this._dragArea.setBounds(this.currPos, n2, n, CalendarView.this.findNextGreaterHorizontalLinePos(mouseEvent.getPoint().y) - n2);
                        if (CalendarView.this._dragArea instanceof FrameArea) {
                            ((FrameArea)CalendarView.this._dragArea).setEndTime(CalendarView.this.getDate(this.currPos, CalendarView.this._dragArea.getY() + CalendarView.this._dragArea.getHeight()));
                        }
                    }
                }
                if (CalendarView.this._dragArea.getHeight() < CalendarView.this.getTimeSlotHeight()) {
                    CalendarView.this._dragArea.setBounds(CalendarView.this._dragArea.getX(), CalendarView.this._dragArea.getY(), CalendarView.this._dragArea.getWidth(), CalendarView.this.getTimeSlotHeight());
                }
                CalendarView.this.getComponent().revalidate();
                draggingEnabled = false;
                this.mouseXold = mouseEvent.getPoint().x;
            }
            catch (Exception exception) {
                LOGGER.error("Can't handle dragging.");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                throw BizcalException.create(exception);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            CalendarView.this.getComponent().requestFocusInWindow();
        }
    }

    protected class ThisKeyListener
    extends KeyAdapter {
        private int SHIFT = 16;
        private int CTRL = 17;

        protected ThisKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == this.SHIFT) {
                CalendarView.this.getComponent().setCursor(new Cursor(1));
            }
            try {
                if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 67) {
                    CalendarView.this.copy();
                }
                if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 86 && CalendarView.this.listener != null) {
                    CalendarView.this.listener.paste(null, CalendarView.this.getSelectionDate());
                }
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            try {
                if (keyEvent.getKeyCode() == this.SHIFT || keyEvent.getKeyCode() == this.CTRL) {
                    CalendarView.this.getComponent().setCursor(null);
                }
            }
            catch (Exception exception) {
                ErrorHandler.handleError(exception);
            }
        }
    }

    private class FrameAreaKeyListener
    extends KeyAdapter {
        private Event _event;

        public FrameAreaKeyListener(Event event) {
            this._event = event;
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            try {
                if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 67) {
                    CalendarView.this.copy();
                }
                if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 86 && CalendarView.this.listener != null) {
                    CalendarView.this.listener.paste(null, CalendarView.this.getSelectionDate());
                }
                if ((keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) && CalendarView.this.listener != null) {
                    CalendarView.this.listener.deleteEvents(CalendarView.this._selectedEvents);
                }
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    private class FrameAreaMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private Point _startDrag;
        private FrameArea _frameArea;
        private Object _calId;
        private Event _event;
        private Cursor resizeCursor = new Cursor(9);
        private Cursor handCursor = new Cursor(12);
        private FrameArea lastCreatedFrameArea = null;
        private Integer mouseXold = -1;
        private HashMap<Integer, FrameArea> additionalFrames = new HashMap();
        private List<FrameArea> deletedFrameAreas = Collections.synchronizedList(new ArrayList());
        private boolean _shiftKey = false;
        private boolean dragged;
        private long lastEventTime = 0L;
        private FrameArea baseArea;
        private static final int DEFAULT_SIZE_Y_RESIZE_REGION = 6;
        private int resizeRegionY = 6;
        private boolean isPopupTrigger = false;

        public FrameAreaMouseListener(FrameArea frameArea, Object object, Event event) {
            this._frameArea = frameArea;
            this._calId = object;
            this._event = event;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            FrameArea frameArea;
            if (mouseEvent.isPopupTrigger()) {
                this.isPopupTrigger = true;
            }
            isMousePressed = true;
            this.dragged = false;
            if (originalClickedFrameArea == null) {
                originalClickedFrameArea = this._frameArea;
            }
            try {
                if (mouseEvent.getClickCount() == 1 && this._event.isSelectable()) {
                    frameArea = this.getBaseArea();
                    if ((mouseEvent.getModifiersEx() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                        if (frameArea.isSelected()) {
                            CalendarView.this.select(this._calId, this._event, false);
                        } else {
                            CalendarView.this.select(this._calId, this._event, true);
                        }
                    } else {
                        CalendarView.this.deselect();
                        CalendarView.this.select(this._calId, this._event, true);
                    }
                    CalendarView.this._lassoArea.setVisible(false);
                    this._frameArea.requestFocus();
                    if (CalendarView.this.listener != null) {
                        CalendarView.this.listener.eventClicked(this._calId, this._event, frameArea, mouseEvent);
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.error("Can't select event.");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            if (!this._event.isEditable()) {
                return;
            }
            frameArea = this.getBaseArea();
            this._startDrag = mouseEvent.getPoint();
            this.additionalFrames.clear();
            if (frameArea.getChildren() != null) {
                for (FrameArea frameArea2 : frameArea.getChildren()) {
                    this.additionalFrames.put(frameArea2.getX(), frameArea2);
                }
            }
            this.lastCreatedFrameArea = CalendarView.this.findLastFrameArea(frameArea);
            CalendarView.this.calPanel.repaint();
        }

        private void removeAdditionalArea(FrameArea frameArea) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (Integer n : this.additionalFrames.keySet()) {
                if (!this.additionalFrames.get(n).equals(frameArea)) continue;
                arrayList.add(n);
            }
            for (Integer n : arrayList) {
                this.additionalFrames.remove(n);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.isPopupTrigger || mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
                this.isPopupTrigger = false;
            } else {
                CalendarView.this.isDragging = false;
                CalendarView.this.isResizeing = false;
                FrameArea frameArea = this.getBaseArea();
                if (!frameArea.equals(this._frameArea)) {
                    frameArea.getMouseListeners()[0].mouseReleased(mouseEvent);
                    return;
                }
                for (FrameArea serializable : this.deletedFrameAreas) {
                    serializable.setVisible(false);
                    CalendarView.this.calPanel.remove(serializable);
                    this.removeAdditionalArea(serializable);
                }
                this.deletedFrameAreas.clear();
                CalendarView.this.getComponent().revalidate();
                try {
                    if (CalendarView.this.listener != null) {
                        Object object;
                        if (isResizeable) {
                            Date date;
                            object = CalendarView.this.findLastFrameArea(frameArea);
                            if (object == null) {
                                object = frameArea;
                            }
                            if (!(date = CalendarView.this.getDate(((JComponent)object).getX() + 5, ((JComponent)object).getY() + ((JComponent)object).getHeight())).equals(this._event.getStart())) {
                                CalendarView.this.listener.resized(this._event, this._calId, this._event.getEnd(), CalendarView.this.getDate(((JComponent)object).getX() + 5, ((JComponent)object).getY() + ((JComponent)object).getHeight()));
                            }
                        } else {
                            object = CalendarView.this.getDate(frameArea.getX() + 5, frameArea.getY());
                            if (this.dragged && !DateUtil.round2Minute((Date)object).equals(DateUtil.round2Minute(this._event.getStart()))) {
                                CalendarView.this.listener.moved(this._event, this._calId, this._event.getStart(), this._calId, (Date)object);
                            }
                            if (mouseEvent.getClickCount() == 1 && this._event.isSelectable()) {
                                FrameArea frameArea2 = CalendarView.this.getFrameArea(this._calId, this._event);
                                CalendarView.this.listener.eventClicked(this._calId, this._event, frameArea2, mouseEvent);
                            }
                            if (mouseEvent.getClickCount() == 2 && this._event.isSelectable()) {
                                CalendarView.this.select(this._calId, this._event, true);
                                isMousePressed = false;
                                CalendarView.this.listener.eventDoubleClick(this._calId, this._event, mouseEvent);
                                return;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    ErrorHandler.handleError(exception);
                }
                this._frameArea.setIsMoving(false);
                originalClickedFrameArea = null;
                isMousePressed = false;
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            FrameArea frameArea = this.getBaseArea();
            if (!frameArea.equals(this._frameArea)) {
                frameArea.getMouseListeners()[0].mouseEntered(mouseEvent);
                return;
            }
            if (isMousePressed) {
                return;
            }
            isResizeable = false;
            try {
                if (!this._event.isSelectable()) {
                    return;
                }
                if (!this._frameArea.isSelected()) {
                    if (this._frameArea.getChildren() != null) {
                        for (FrameArea frameArea2 : this._frameArea.getChildren()) {
                            frameArea2.setBrightness(true);
                            frameArea2.setBorder(true);
                        }
                    }
                    this._frameArea.setBrightness(true);
                    this._frameArea.setBorder(true);
                    CalendarView.this.calPanel.repaint();
                }
            }
            catch (Exception exception) {
                ErrorHandler.handleError(exception);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            FrameArea frameArea = this.getBaseArea();
            if (!frameArea.equals(this._frameArea)) {
                frameArea.getMouseListeners()[0].mouseExited(mouseEvent);
                return;
            }
            if (isMousePressed) {
                return;
            }
            if (isResizeable) {
                isResizeable = false;
                frameArea.setCursor(new Cursor(0));
            }
            try {
                if (!this._event.isSelectable() || this._frameArea.isSelected()) {
                    return;
                }
                CalendarView.this.getComponent().setCursor(new Cursor(0));
                this._frameArea.setBrightness(false);
                if (this._frameArea.getChildren() != null) {
                    for (FrameArea frameArea2 : this._frameArea.getChildren()) {
                        frameArea2.setBrightness(false);
                        frameArea2.setBorder(false);
                    }
                }
                CalendarView.this.calPanel.repaint();
            }
            catch (Exception exception) {
                ErrorHandler.handleError(exception);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        private void showPopup(MouseEvent mouseEvent) {
            try {
                FrameArea frameArea = CalendarView.this.getFrameArea(this._calId, this._event);
                if (this._event.isSelectable() && !frameArea.isSelected()) {
                    CalendarView.this.deselect();
                    CalendarView.this.select(this._calId, this._event, true);
                }
                CalendarView.this.showEventpopup(mouseEvent, this._calId, this._event);
            }
            catch (Exception exception) {
                ErrorHandler.handleError(exception);
            }
        }

        private FrameArea getBaseArea() {
            if (this.baseArea == null) {
                this.baseArea = CalendarView.this.frameAreaHash.get(this._event);
            }
            return this.baseArea;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this._event.isEditable()) {
                return;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (this.lastEventTime == 0L) {
                    this.lastEventTime = System.currentTimeMillis();
                } else {
                    long l = System.currentTimeMillis();
                    if (l - this.lastEventTime < 15L) {
                        return;
                    }
                    this.lastEventTime = l;
                }
                FrameArea frameArea = this.getBaseArea();
                try {
                    ((FrameAreaMouseListener)frameArea.getMouseListeners()[0]).dragged = true;
                }
                catch (Exception exception) {
                    LOGGER.error("Can't enable dragging.");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
                this.dragged = true;
                this._shiftKey = (mouseEvent.getModifiersEx() & 0x40) != 0;
                try {
                    if (isResizeable) {
                        CalendarView.this.isResizeing = true;
                        this.resizeDrag(frameArea, mouseEvent);
                    } else {
                        CalendarView.this.isDragging = true;
                        this.moveDrag(frameArea, mouseEvent);
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Can't handle dragging.");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!this._event.isEditable()) {
                return;
            }
            FrameArea frameArea = CalendarView.this.frameAreaHash.get(this._event);
            if (frameArea.getHeight() <= 12) {
                this.resizeRegionY = frameArea.getHeight() / 2;
                if (this.resizeRegionY <= 0) {
                    this.resizeRegionY = 5;
                }
            }
            FrameArea frameArea2 = null;
            frameArea2 = CalendarView.this.findLastFrameArea(frameArea);
            if (frameArea2 == null) {
                frameArea2 = frameArea;
            }
            if (!frameArea2.getCursor().equals(this.resizeCursor)) {
                if (mouseEvent.getPoint().y > frameArea2.getHeight() - this.resizeRegionY && mouseEvent.getSource().equals(frameArea2)) {
                    frameArea2.setCursor(this.resizeCursor);
                    isResizeable = true;
                    mouseEvent.consume();
                    return;
                }
            } else if (!frameArea2.getCursor().equals(this.handCursor) && mouseEvent.getPoint().y < frameArea2.getHeight() - this.resizeRegionY) {
                frameArea2.setCursor(this.handCursor);
                isResizeable = false;
                mouseEvent.consume();
                return;
            }
        }

        private void moveDrag(FrameArea frameArea, MouseEvent mouseEvent) {
            int n;
            int n2 = this._frameArea.getX();
            int n3 = this._frameArea.getWidth();
            int n4 = CalendarView.this.findNextSmallerVerticalLine(n2 + 5);
            int n5 = CalendarView.this.findNextGreaterVerticalLine(n2 + 5);
            int n6 = n2 - n4;
            int n7 = n5 - n2 - n3;
            frameArea.setIsMoving(true);
            Integer n8 = null;
            if (mouseEvent.getPoint().x < 0) {
                if (n6 + mouseEvent.getPoint().x < 0) {
                    n8 = CalendarView.this.findNextSmallerVerticalLine(frameArea.getX() - 5);
                }
            } else if (mouseEvent.getPoint().x > n3 && mouseEvent.getPoint().x > n3 + n7) {
                n8 = CalendarView.this.findNextGreaterVerticalLine(frameArea.getX());
            }
            if (n8 != null && n8 <= CalendarView.this.calPanel.getX() + CalendarView.this.calPanel.getWidth()) {
                n = frameArea.getY();
                int n9 = frameArea.getWidth();
                int n10 = frameArea.getHeight();
                frameArea.setBounds(n8, n, n9, n10);
                if (frameArea.getChildren() != null && frameArea.getChildren().size() > 0) {
                    int n11 = 1;
                    for (FrameArea frameArea2 : frameArea.getChildren()) {
                        int n12 = frameArea.getX();
                        for (int i = 0; i < n11; ++i) {
                            n12 = CalendarView.this.findNextGreaterVerticalLine(n12);
                        }
                        ++n11;
                        frameArea2.setBounds(n12, frameArea2.getY(), n9, frameArea2.getHeight());
                    }
                }
            } else {
                n = mouseEvent.getPoint().y;
                int n13 = this._startDrag.y - n;
                if (Math.abs(n13) > CalendarView.this.getTimeSlotHeight() || this._shiftKey) {
                    int n14;
                    if (this._shiftKey) {
                        n14 = Math.abs(n13);
                    } else {
                        n14 = 0;
                        int n15 = 0;
                        int n16 = 0;
                        int n17 = 0;
                        for (JLabel jLabel : CalendarView.this.hLines) {
                            if (Integer.valueOf(jLabel.getY()) > frameArea.getY() - n13) {
                                n15 = n17;
                                n16 = jLabel.getY();
                                break;
                            }
                            n17 = jLabel.getY();
                        }
                        if (n13 < n) {
                            frameArea.setBounds(frameArea.getX(), n15, frameArea.getWidth(), frameArea.getHeight());
                        }
                        if (n13 > n) {
                            frameArea.setBounds(frameArea.getX(), n16, frameArea.getWidth(), frameArea.getHeight());
                        }
                    }
                    if (this._startDrag.y > n) {
                        n14 *= -1;
                    }
                    if (frameArea.getY() + n14 >= CalendarView.this.calPanel.getY()) {
                        frameArea.setBounds(frameArea.getX(), frameArea.getY() + n14, frameArea.getWidth(), frameArea.getHeight());
                        FrameArea frameArea3 = CalendarView.this.findLastFrameArea(frameArea);
                        if (frameArea.getChildren() != null && frameArea.getChildren().size() > 0) {
                            frameArea.setBounds(frameArea.getX(), frameArea.getY(), frameArea.getWidth(), CalendarView.this.calPanel.getHeight() - frameArea.getY());
                        }
                        if (frameArea3 != null) {
                            frameArea3.setBounds(frameArea3.getX(), frameArea3.getY(), frameArea3.getWidth(), frameArea3.getHeight() + n14);
                        }
                        if (!this._frameArea.equals(frameArea)) {
                            this.mousePressed(mouseEvent);
                        }
                    }
                }
            }
            try {
                this._frameArea.setMovingTimeString(CalendarView.this.getDate(this._frameArea.getX(), this._frameArea.getY()), CalendarView.this.getDate(this._frameArea.getX(), this._frameArea.getY() + this._frameArea.getHeight()));
            }
            catch (Exception exception) {
                LOGGER.error("Can't update moving time.");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }

        private void resizeDrag(FrameArea frameArea, MouseEvent mouseEvent) {
            int n = this._frameArea.getX();
            int n2 = this._frameArea.getY();
            int n3 = this._frameArea.getWidth();
            int n4 = CalendarView.this.findNextSmallerVerticalLine(n + 5);
            int n5 = CalendarView.this.findNextGreaterVerticalLine(n + 5);
            int n6 = n - n4;
            int n7 = n5 - n - n3;
            frameArea.setIsMoving(true);
            FrameArea frameArea2 = this._frameArea;
            Point point = mouseEvent.getPoint();
            if (frameArea.getChildren() != null && frameArea.getChildren().size() > 0) {
                frameArea2 = frameArea.getChildren().get(frameArea.getChildren().size() - 1);
                point = CalendarView.convertPoint(mouseEvent.getPoint(), this._frameArea, frameArea2);
            } else if (!this._frameArea.isVisible()) {
                frameArea2 = frameArea;
                point = CalendarView.convertPoint(mouseEvent.getPoint(), this._frameArea, frameArea2);
            }
            n = frameArea2.getX();
            n2 = frameArea2.getY();
            n3 = frameArea2.getWidth();
            n6 = n - CalendarView.this.findNextSmallerVerticalLine(n + 5);
            n7 = CalendarView.this.findNextGreaterVerticalLine(n + 5) - n - n3;
            if (frameArea2.getHeight() + point.y < CalendarView.this.desc.getMinimumTimeSlotHeight() || frameArea2.getHeight() + point.y < CalendarView.this.getTimeSlotHeight()) {
                return;
            }
            if (n6 + point.x < 0 || point.x > n3 + n7) {
                if (n6 + point.x < 0) {
                    if (frameArea.getChildren() != null) {
                        ArrayList<FrameArea> arrayList = new ArrayList<FrameArea>();
                        for (FrameArea frameArea3 : frameArea.getChildren()) {
                            if (frameArea3.getX() <= CalendarView.this.findNextSmallerVerticalLine(n + point.x)) continue;
                            frameArea3.setVisible(false);
                            arrayList.add(frameArea3);
                            this.deletedFrameAreas.add(frameArea3);
                        }
                        frameArea.getChildren().removeAll(arrayList);
                    }
                } else {
                    int n8 = 0;
                    n8 = point.x;
                    if (n8 > n3 + n7) {
                        List list = null;
                        list = CalendarView.this.findUndrawnLines(n + this.mouseXold, n + point.x, frameArea.getX());
                        if (list != null && list.size() > 0) {
                            frameArea2.setBounds(frameArea2.getX(), 0, n3, ((CalendarView)CalendarView.this).calPanel.getMaximumSize().height);
                            for (Integer n9 : list) {
                                FrameArea frameArea4;
                                if (this.additionalFrames.containsKey(n9)) {
                                    frameArea4 = this.additionalFrames.get(n9);
                                    if (frameArea4.isVisible()) {
                                        this.lastCreatedFrameArea = frameArea4;
                                        continue;
                                    }
                                    if (!frameArea.getChildren().contains(frameArea4)) {
                                        frameArea.addChild(frameArea4);
                                        if (this.deletedFrameAreas.contains(frameArea4)) {
                                            this.deletedFrameAreas.remove(frameArea4);
                                        }
                                    }
                                    frameArea4.setVisible(true);
                                    frameArea4.setBounds(frameArea4.getX(), 0, n3, ((CalendarView)CalendarView.this).calPanel.getMaximumSize().height);
                                    this.lastCreatedFrameArea = frameArea4;
                                    continue;
                                }
                                frameArea4 = new FrameArea();
                                frameArea4.setBounds(n9, 0, n3, CalendarView.this.findNextGreaterHorizontalLinePos(n2 + point.y));
                                frameArea4.setEvent(this._event);
                                CalendarView.this.calPanel.add((Component)frameArea4, (Object)3);
                                CalendarView.this.calPanel.validate();
                                CalendarView.this.calPanel.updateUI();
                                frameArea4.setVisible(true);
                                this.additionalFrames.put(n9, frameArea4);
                                frameArea.addChild(frameArea4);
                                if (this.lastCreatedFrameArea != null) {
                                    this.lastCreatedFrameArea.setBounds(this.lastCreatedFrameArea.getX(), 0, n3, ((CalendarView)CalendarView.this).calPanel.getMaximumSize().height);
                                }
                                this.lastCreatedFrameArea = frameArea4;
                                point = CalendarView.convertPoint(point, frameArea2, frameArea4);
                                frameArea2 = frameArea4;
                            }
                        }
                    }
                }
            } else {
                int n10 = 0;
                n10 = this._shiftKey ? point.y : CalendarView.this.findNextGreaterHorizontalLinePos(point.y);
                frameArea2.setBounds(n, n2, n3, n10);
            }
            try {
                this._frameArea.setMovingTimeString(CalendarView.this.getDate(this._frameArea.getX(), this._frameArea.getY()), CalendarView.this.getDate(this._frameArea.getX(), this._frameArea.getY() + this._frameArea.getHeight()));
            }
            catch (Exception exception) {
                LOGGER.error("Can't update moving time.");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }
}

