/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.CalendarModel;
import bizcal.common.CalendarViewConfig;
import bizcal.swing.CalendarListener;
import bizcal.swing.PopupMenuCallback;
import bizcal.swing.util.GradientArea;
import bizcal.swing.util.TrueGridLayout;
import bizcal.util.BizcalException;
import bizcal.util.DateUtil;
import bizcal.util.TextUtil;
import bizcal.util.TimeOfDay;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class DaysHoursHeaderPanel {
    public static final Color GRADIENT_COLOR = new Color(230, 230, 230);
    private PopupMenuCallback popupMenuCallback;
    private JPanel panel;
    private List dateHeaders = new ArrayList();
    private List dateHeaders2 = new ArrayList();
    private List hourHeaders = new ArrayList();
    private List dateList = new ArrayList();
    private List dateLines = new ArrayList();
    private GradientArea gradientArea;
    private JLabel refLabel = new JLabel("AAA");
    private int rowCount;
    private int dayCount;
    private int hourCount;
    private CalendarModel model;
    private int fixedDayCount = -1;
    private boolean showExtraDateHeaders = false;
    private CalendarViewConfig config;

    public DaysHoursHeaderPanel(CalendarViewConfig calendarViewConfig, CalendarModel calendarModel) {
        this.config = calendarViewConfig;
        this.model = calendarModel;
        this.panel = new JPanel();
        this.panel.setLayout(new Layout());
        this.gradientArea = new GradientArea("TOP_BOTTOM", Color.WHITE, GRADIENT_COLOR);
        this.gradientArea.setBorder(false);
    }

    public void refresh() throws Exception {
        this.dateHeaders.clear();
        this.dateHeaders2.clear();
        this.hourHeaders.clear();
        this.dateList.clear();
        this.dateLines.clear();
        this.panel.removeAll();
        this.dayCount = DateUtil.getDateDiff(this.model.getInterval().getEndDate(), this.model.getInterval().getStartDate());
        if (this.fixedDayCount > 0) {
            this.dayCount = this.fixedDayCount;
        }
        if (this.dayCount > 1) {
            this.rowCount = 1;
            if (this.dayCount <= 7) {
                ++this.rowCount;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE d MMMM", Locale.getDefault());
            DateFormat dateFormat = DateFormat.getDateInstance(3, Locale.getDefault());
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HH", Locale.getDefault());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new TrueGridLayout(1, this.dayCount));
            jPanel.setOpaque(false);
            Date date = this.model.getInterval().getStartDate();
            if (this.fixedDayCount > 0) {
                date = DateUtil.round2Week(date);
            }
            for (int i = 0; i < this.dayCount; ++i) {
                String string = dateFormat.format(date);
                JLabel jLabel = new JLabel(string, 0);
                jLabel.setToolTipText(simpleDateFormat.format(date));
                if (this.model.isRedDay(date)) {
                    jLabel.setForeground(Color.RED);
                }
                this.dateHeaders.add(jLabel);
                this.panel.add(jLabel);
                this.dateList.add(date);
                JLabel jLabel2 = new JLabel();
                jLabel2.setOpaque(true);
                jLabel2.setBackground(this.config.getLineColor2());
                this.panel.add(jLabel2);
                this.dateLines.add(jLabel2);
                if (this.dayCount <= 7) {
                    this.hourCount = 0;
                    long l = this.config.getStartView().getValue();
                    while (l < this.config.getEndView().getValue()) {
                        string = simpleDateFormat2.format(new TimeOfDay(l).getDate(date));
                        jLabel = new JLabel(string, 0);
                        this.dateHeaders2.add(jLabel);
                        this.panel.add(jLabel);
                        if (l > this.config.getStartView().getValue()) {
                            jLabel2 = new JLabel();
                            jLabel2.setBackground(this.config.getLineColor());
                            jLabel2.setOpaque(true);
                            this.panel.add(jLabel2);
                            this.dateLines.add(jLabel2);
                        }
                        l += 0x6DDD00L;
                        this.hourCount += 2;
                    }
                }
                date = DateUtil.getDiffDay(date, 1);
            }
        }
        if (this.showExtraDateHeaders) {
            ++this.rowCount;
        }
        this.panel.add(this.gradientArea);
        this.panel.updateUI();
    }

    public JComponent getComponent() {
        return this.panel;
    }

    private void resizeDates(int n) throws Exception {
        if (this.dayCount != 5 && this.dayCount != 7) {
            return;
        }
        Date date = DateUtil.round2Day(new Date());
        int n2 = 10;
        FontMetrics fontMetrics = this.refLabel.getFontMetrics(this.refLabel.getFont());
        if (this.maxWidth(n2, fontMetrics) > n && this.maxWidth(n2 = 3, fontMetrics) > n && this.maxWidth(n2 = 2, fontMetrics) > n) {
            n2 = 1;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEEE", Locale.getDefault());
        for (int i = 0; i < this.dateHeaders.size(); ++i) {
            JLabel jLabel = (JLabel)this.dateHeaders.get(i);
            Date date2 = (Date)this.dateList.get(i);
            String string = simpleDateFormat.format(date2);
            if (string.length() > n2) {
                string = string.substring(0, n2);
            }
            string = TextUtil.formatCase(string);
            if (date.equals(DateUtil.round2Day(date2))) {
                string = "<html><b>" + string + "</b></html>";
            }
            jLabel.setText(string);
        }
    }

    private int maxWidth(int n, FontMetrics fontMetrics) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEEE", Locale.getDefault());
        Calendar calendar = DateUtil.newCalendar();
        calendar.set(7, 1);
        int n2 = 0;
        for (int i = 0; i < 7; ++i) {
            int n3;
            String string = simpleDateFormat.format(calendar.getTime());
            if (string.length() > n) {
                string = string.substring(0, n);
            }
            if ((n3 = fontMetrics.stringWidth(string)) > n2) {
                n2 = n3;
            }
            calendar.add(7, 1);
        }
        return n2;
    }

    public void setModel(CalendarModel calendarModel) {
        this.model = calendarModel;
    }

    public void setPopupMenuCallback(PopupMenuCallback popupMenuCallback) {
        this.popupMenuCallback = popupMenuCallback;
    }

    public void addCalendarListener(CalendarListener calendarListener) {
    }

    public void setShowExtraDateHeaders(boolean bl) {
        this.showExtraDateHeaders = bl;
    }

    private int getHourCount() throws Exception {
        return this.config.getEndView().getHour() - this.config.getStartView().getHour();
    }

    private class Layout
    implements LayoutManager {
        private Layout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            try {
                int n = ((DaysHoursHeaderPanel)DaysHoursHeaderPanel.this).refLabel.getPreferredSize().height;
                n = DaysHoursHeaderPanel.this.rowCount * n;
                int n2 = DaysHoursHeaderPanel.this.dayCount * DaysHoursHeaderPanel.this.getHourCount() * 10;
                return new Dimension(n2, n);
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(50, 100);
        }

        @Override
        public void layoutContainer(Container container) {
            try {
                if (DaysHoursHeaderPanel.this.rowCount == 0) {
                    return;
                }
                double d = container.getWidth();
                double d2 = d / (double)DaysHoursHeaderPanel.this.dateHeaders.size();
                double d3 = d2 / (double)DaysHoursHeaderPanel.this.hourCount;
                double d4 = container.getHeight() / DaysHoursHeaderPanel.this.rowCount;
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = DaysHoursHeaderPanel.this.showExtraDateHeaders ? 2 : 1;
                for (int i = 0; i < DaysHoursHeaderPanel.this.dayCount; ++i) {
                    JLabel jLabel = (JLabel)DaysHoursHeaderPanel.this.dateHeaders.get(n);
                    int n5 = (int)((double)n * d2);
                    jLabel.setBounds(n5, 0, (int)d2, (int)d4);
                    JLabel jLabel2 = (JLabel)DaysHoursHeaderPanel.this.dateLines.get(n3);
                    int n6 = (int)d4 * n4;
                    int n7 = (int)d4;
                    jLabel2.setBounds(n5, 0, 1, n6 * DaysHoursHeaderPanel.this.rowCount);
                    ++n3;
                    if (DaysHoursHeaderPanel.this.dayCount <= 7) {
                        int n8 = 0;
                        long l = DaysHoursHeaderPanel.this.config.getStartView().getValue();
                        while (l < DaysHoursHeaderPanel.this.config.getEndView().getValue()) {
                            jLabel = (JLabel)DaysHoursHeaderPanel.this.dateHeaders2.get(n2);
                            n5 = (int)((double)n * d2 + (double)n8 * d3);
                            jLabel.setBounds(n5, (int)d4, (int)d3 * 2, (int)d4);
                            if (l > DaysHoursHeaderPanel.this.config.getStartView().getValue()) {
                                jLabel2 = (JLabel)DaysHoursHeaderPanel.this.dateLines.get(n3);
                                n6 = (int)d4 * n4;
                                n7 = (int)d4;
                                jLabel2.setBounds(n5, n7, 1, n6);
                                ++n3;
                            }
                            l += 0x6DDD00L;
                            n8 += 2;
                            ++n2;
                        }
                    }
                    ++n;
                }
                DaysHoursHeaderPanel.this.gradientArea.setBounds(0, 0, container.getWidth(), container.getHeight());
                DaysHoursHeaderPanel.this.resizeDates((int)d2);
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }
    }

    protected class CalHeaderMouseListener
    extends MouseAdapter {
        private Object calId;

        public CalHeaderMouseListener(Object object) {
            this.calId = object;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            try {
                if (mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = DaysHoursHeaderPanel.this.popupMenuCallback.getCalendarPopupMenu(this.calId);
                    if (jPopupMenu == null) {
                        return;
                    }
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

