/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.views.list;

import bizcal.common.Event;
import bizcal.util.DateUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ListModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final I18n I18N = I18nFactory.getI18n(ListModel.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ListModel.class);
    private ArrayList<Event> events = new ArrayList();
    private DateFormat dateTime = new SimpleDateFormat("dd.MM.yy HH:mm", Locale.getDefault());
    private DateFormat date = new SimpleDateFormat("EEE dd.MM.yy", Locale.getDefault());
    private DateFormat time = new SimpleDateFormat("HH:mm", Locale.getDefault());
    private static String[] columnNames = new String[]{I18N.tr("date"), I18N.tr("type"), I18N.tr("calendars"), I18N.tr("description")};
    private static Class[] columnClasses = new Class[]{String.class, ImageIcon.class, String.class, String.class};

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return columnClasses[n];
    }

    @Override
    public int getRowCount() {
        return this.events.size();
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Event event = this.events.get(n);
        if (event == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                String string = "";
                try {
                    if (DateUtil.isSameDay(event.getStart(), event.getEnd())) {
                        String string2 = this.date.format(event.getStart());
                        string2 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
                        string = "<html><b>" + string2 + "</b><br>" + this.time.format(event.getStart()) + " - " + this.time.format(event.getEnd());
                    } else {
                        string = "<html><b>" + this.dateTime.format(event.getStart()) + "</b><br>" + this.dateTime.format(event.getEnd());
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("listmodel dateformating creation failed", (Object)event);
                }
                return string;
            }
            case 1: {
                return event.getIcon();
            }
            case 2: {
                return event.get("calendar_name");
            }
            case 3: {
                return "<html><b>" + (event.getSummary() != null ? event.getSummary() : "") + "</b><br>" + (event.getDescription() != null ? event.getDescription() : "");
            }
        }
        return null;
    }

    public void setEvents(List list) {
        this.events = new ArrayList(list);
        this.fireTableDataChanged();
    }

    public Event getEvent(int n) {
        return this.events.get(n);
    }
}

