/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.widgets;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import lu.tudor.santec.bizcal.widgets.BubbleLabel;

public class ButtonPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel content;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private int columns;
    private HashMap<Action, AbstractButton> map = new HashMap();

    public ButtonPanel(String string, Color color, int n, Vector<AbstractButton> vector) {
        this.createPanel(string, color, n, vector);
    }

    public ButtonPanel(String string, Color color, int n, Vector<Action> vector, boolean bl) {
        Vector<AbstractButton> vector2 = new Vector<AbstractButton>();
        for (Action action : vector) {
            if (bl) {
                vector2.add(new JToggleButton(action));
                continue;
            }
            vector2.add(new JButton(action));
        }
        this.createPanel(string, color, n, vector2);
    }

    public ButtonPanel(String string, Color color, int n, Vector<Action> vector, boolean bl, boolean bl2) {
        Vector<AbstractButton> vector2 = new Vector<AbstractButton>();
        for (Action action : vector) {
            if (bl) {
                vector2.add(new JToggleButton(action));
                continue;
            }
            vector2.add(new JButton(action));
        }
        this.createPanel(string, color, n, vector2, bl2);
    }

    private void createPanel(String string, Color color, int n, Vector<AbstractButton> vector) {
        this.createPanel(string, color, n, vector, false);
    }

    private void createPanel(String string, Color color, int n, Vector<AbstractButton> vector, boolean bl) {
        this.columns = n;
        this.setLayout(new BorderLayout(0, 2));
        this.setOpaque(false);
        BubbleLabel bubbleLabel = new BubbleLabel(" " + string + ":");
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 200);
        bubbleLabel.setBackground(color);
        bubbleLabel.setPreferredSize(new Dimension(22, 22));
        this.add((Component)bubbleLabel, "North");
        this.content = new JPanel(new GridLayout(0, n, 2, 2));
        this.content.setOpaque(false);
        for (AbstractButton jComponent : vector) {
            this.addButton(jComponent);
        }
        JScrollPane jScrollPane = new JScrollPane(this.content);
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        if (bl) {
            JPanel jPanel = new JPanel((LayoutManager)new FormLayout("fill:pref", "fill:1dlu:grow,pref"));
            jPanel.setOpaque(false);
            CellConstraints cellConstraints = new CellConstraints();
            jPanel.add((Component)jScrollPane, cellConstraints.xy(1, 2));
            this.add((Component)jPanel, "Center");
        } else {
            this.add((Component)jScrollPane, "Center");
        }
    }

    public void addButton(AbstractButton abstractButton) {
        if (this.columns == 1) {
            abstractButton.setHorizontalAlignment(2);
        } else {
            abstractButton.setMargin(new Insets(2, 2, 2, 2));
        }
        this.content.add(abstractButton);
    }

    public void addToggleButton(JToggleButton jToggleButton) {
        if (this.columns == 1) {
            jToggleButton.setHorizontalAlignment(2);
        } else {
            jToggleButton.setMargin(new Insets(2, 2, 2, 2));
        }
        this.content.add(jToggleButton);
        this.buttonGroup.add(jToggleButton);
    }

    public void addComponent(JComponent jComponent) {
        this.content.add(jComponent);
    }

    public void removeComponent(JComponent jComponent) {
        this.content.remove(jComponent);
    }

    public void removeButton(AbstractButton abstractButton) {
        this.content.remove(abstractButton);
        if (abstractButton instanceof JToggleButton) {
            this.buttonGroup.remove(abstractButton);
        }
    }

    public void addAction(Action action) {
        JButton jButton = new JButton(action);
        this.map.put(action, jButton);
        this.addButton(jButton);
    }

    public void addToggleAction(Action action) {
        JToggleButton jToggleButton = new JToggleButton(action);
        this.map.put(action, jToggleButton);
        this.addButton(jToggleButton);
    }

    public void removeAction(Action action) {
        AbstractButton abstractButton = this.map.get(action);
        this.map.remove(action);
        this.removeButton(abstractButton);
    }

    public void setContentLayout(LayoutManager layoutManager) {
        this.content.setLayout(layoutManager);
    }
}

