/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColoredCheckBox
extends JCheckBox {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColoredCheckBox.class);
    private boolean drawBackground;
    private Color bgColor;
    private ColorCheckBoxIcon cbi;
    private boolean big;
    private static final long serialVersionUID = 1L;

    public ColoredCheckBox(String string, Color color, boolean bl, boolean bl2) {
        super(string);
        this.drawBackground = bl2;
        this.big = bl;
        this.setOpaque(false);
        this.setColor(color);
    }

    public ColoredCheckBox(String string, Color color, boolean bl) {
        this(string, color, bl, false);
    }

    public ColoredCheckBox(String string, Color color) {
        this(string, color, false, false);
    }

    public void setColor(Color color) {
        this.bgColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 50);
        this.cbi = new ColorCheckBoxIcon(color, this.big);
        this.setIcon(this.cbi);
    }

    @Override
    public void setSelected(boolean bl) {
        super.setSelected(bl);
        this.model.setSelected(bl);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.drawBackground) {
            graphics.setColor(this.bgColor);
            graphics.fillRoundRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, 8, 8);
        }
        super.paintComponent(graphics);
    }

    public class ColorCheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private Color color;
        private boolean big;
        private static final long serialVersionUID = 1L;

        public ColorCheckBoxIcon(Color color, boolean bl) {
            this.color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 120);
            this.big = bl;
        }

        protected int getControlSize() {
            return 16;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JCheckBox jCheckBox = (JCheckBox)component;
            ButtonModel buttonModel = jCheckBox.getModel();
            int n3 = this.getControlSize();
            boolean bl = buttonModel.isSelected();
            if (buttonModel.isEnabled()) {
                graphics.setColor(this.color);
                graphics.fillRoundRect(n, n2 + 1, n3 - 1, n3 - 1, 3, 3);
            } else {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.drawRect(n, n2, n3 - 1, n3 - 1);
            }
            if (bl) {
                graphics.setColor(Color.DARK_GRAY);
                if (this.big) {
                    this.drawBigCheck(component, graphics, n, n2);
                } else {
                    this.drawCheck(component, graphics, n, n2);
                }
            }
        }

        protected void drawCheck(Component component, Graphics graphics, int n, int n2) {
            int n3 = this.getControlSize();
            graphics.fillRect(n + 3, n2 + 5, 2, n3 - 8);
            graphics.drawLine(n + (n3 - 4), n2 + 3, n + 5, n2 + (n3 - 6));
            graphics.drawLine(n + (n3 - 4), n2 + 4, n + 5, n2 + (n3 - 5));
        }

        protected void drawBigCheck(Component component, Graphics graphics, int n, int n2) {
            int n3 = this.getControlSize();
            graphics.fillRect((n += 2) + 2, n2 + 3, 3, n3 - 4);
            graphics.drawLine(n + n3, n2 - 2, n + 5, n2 + (n3 - 7));
            graphics.drawLine(n + n3, n2 - 2, n + 5, n2 + (n3 - 6));
            graphics.drawLine(n + n3, n2 - 2, n + 5, n2 + (n3 - 5));
            graphics.drawLine(n + n3, n2 - 2, n + 5, n2 + (n3 - 4));
        }

        @Override
        public int getIconWidth() {
            return this.getControlSize();
        }

        @Override
        public int getIconHeight() {
            return this.getControlSize();
        }
    }
}

